/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.util.AdvancedDateChooser;
import de.cni.client.gui.util.IWrapper;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.Brand;
import de.cni.common.core.GlobalData;
import de.jaret.util.ui.datechooser.DateChooser;
import java.util.Date;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DateChooserWrapper
implements IWrapper<DateChooser> {
    String id;
    AdvancedDateChooser widget;
    Date value;
    boolean active = true;
    Font defaultFont = GlobalData.getInstance().getDefaultFont();

    public DateChooserWrapper() {
        this.widget = null;
        this.active = false;
    }

    public DateChooserWrapper(Brand[] brands, Composite parent, int style) {
        if (ApplicationProperties.getInstance().hasBrand(brands)) {
            this.widget = new AdvancedDateChooser(parent, style, 100);
            this.widget.setFont(this.defaultFont);
            this.widget.getChildren()[0].setFont(this.defaultFont);
        } else {
            this.widget = null;
            this.active = false;
        }
    }

    public void setValue(Date date) {
        this.value = date;
        if (this.widget != null) {
            this.widget.setInitialValue(this.value);
            this.widget.setDate(this.value);
        }
    }

    public Date getValue() {
        if (this.widget != null) {
            this.value = this.widget.getDate();
        }
        return this.value;
    }

    @Override
    public Control getControlWidget() {
        return this.widget;
    }

    @Override
    public AdvancedDateChooser getWidget() {
        return this.widget;
    }

    public void addTraverseListener(TraverseListener listener) {
        Control c = this.getControlWidget();
        if (c != null) {
            c.addTraverseListener(listener);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setFocus() {
        if (this.widget != null) {
            this.widget.setFocus();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

