/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.tiles.tree.templates;

import de.cni.client.gui.popup.page.IDoubleClickHandler;
import de.cni.client.gui.templates.treeAndDetail.ITreeDetailPageController;
import de.cni.client.gui.tiles.tree.templates.ITreeController;
import de.cni.client.gui.tiles.tree.templates.ITreeListener;
import de.cni.client.gui.tiles.tree.templates.TreeViewerTile;
import de.cni.common.core.GlobalData;
import de.cni.common.datamodel.IBusinessTreeObject;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;

public class TreeController
implements ITreeController {
    private static Log log = LogFactory.getLog(TreeController.class);
    TreeViewerTile treeViewerTile;
    protected List<IBusinessTreeObject> objectList;
    protected IBusinessTreeObject selectedObject;
    protected ITreeController.PageSelectionStatus pageSelectionStatus;
    protected ITreeListener listener;
    protected IDoubleClickHandler doubleClickHandler;
    protected String treeName = "";
    ILabelProvider labelProvider = null;
    String canceledText = "";
    boolean presetCancelFlag = false;

    public TreeController(String treeName, String canceledText, boolean presetCancelFlag, ILabelProvider labelProvider) {
        this.treeName = treeName;
        this.canceledText = canceledText;
        this.labelProvider = labelProvider;
        this.presetCancelFlag = presetCancelFlag;
    }

    @Override
    public void createContent(SashForm treeDetailSash, int treeHeight) {
        this.treeViewerTile = new TreeViewerTile(this, this.treeName, this.canceledText, this.presetCancelFlag);
        this.treeViewerTile.createContent((Composite)treeDetailSash, treeHeight, this.labelProvider);
        this.treeViewerTile.refreshButtons();
    }

    @Override
    public List<IBusinessTreeObject> getObjectList() {
        return this.objectList;
    }

    @Override
    public List<IBusinessTreeObject> getSelectedObjects() {
        return this.treeViewerTile.getSelectedObjects();
    }

    @Override
    public void registerListener(ITreeDetailPageController controller) {
        this.listener = controller;
        this.treeViewerTile.registerPopupManager(controller);
    }

    @Override
    public void setObjectList(List<IBusinessTreeObject> businessObjectList) {
        this.objectList = businessObjectList;
        this.treeViewerTile.setData();
        this.treeViewerTile.setChangedFlag(false);
        if (GlobalData.getInstance().isExpandTree()) {
            // empty if block
        }
    }

    @Override
    public void setSelection(IBusinessTreeObject businessTreeObject) {
        this.treeViewerTile.setSelection(businessTreeObject);
    }

    @Override
    public void selectionChanged(IBusinessTreeObject firstObject, int cnt) {
        if (this.listener != null) {
            this.listener.selectionChanged(firstObject, cnt);
        }
        if (cnt == 0) {
            this.pageSelectionStatus = ITreeController.PageSelectionStatus.noSelection;
        } else if (cnt == 1) {
            this.selectedObject = firstObject;
            this.pageSelectionStatus = ITreeController.PageSelectionStatus.oneLineSelected;
        } else {
            this.pageSelectionStatus = ITreeController.PageSelectionStatus.multiLinesSelected;
        }
        this.treeViewerTile.refreshButtons();
    }

    @Override
    public void doubleClick(IBusinessTreeObject object) {
        this.listener.doubleClick(object);
    }

    public IDoubleClickHandler getDoubleClickHandler() {
        return this.doubleClickHandler;
    }

    public void setDoubleClickHandler(IDoubleClickHandler doubleClickHandler) {
        this.doubleClickHandler = doubleClickHandler;
    }

    @Override
    public void deleteCurrentObject() {
        log.debug((Object)"deleteCurrentObject - Start");
        this.listener.deleteObject(this.selectedObject);
        log.debug((Object)"deleteCurrentObject - Ende");
    }

    @Override
    public boolean withCanceledPressed() {
        return this.listener.refreshTree();
    }

    @Override
    public boolean withCanceled() {
        return this.treeViewerTile.withCanceledItems();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.treeViewerTile.setEnabled(enabled);
    }
}

