/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.tiles.table.templates;

import de.cni.client.gui.tiles.table.templates.ITableComposite;
import de.cni.client.gui.tiles.table.templates.ITableViewerSorter;
import de.cni.client.gui.tiles.table.templates.SortableTableComposite;
import de.cni.client.gui.tiles.table.templates.SortableTableViewerSorter;
import de.cni.client.gui.tiles.table.templates.TableCellModifier;
import de.cni.client.gui.tiles.table.templates.TableController;
import de.cni.client.gui.util.Resources;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.core.Util;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;

public abstract class SortableTableController
extends TableController {
    public static final boolean WITH_DELETE_BUTTON = true;
    public static final boolean WITHOUT_DELETE_BUTTON = false;
    public static final boolean WITH_NEW_BUTTON = true;
    public static final boolean WITHOUT_NEW_BUTTON = false;
    protected ITableLabelProvider labelProvider = this.createLabelProvider();
    boolean withNewButton;
    boolean withDeleteButton;
    boolean withCustomButton;
    Resources.ICON customIcon;
    String customTip;

    public SortableTableController(boolean withNewButton, boolean withDeleteButton) {
        this.withNewButton = withNewButton;
        this.withDeleteButton = withDeleteButton;
    }

    public SortableTableController(boolean withNewButton, boolean withDeleteButton, Resources.ICON customIcon, String customTip) {
        this.withNewButton = withNewButton;
        this.withDeleteButton = withDeleteButton;
        this.withCustomButton = customIcon != null || !Util.isEmpty(customTip);
        this.customIcon = customIcon;
        this.customTip = customTip;
    }

    public SortableTableController() {
        this.withNewButton = false;
        this.withDeleteButton = true;
    }

    public void setDefaultSort(int column, boolean direction) {
        if (this.tableComposite instanceof SortableTableComposite) {
            ((SortableTableComposite)this.tableComposite).setDefaultSort(column, direction);
        }
    }

    @Override
    public void newLine() {
        if (this.listener != null) {
            this.listener.newLine();
        }
    }

    @Override
    public void up() {
    }

    @Override
    public void down() {
    }

    @Override
    public boolean isFirstElement(Object o) {
        return false;
    }

    @Override
    public boolean isLastElement(Object o) {
        return false;
    }

    @Override
    public final ITableComposite createTableComposite() {
        return new SortableTableComposite(this, this.groupname, this.columnNameArray, this.columnWidthArray, this.alignmentArray, this.withNewButton, this.withDeleteButton, this.customIcon, this.customTip);
    }

    @Override
    public final ITableViewerSorter createTableViewerSorter() {
        return new SortableTableViewerSorter(this);
    }

    @Override
    public final TableCellModifier createCellModifier(TableViewer tableViewer, WidgetFactory guiUtil) {
        return null;
    }

    @Override
    public int compare(int column, Object o1, Object o2) {
        int rc = 0;
        if (this.labelProvider != null) {
            rc = Util.compare(this.labelProvider.getColumnText(o1, column), this.labelProvider.getColumnText(o2, column));
        }
        return rc;
    }
}

