/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.tiles.table.templates;

import de.cni.client.gui.tiles.table.templates.EditableTableComposite;
import de.cni.client.gui.tiles.table.templates.EditableTableViewerSorter;
import de.cni.client.gui.tiles.table.templates.ITableComposite;
import de.cni.client.gui.tiles.table.templates.ITableViewerSorter;
import de.cni.client.gui.tiles.table.templates.TableCellModifier;
import de.cni.client.gui.tiles.table.templates.TableController;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.datamodel.IEditableTableObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;

public abstract class EditableTableController
extends TableController {
    private static Log log = LogFactory.getLog(EditableTableController.class);
    public static final boolean WITH_SORT_BUTTONS = true;
    public static final boolean WITHOUT_SORT_BUTTONS = false;
    boolean withSortButtons;

    public EditableTableController(boolean withSortButtons) {
        this.withSortButtons = withSortButtons;
    }

    public EditableTableController() {
        this.withSortButtons = true;
    }

    @Override
    public abstract ITableLabelProvider createLabelProvider();

    @Override
    public abstract TableCellModifier createCellModifier(TableViewer var1, WidgetFactory var2);

    @Override
    public void newLine() {
    }

    @Override
    public final ITableComposite createTableComposite() {
        return new EditableTableComposite(this, this.groupname, this.columnNameArray, this.columnWidthArray, this.alignmentArray, this.withSortButtons);
    }

    @Override
    public final ITableViewerSorter createTableViewerSorter() {
        return new EditableTableViewerSorter(this);
    }

    @Override
    public void deleteLine() {
        log.debug((Object)"deleteLine - Start");
        this.objectList.remove(this.selectedObject);
        int sortId = ((IEditableTableObject)this.selectedObject).getSortId();
        for (IEditableTableObject object : this.objectList) {
            if (object.getSortId() <= sortId) continue;
            object.setSortId(object.getSortId() - 1);
        }
        this.tableComposite.setData();
        log.debug((Object)"deleteLine - Ende");
    }

    @Override
    public void up() {
        log.debug((Object)"up - Start");
        int sortId = ((IEditableTableObject)this.selectedObject).getSortId();
        for (IEditableTableObject object : this.objectList) {
            if (object.getSortId() != sortId - 1) continue;
            object.setSortId(sortId);
            ((IEditableTableObject)this.selectedObject).setSortId(sortId - 1);
            ((IEditableTableObject)this.selectedObject).setModified(true);
        }
        this.tableComposite.setData();
        this.tableComposite.refreshButtons();
        log.debug((Object)"up - Ende");
    }

    @Override
    public void down() {
        log.debug((Object)"down - Start");
        int sortId = ((IEditableTableObject)this.selectedObject).getSortId();
        for (IEditableTableObject object : this.objectList) {
            if (object.getSortId() != sortId + 1) continue;
            object.setSortId(sortId);
            object.setModified(true);
            ((IEditableTableObject)this.selectedObject).setSortId(sortId + 1);
            ((IEditableTableObject)this.selectedObject).setModified(true);
        }
        this.tableComposite.setData();
        this.tableComposite.refreshButtons();
        log.debug((Object)"down - Ende");
    }

    @Override
    public final boolean isFirstElement(Object o) {
        return ((IEditableTableObject)o).getSortId() == 1;
    }

    @Override
    public final boolean isLastElement(Object o) {
        return ((IEditableTableObject)o).getSortId() == this.objectList.size();
    }

    @Override
    public final int compare(int column, Object o1, Object o2) {
        return 0;
    }
}

