/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.tiles.table;

import de.cni.client.gui.tiles.table.templates.LabelProvider;
import de.cni.client.gui.util.Resources;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.JobParameter;
import de.cni.common.datamodel.enumtypes.JobParameterTyp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Image;

public class JobParameterLabelProvider
extends LabelProvider {
    private static Log log = LogFactory.getLog(JobParameterLabelProvider.class);

    @Override
    public String getColumnText(Object element, int columnIndex) {
        try {
            JobParameter jobParameter = (JobParameter)element;
            if (columnIndex == 1) {
                return Integer.toString(jobParameter.getSortId());
            }
            if (columnIndex == 2) {
                return JobParameterTyp.getNameById(jobParameter.getTyp());
            }
            if (columnIndex == 6) {
                return Util.NotNull(jobParameter.getParameterName());
            }
            if (columnIndex == 7) {
                return Util.NotNull(jobParameter.getGuiName());
            }
            if (columnIndex == 8) {
                return Util.NotNull(jobParameter.getVarName());
            }
            if (columnIndex == 9) {
                return Util.NotNull(jobParameter.getButtonName());
            }
            if (columnIndex == 10) {
                return Util.NotNull(jobParameter.getVorgabe());
            }
            if (columnIndex == -1) {
                return Util.NotNull(jobParameter.getBeschreibung());
            }
            if (columnIndex == 11) {
                return Util.NotNull(jobParameter.getFix());
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return "";
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        try {
            JobParameter jobParameter = (JobParameter)element;
            if (columnIndex == 3) {
                if (jobParameter.isBereich()) {
                    return Resources.getInstance().getImage(Resources.ICON.BOOLEAN_TRUE);
                }
                return Resources.getInstance().getImage(Resources.ICON.BOOLEAN_FALSE);
            }
            if (columnIndex == 4) {
                if (jobParameter.isFilter()) {
                    return Resources.getInstance().getImage(Resources.ICON.BOOLEAN_TRUE);
                }
                return Resources.getInstance().getImage(Resources.ICON.BOOLEAN_FALSE);
            }
            if (columnIndex == 5) {
                if (jobParameter.isSort()) {
                    return Resources.getInstance().getImage(Resources.ICON.BOOLEAN_TRUE);
                }
                return Resources.getInstance().getImage(Resources.ICON.BOOLEAN_FALSE);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return null;
    }
}

