/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.templates.treeAndDetail;

import de.cni.client.calculation.CalculatorFactoryClient;
import de.cni.client.gui.action.toolbar.DropDownAction;
import de.cni.client.gui.action.toolbar.EditAction;
import de.cni.client.gui.action.toolbar.IDropDownNewable;
import de.cni.client.gui.action.toolbar.IEditable;
import de.cni.client.gui.action.toolbar.IHistory;
import de.cni.client.gui.action.toolbar.IRefreshable;
import de.cni.client.gui.action.toolbar.ISaveable;
import de.cni.client.gui.action.toolbar.ISearchable;
import de.cni.client.gui.action.toolbar.RefreshAction;
import de.cni.client.gui.action.toolbar.SaveAction;
import de.cni.client.gui.action.toolbar.SearchAction;
import de.cni.client.gui.pageflow.IPageController;
import de.cni.client.gui.pageflow.PageController;
import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.page.IDoubleClickHandler;
import de.cni.client.gui.templates.filter.IFilterController;
import de.cni.client.gui.templates.treeAndDetail.ITreeDetailPage;
import de.cni.client.gui.templates.treeAndDetail.ITreeDetailPageController;
import de.cni.client.gui.templates.treeAndDetail.TreeManipulator;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.Brand;
import de.cni.common.core.ClassUtils;
import de.cni.common.core.GlobalData;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.IBusinessTreeObject;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.CalculationException;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.validation.IValidator;
import de.cni.common.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Composite;

public abstract class TreeDetailPageController
extends PageController
implements ITreeDetailPageController,
IPageController,
IFilterController,
IDropDownNewable,
ISaveable,
IEditable,
IRefreshable,
ISearchable,
IHistory {
    private static Log log = LogFactory.getLog(TreeDetailPageController.class);
    protected Date now = new Date();
    protected static boolean LOAD_ALL_DATA_DURING_INITIALIZATION = true;
    protected static boolean DO_NOT_LOAD_ALL_DATA_DURING_INITIALIZATION = false;
    protected ITreeDetailPage treeDetailPage;
    protected InitialContext context;
    protected List<IBusinessTreeObject> businessObjectList;
    protected IBusinessObject currentFilter;
    protected IBusinessTreeObject currentBusinessObject;
    protected IPageController.PageSelectionStatus pageSelectionStatus;
    protected IPageController.PageEditStatus pageEditStatus;
    protected List<IContributionItem> toolbarItems;
    boolean loadAllDataDuringInitialization;
    boolean processIsActive = false;
    protected IDoubleClickHandler doubleClickHandler;
    IValidator validator = null;

    protected void addToolbarItem(ActionContributionItem item) {
        if (this.toolbarItems == null) {
            this.toolbarItems = new ArrayList<IContributionItem>();
        }
        this.toolbarItems.add((IContributionItem)item);
    }

    protected void addToolbarItem(Brand brand, ActionContributionItem item) {
        if (GlobalData.getInstance().getBrand() == brand) {
            this.addToolbarItem(item);
        }
    }

    public TreeDetailPageController(boolean loadAllDataDuringInitialization) {
        try {
            this.loadAllDataDuringInitialization = loadAllDataDuringInitialization;
            this.addToolbarItem(new ActionContributionItem((IAction)new DropDownAction(this)));
            this.addToolbarItem(new ActionContributionItem((IAction)new SaveAction(this)));
            this.addToolbarItem(new ActionContributionItem((IAction)new EditAction(this)));
            this.addToolbarItem(new ActionContributionItem((IAction)new RefreshAction(this)));
            this.pageSelectionStatus = IPageController.PageSelectionStatus.noSelection;
            this.pageEditStatus = IPageController.PageEditStatus.disabled;
            log.debug((Object)"TreeDetailPageController initialisiert.");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("technischer Fehler. " + e.getMessage()));
        }
    }

    @Override
    public IPageController getPageController() {
        return this;
    }

    @Override
    public void initializeValue(Object initValue) {
        this.businessObjectList = new ArrayList<IBusinessTreeObject>();
        this.currentBusinessObject = initValue != null ? (IBusinessTreeObject)initValue : this.createNewBusinessObject();
        log.debug((Object)"Initiale Werte gesetzt");
    }

    @Override
    public void openPage(Composite parent) {
        this.pageSelectionStatus = IPageController.PageSelectionStatus.noSelection;
        this.pageEditStatus = IPageController.PageEditStatus.disabled;
        this.treeDetailPage = this.createNewTreeDetailPage(this);
        this.treeDetailPage.createContent(parent);
        this.getToolbarWrapper().initialize(MainApplicationWindow.getInstance().getToolBarManager());
        this.getToolbarWrapper().setToolbar(this.toolbarItems);
        this.treeDetailPage.handleSelectionChanged();
        this.treeDetailPage.handleEditChanged();
        parent.layout();
        this.businessObjectList = new ArrayList<IBusinessTreeObject>();
        this.treeDetailPage.setData(this.businessObjectList);
        this.clearFilter();
        if (this.loadAllDataDuringInitialization) {
            SearchAction action = new SearchAction(this);
            action.run();
        }
    }

    @Override
    public void refresh() {
        try {
            if (this.currentFilter != null) {
                this.select(this.currentFilter);
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    @Override
    public void search() {
        try {
            IBusinessObject filter;
            this.currentFilter = filter = this.treeDetailPage.getFilter();
            this.select(filter);
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    private void select(IBusinessObject filter) {
        try {
            filter = this.enhanceFilter(filter);
            if (!this.checkFilter(filter)) {
                return;
            }
            List<IBusinessTreeObject> selectedList = this.getServerBean().select(filter);
            this.postSelectAction(selectedList);
            if (!this.isSelectionValid(selectedList)) {
                return;
            }
            this.businessObjectList = selectedList;
            this.pageEditStatus = IPageController.PageEditStatus.disabled;
            this.treeDetailPage.setData(this.businessObjectList);
            this.setSelection(this.currentBusinessObject);
            this.treeDetailPage.handleSelectionChanged();
            this.treeDetailPage.handleEditChanged();
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
            e.printStackTrace();
            this.initializeValue(null);
        }
    }

    @Override
    public void selectionChanged(Object object, int cnt) {
        try {
            if (this.processIsActive) {
                return;
            }
            this.processIsActive = true;
            IBusinessTreeObject firstBusinessObject = (IBusinessTreeObject)object;
            if (cnt == 0 || cnt == 1 && firstBusinessObject == this.currentBusinessObject) {
                this.processIsActive = false;
                return;
            }
            if (cnt > 1) {
                this.treeDetailPage.setSelection(this.currentBusinessObject);
                this.processIsActive = false;
                return;
            }
            if (firstBusinessObject != this.currentBusinessObject) {
                int answer = this.discardChangesPopup();
                if (answer == 2) {
                    this.treeDetailPage.setSelection(this.currentBusinessObject);
                    this.processIsActive = false;
                    return;
                }
                if (answer == 0) {
                    this.treeDetailPage.setSelection(firstBusinessObject);
                }
            }
            this.pageEditStatus = IPageController.PageEditStatus.disabled;
            this.treeDetailPage.setEnabled(false);
            if (cnt == 1) {
                this.setCurrentBusinessObject(firstBusinessObject);
                log.debug((Object)("selected id: " + firstBusinessObject.getId()));
                this.treeDetailPage.setBusinessObject(this.currentBusinessObject);
            } else {
                this.treeDetailPage.setBusinessObject(this.createNewBusinessObject());
            }
            if (cnt == 0) {
                this.pageSelectionStatus = IPageController.PageSelectionStatus.noSelection;
                this.pageEditStatus = IPageController.PageEditStatus.disabled;
            } else if (cnt == 1) {
                this.pageSelectionStatus = IPageController.PageSelectionStatus.oneLineSelected;
            } else {
                this.pageSelectionStatus = IPageController.PageSelectionStatus.multiLinesSelected;
                this.pageEditStatus = IPageController.PageEditStatus.disabled;
            }
            this.treeDetailPage.handleSelectionChanged();
            this.treeDetailPage.handleEditChanged();
            this.processIsActive = false;
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
            this.processIsActive = false;
        }
    }

    @Override
    public void doubleClick(Object object) {
        if (this.doubleClickHandler != null) {
            this.doubleClickHandler.onDoubleClick(object);
        }
    }

    @Override
    public void save() throws DatabaseException, CalculationException {
        IBusinessTreeObject bo = this.treeDetailPage.getBusinessObject();
        if (bo == null) {
            return;
        }
        this.currentBusinessObject = bo;
        CalculatorFactoryClient.createCalculator(this.currentBusinessObject).prepareSave(this.currentBusinessObject);
        IBusinessTreeObject objectBeforeSave = this.currentBusinessObject;
        long start = System.currentTimeMillis();
        IBusinessTreeObject savedBusinessObject = null;
        IBusinessTreeObject root = savedBusinessObject = this.getServerBean().save(this.currentBusinessObject, IBusinessObjectVerwaltung.Caller.MASK);
        while (root.getParent() != null) {
            root = root.getParent();
        }
        IBusinessTreeObject rootBeforeSave = objectBeforeSave;
        while (rootBeforeSave.getParent() != null) {
            rootBeforeSave = rootBeforeSave.getParent();
        }
        TreeManipulator.createOrReplaceInTree(rootBeforeSave.getId(), this.businessObjectList, root);
        this.postSelectAction(this.businessObjectList);
        long stop = System.currentTimeMillis();
        long diff = stop - start;
        log.debug((Object)("Zum Speichern ben\u00f6tigte Zeit (ms): " + diff));
        this.treeDetailPage.setBusinessObject(savedBusinessObject);
        this.treeDetailPage.setSelection(savedBusinessObject);
        this.pageEditStatus = IPageController.PageEditStatus.disabled;
        this.pageSelectionStatus = IPageController.PageSelectionStatus.oneLineSelected;
        this.treeDetailPage.handleSelectionChanged();
        this.treeDetailPage.handleEditChanged();
        this.currentBusinessObject = savedBusinessObject;
        this.treeDetailPage.setChanged(false);
        this.postSaveAction(objectBeforeSave);
    }

    public void setBusinessObject(IBusinessTreeObject object) {
        TreeManipulator.createOrReplaceInTree(object.getId(), this.businessObjectList, object);
        this.treeDetailPage.setBusinessObject(object);
        this.treeDetailPage.setSelection(object);
        this.pageEditStatus = IPageController.PageEditStatus.disabled;
        this.pageSelectionStatus = IPageController.PageSelectionStatus.oneLineSelected;
        this.treeDetailPage.handleSelectionChanged();
        this.treeDetailPage.handleEditChanged();
        this.currentBusinessObject = object;
        this.treeDetailPage.setChanged(false);
    }

    public void undo() {
        try {
            this.treeDetailPage.setBusinessObject(this.currentBusinessObject);
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    public boolean deleteLine() {
        try {
            IBusinessTreeObject parent = null;
            if (!MainApplicationWindow.getInstance().popupQuestion("M\u00f6chten Sie den Datensatz wirklich l\u00f6schen?")) {
                return false;
            }
            this.pageEditStatus = IPageController.PageEditStatus.disabled;
            Iterator<IBusinessTreeObject> iterator = this.treeDetailPage.getSelectedBusinessObject().iterator();
            while (iterator.hasNext()) {
                IBusinessTreeObject object;
                IBusinessTreeObject businessObject = object = iterator.next();
                parent = businessObject.getParent();
                log.info((Object)("L\u00f6schen von Business-Objekt id=" + businessObject.getId()));
                if (businessObject.getId() > 0) {
                    this.getServerBean().delete(businessObject);
                }
                this.businessObjectList.remove(businessObject);
            }
            this.treeDetailPage.setSelection(parent);
            this.treeDetailPage.handleSelectionChanged();
            this.treeDetailPage.clear();
            this.treeDetailPage.handleEditChanged();
            this.treeDetailPage.refresh();
            return true;
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
            return false;
        }
    }

    @Override
    public void edit() {
        log.debug((Object)"edit aufgerufen");
        this.pageEditStatus = this.pageEditStatus != IPageController.PageEditStatus.disabled ? IPageController.PageEditStatus.disabled : (this.currentBusinessObject.getId() == 0 ? IPageController.PageEditStatus.enabledforNew : IPageController.PageEditStatus.enabledforUpdate);
        this.treeDetailPage.handleEditChanged();
    }

    @Override
    public IBusinessTreeObject getCurrentBusinessObject() {
        return this.currentBusinessObject;
    }

    @Override
    public List<IBusinessTreeObject> getBusinessObjectList() {
        return this.businessObjectList;
    }

    @Override
    public void setBusinessObjectList(List<IBusinessTreeObject> businessObjectList) {
        this.businessObjectList = businessObjectList;
    }

    @Override
    public IPageController.PageSelectionStatus getPageSelectionStatus() {
        return this.pageSelectionStatus;
    }

    @Override
    public IPageController.PageEditStatus getPageEditStatus() {
        return this.pageEditStatus;
    }

    @Override
    public void setPageSelectionStatus(IPageController.PageSelectionStatus pageSelectionStatus) {
        this.pageSelectionStatus = pageSelectionStatus;
    }

    @Override
    public void setPageEditStatus(IPageController.PageEditStatus pageEditStatus) {
        this.pageEditStatus = pageEditStatus;
    }

    @Override
    public boolean isDataChanged() {
        return this.treeDetailPage.isDataChanged();
    }

    public void setSelection(IBusinessTreeObject businessObject) {
        try {
            boolean found = false;
            businessObject = TreeManipulator.findInTree(this.businessObjectList, businessObject);
            if (businessObject == null && this.businessObjectList != null && this.businessObjectList.size() > 0 && (businessObject = TreeManipulator.findInTree(this.businessObjectList, this.businessObjectList.get(0))) != null) {
                this.setCurrentBusinessObject(businessObject);
                this.setBusinessObject(businessObject);
            }
            this.setCurrentBusinessObject(businessObject);
            if (businessObject != null) {
                found = true;
            }
            if (!found || this.currentBusinessObject.isCanceled(this.now) && !this.treeDetailPage.showCanceled()) {
                this.treeDetailPage.clear();
            } else {
                this.treeDetailPage.setBusinessObject(this.currentBusinessObject);
                this.treeDetailPage.setSelection(this.currentBusinessObject);
                this.treeDetailPage.handleSelectionChanged();
                this.treeDetailPage.handleEditChanged();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    @Override
    public IBusinessObject enhanceFilter(IBusinessObject filter) {
        return filter;
    }

    @Override
    public boolean checkFilter(IBusinessObject filter) {
        return true;
    }

    @Override
    protected void doDiscardChanges() {
        if (this.currentBusinessObject.getId() == 0) {
            if (TreeManipulator.removeFromTree(this.businessObjectList, this.currentBusinessObject)) {
                this.treeDetailPage.setData(this.businessObjectList);
            }
        } else {
            try {
                this.currentBusinessObject = this.getServerBean().select(this.currentBusinessObject.getId(), this.currentBusinessObject.getClass());
                TreeManipulator.createOrReplaceInTree(this.currentBusinessObject.getId(), this.businessObjectList, this.currentBusinessObject);
                this.setCurrentBusinessObject(this.currentBusinessObject);
                this.treeDetailPage.setData(this.businessObjectList);
            }
            catch (Exception e) {
                ErrorHandler.handleError(log, e.getMessage() + "\nBitte f\u00fchren Sie einen Refresh durch");
            }
        }
    }

    protected boolean isSelectionValid(List<IBusinessTreeObject> selectedList) {
        return true;
    }

    @Override
    public boolean isSaveable() {
        boolean ret = true;
        IBusinessTreeObject bo = this.treeDetailPage.getBusinessObject();
        this.validator = ValidatorFactory.createValidator(bo, GlobalData.getInstance().getBrand());
        if (this.validator != null) {
            ret = this.validator.isValid(bo);
        }
        return ret;
    }

    @Override
    public String getSaveableValidationError() {
        if (this.validator != null && !Util.isEmpty(this.validator.getErrorText())) {
            return this.validator.getErrorText();
        }
        return "";
    }

    protected void postSaveAction(IBusinessTreeObject oldObject) {
    }

    protected void postSelectAction(List<IBusinessTreeObject> businessObjectList) {
    }

    @Override
    public abstract IBusinessTreeObject createNewBusinessObject();

    @Override
    public abstract ITreeDetailPage createNewTreeDetailPage(ITreeDetailPageController var1);

    protected abstract IBusinessObjectVerwaltung<IBusinessTreeObject> getServerBean();

    @Override
    public abstract void setCurrentBusinessObject(IBusinessTreeObject var1);

    public IDoubleClickHandler getDoubleClickHandler() {
        return this.doubleClickHandler;
    }

    public void setDoubleClickHandler(IDoubleClickHandler doubleClickHandler) {
        this.doubleClickHandler = doubleClickHandler;
    }

    @Override
    public void deleteObject(Object object) {
        try {
            IBusinessTreeObject parent = null;
            if (object == null) {
                return;
            }
            IBusinessTreeObject bo = (IBusinessTreeObject)object;
            parent = bo.getParent();
            if (parent == null && this.businessObjectList != null && this.businessObjectList.size() > 0) {
                parent = this.businessObjectList.get(0);
            }
            log.debug((Object)("L\u00f6schen des Objects " + ClassUtils.getClassName(bo.getClass()) + " id=" + bo.getId()));
            if (Popup.question("Soll dieser Datensatz zusammen mit allen Unterobjekten wirklich gel\u00f6scht werden?")) {
                IBusinessObjectVerwaltung<IBusinessTreeObject> bean = this.getServerBean();
                bean.delete(bo);
                TreeManipulator.removeFromTree(this.businessObjectList, bo);
                this.treeDetailPage.setData(this.businessObjectList);
                this.treeDetailPage.setSelection(parent);
            }
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    @Override
    public boolean refreshTree() {
        if (this.isDiscardChanges()) {
            this.setSelection(this.currentBusinessObject);
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        return this.getPage().getTitle();
    }

    @Override
    public void setFocusOnFilterHeader() {
        this.treeDetailPage.getFilterHeaderTile().setFocus();
    }
}

