/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.templates.tableAndDetail;

import de.cni.client.gui.action.toolbar.EditAction;
import de.cni.client.gui.action.toolbar.SaveAction;
import de.cni.client.gui.pageflow.IPageController;
import de.cni.client.gui.templates.filter.IFilterHeaderTile;
import de.cni.client.gui.templates.tableAndDetail.IDetailTile;
import de.cni.client.gui.templates.tableAndDetail.ITableDetailPage;
import de.cni.client.gui.templates.tableAndDetail.ITableDetailPageController;
import de.cni.client.gui.tiles.table.templates.ITableController;
import de.cni.client.gui.util.BusinessObjectStatusTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.GuiContainer;
import de.cni.common.core.GlobalData;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.exceptions.MappingException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public abstract class TableDetailPage
implements ITableDetailPage {
    private static Log log = LogFactory.getLog(TableDetailPage.class);
    public static int MAX_TABLE_HEIGHT = 0;
    int[] tableDetailWeightsUnvisible = new int[]{0, 1, 0};
    int[] tableDetailWeights = new int[]{2, 3, 0};
    int tableHeight = 0;
    final int layoutNumColumns = 3;
    protected ITableController tableController;
    Composite parent;
    protected ITableDetailPageController controller;
    IFilterHeaderTile filterTile;
    IDetailTile detailTile;
    IBusinessObject emptyObject = null;
    BusinessObjectStatusTile boStatusTile = new BusinessObjectStatusTile();
    protected boolean scrollable = true;
    public SashForm tableDetailSash;

    public TableDetailPage(ITableDetailPageController controller) {
        this.controller = controller;
        this.emptyObject = this.createBusinessObject();
    }

    public TableDetailPage(ITableDetailPageController controller, int tableHeight, int[] weightsHighRes, int[] weightsLowRes) {
        this.controller = controller;
        this.emptyObject = this.createBusinessObject();
        this.tableDetailWeights = GlobalData.getInstance().isHighResolution() ? weightsHighRes : weightsLowRes;
        this.tableHeight = tableHeight;
    }

    public TableDetailPage(ITableDetailPageController controller, int tableHeight) {
        this.controller = controller;
        this.emptyObject = this.createBusinessObject();
        this.tableHeight = tableHeight;
    }

    public TableDetailPage(ITableDetailPageController controller, int[] weightsHighRes, int[] weightsLowRes) {
        this.controller = controller;
        this.emptyObject = this.createBusinessObject();
        this.tableDetailWeights = GlobalData.getInstance().isHighResolution() ? weightsHighRes : weightsLowRes;
    }

    @Override
    public Composite createContent(Composite parent) {
        try {
            this.parent = parent;
            Composite pageComposite = GuiContainer.newFillComposite(parent, 1);
            this.filterTile = this.createFilterTile(this.controller, this.tableDetailWeights);
            this.filterTile.createContent(pageComposite);
            GridData detailGridData = new GridData(1808);
            detailGridData.grabExcessHorizontalSpace = true;
            this.tableDetailSash = new SashForm(pageComposite, 256);
            this.tableDetailSash.setLayoutData((Object)detailGridData);
            this.tableController = this.createTableController();
            this.tableController.createContent((Composite)this.tableDetailSash, this.tableHeight);
            this.tableController.registerListener(this.controller);
            ScrolledComposite sc = null;
            Composite rightComposite = null;
            if (this.scrollable) {
                sc = GuiContainer.newScrolledComposite((Composite)this.tableDetailSash);
                rightComposite = GuiContainer.newComposite((Composite)sc, 1);
            } else {
                rightComposite = GuiContainer.newComposite((Composite)this.tableDetailSash, 1);
            }
            this.detailTile = this.createDetailTile(this.controller);
            this.detailTile.createContent(rightComposite);
            if (this.getNumberStatusLines() == 1) {
                this.boStatusTile.createContent(rightComposite, this.detailTile.getLabelColumnWidth());
            } else {
                this.boStatusTile.createContentWithTwoLines(rightComposite, this.detailTile.getLabelColumnWidth());
            }
            GuiContainer.configureScrolledComposite(sc, rightComposite);
            GuiContainer.newDummy((Composite)this.tableDetailSash);
            this.tableDetailSash.setWeights(this.tableDetailWeights);
            this.filterTile.setFocus();
            return pageComposite;
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void handleSelectionChanged() {
        if (this.controller.isPopupMode()) {
            return;
        }
        if (this.controller.getPageSelectionStatus() == IPageController.PageSelectionStatus.noSelection) {
            this.controller.getToolbarWrapper().setEnabled(EditAction.id, false);
        } else if (this.controller.getPageSelectionStatus() == IPageController.PageSelectionStatus.oneLineSelected) {
            this.controller.getToolbarWrapper().setEnabled(EditAction.id, true);
        } else if (this.controller.getPageSelectionStatus() == IPageController.PageSelectionStatus.multiLinesSelected) {
            this.controller.getToolbarWrapper().setEnabled(EditAction.id, false);
        }
    }

    @Override
    public void handleEditChanged() {
        if (this.controller.isPopupMode()) {
            this.setEnabled(false);
            this.controller.setFocusOnFilterHeader();
            return;
        }
        if (this.controller.getPageEditStatus() == IPageController.PageEditStatus.disabled) {
            this.setEnabled(GlobalData.getInstance().isAlwaysEnabled());
            this.controller.getToolbarWrapper().setEnabled(SaveAction.id, GlobalData.getInstance().isAlwaysEnabled());
        } else if (this.controller.getPageEditStatus() == IPageController.PageEditStatus.enabledforNew) {
            this.setEnabled(true);
            this.controller.getToolbarWrapper().setEnabled(SaveAction.id, true);
            this.detailTile.enableButtons(true);
        } else if (this.controller.getPageEditStatus() == IPageController.PageEditStatus.enabledforUpdate) {
            this.setEnabled(true);
            this.controller.getToolbarWrapper().setEnabled(SaveAction.id, true);
            this.detailTile.enableButtons(true);
            this.controller.setFocusOnFilterHeader();
        }
    }

    @Override
    public boolean isDataChanged() {
        return this.detailTile.isDataChanged();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.tableController.setEnabled(enabled);
        this.detailTile.setEnabled(enabled);
    }

    @Override
    public void refresh() {
        this.tableController.setObjectList(this.controller.getBusinessObjectList());
        this.setSelection(this.controller.getCurrentBusinessObject());
    }

    @Override
    public void clear() {
        try {
            this.setBusinessObject(this.emptyObject);
            this.setSelection(this.controller.getCurrentBusinessObject());
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    @Override
    public void setData(List<?> businessObjectList) {
        this.tableController.setObjectList(businessObjectList);
        this.setChanged(false);
    }

    @Override
    public List<IBusinessObject> getData() {
        return this.tableController.getObjectList();
    }

    @Override
    public void setFilter(IBusinessObject object) {
        try {
            this.filterTile.setPageFilterData(object);
        }
        catch (MappingException e) {
            ErrorHandler.handleError(log, e);
        }
    }

    @Override
    public IBusinessObject getFilter() {
        try {
            return this.filterTile.getPageFilterData();
        }
        catch (MappingException e) {
            ErrorHandler.handleError(log, e);
            return null;
        }
    }

    @Override
    public void setBusinessObject(IBusinessObject object) {
        try {
            this.detailTile.setData(object);
            this.boStatusTile.setData(object);
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    @Override
    public IBusinessObject getBusinessObject() {
        try {
            return this.detailTile.getData();
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
            return null;
        }
    }

    @Override
    public List<IBusinessObject> getSelectedBusinessObject() {
        return this.tableController.getSelectedObjects();
    }

    @Override
    public void setSelection(IBusinessObject businessObject) {
        this.tableController.setSelection(businessObject);
    }

    @Override
    public void setChanged(boolean flag) {
        this.detailTile.setDataChanged(flag);
    }

    @Override
    public IDetailTile getIDetailTile() {
        return this.detailTile;
    }

    @Override
    public void setIDetailTile(IDetailTile detailTile) {
        this.detailTile = detailTile;
    }

    @Override
    public int getNumberStatusLines() {
        return 1;
    }

    @Override
    public abstract ITableController createTableController();

    @Override
    public abstract IBusinessObject createBusinessObject();

    @Override
    public abstract IFilterHeaderTile createFilterTile(ITableDetailPageController var1, int[] var2);

    @Override
    public abstract IDetailTile createDetailTile(ITableDetailPageController var1);

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    @Override
    public IFilterHeaderTile getFilterHeaderTile() {
        return this.filterTile;
    }

    public boolean toogle() {
        boolean tableVisible = this.tableDetailSash.getChildren()[0].isVisible();
        tableVisible = !tableVisible;
        this.tableDetailSash.getChildren()[0].setVisible(tableVisible);
        if (tableVisible) {
            this.tableDetailSash.setWeights(this.tableDetailWeights);
        } else {
            this.tableDetailWeights = this.tableDetailSash.getWeights();
            this.tableDetailSash.setWeights(this.tableDetailWeightsUnvisible);
        }
        this.getFilterHeaderTile().toogle(tableVisible);
        return tableVisible;
    }
}

