/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.templates.tableAndDetail;

import de.cni.client.gui.templates.tableAndDetail.IDetailTile;
import de.cni.client.gui.templates.tableAndDetail.ITableDetailPageController;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.core.Mappings;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.exceptions.CalculationException;
import de.cni.common.exceptions.MappingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractDetailTile
implements IDetailTile {
    private static Log log = LogFactory.getLog(AbstractDetailTile.class);
    protected final int layoutNumColumns = 3;
    protected ITableDetailPageController controller;
    protected boolean scrollable = true;
    protected WidgetFactory guiUtil = new WidgetFactory(2);
    protected Mappings mapping = Mappings.getInstance();

    public AbstractDetailTile(ITableDetailPageController controller) {
        this.controller = controller;
    }

    @Override
    public void setEnabled(boolean enabled) {
        try {
            this.guiUtil.setEnabled(enabled);
            if (enabled && this.controller.getCurrentBusinessObject().getId() == 0) {
                this.setFocus();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    @Override
    public boolean isDataChanged() {
        return this.guiUtil.isChanged();
    }

    @Override
    public void setDataChanged(boolean flag) {
        this.guiUtil.setChanged(flag);
    }

    @Override
    public void enableButtons(boolean enable) {
    }

    @Override
    public abstract Composite createContent(Composite var1) throws MappingException;

    @Override
    public abstract IBusinessObject getData() throws MappingException, CalculationException;

    @Override
    public abstract void setData(IBusinessObject var1) throws MappingException;

    public void setFocus() {
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    @Override
    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    @Override
    public int getLabelColumnWidth() {
        return 0;
    }

    public void disableWidget(Control control) {
        this.guiUtil.enablingRegistry.removeFromEnableList(control);
    }

    public void enableWidget(Control control) {
        this.guiUtil.enablingRegistry.removeFromDisableList(control);
    }
}

