/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.templates.filter;

import de.cni.client.gui.action.toolbar.SearchAction;
import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.templates.filter.IFilterController;
import de.cni.client.gui.templates.filter.IFilterHeaderTile;
import de.cni.client.gui.util.AdvancedDateChooser;
import de.cni.client.gui.util.AdvancedGroup;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.Resources;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.exceptions.MappingException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractFilterHeaderTile
implements IFilterHeaderTile {
    private static Log log = LogFactory.getLog(AbstractFilterHeaderTile.class);
    public static int NO_FILTER = 0;
    public static int PAGE_FILTER = 1;
    public static int PID_FILTER = 2;
    public static int PID_AND_PAGE_FILTER = 3;
    private static int minHeight = 70;
    protected int layoutNumColumns = 3;
    protected int layout;
    int[] weights;
    protected IFilterController pageFilterController;
    protected IBusinessObject filterObject = null;
    protected List<IBusinessObject> filterObjectList = null;
    protected AdvancedGroup group = null;
    protected FilterTraverseListener filterTraverseListener;
    protected FilterSelectionListener filterSelectionListener;
    protected SearchAction searchAction;
    protected String zusatzinfotext;
    protected WidgetFactory guiUtil = new WidgetFactory(this.layoutNumColumns - 1);

    public AbstractFilterHeaderTile(IFilterController pageFilterController, int[] weights, int layout) {
        this.pageFilterController = pageFilterController;
        this.layout = layout;
        this.weights = weights;
        this.filterTraverseListener = new FilterTraverseListener(pageFilterController);
        this.filterSelectionListener = new FilterSelectionListener(pageFilterController);
        this.searchAction = new SearchAction(pageFilterController);
    }

    @Override
    public Composite createContent(Composite parent) {
        if (this.layout == NO_FILTER) {
            return null;
        }
        if ((this.layout & PID_FILTER) == PID_FILTER) {
            SashForm filterAreaComposite = new SashForm(parent, 0);
            GridData filterAreaGridData = new GridData(768);
            GridLayout filterAreaLayout = new GridLayout(1, false);
            filterAreaComposite.setLayout((Layout)filterAreaLayout);
            filterAreaComposite.setLayoutData((Object)filterAreaGridData);
            GuiContainer.newDummy((Composite)filterAreaComposite);
            filterAreaComposite.setWeights(this.weights);
        } else {
            this.createPageFilterContent(parent);
        }
        return null;
    }

    @Override
    public abstract void setPageFilterData(IBusinessObject var1) throws MappingException;

    @Override
    public abstract IBusinessObject getPageFilterData() throws MappingException;

    public void createPageFilterContent(Composite parent) {
        try {
            GridData groupGridData = new GridData(768);
            this.group = GuiContainer.newCenterAllignedGroup(parent, 0, "Suchen", null);
            GridLayout gridLayout = new GridLayout();
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            this.group.setLayout((Layout)gridLayout);
            this.group.setLayoutData(groupGridData);
            GridData data = new GridData(768);
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            Composite c = new Composite(this.group.getContentComposite(), 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 1;
            layout.marginHeight = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            layout.numColumns = this.layoutNumColumns;
            c.setLayout((Layout)layout);
            c.setLayoutData((Object)data);
            this.createGuiFilterElements(c);
            this.createButtons((Composite)this.group);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler beim Seitenaufbau. " + e.getMessage());
            return;
        }
    }

    protected void createButtons(Composite parent) {
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.pack = false;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)buttonLayout);
        Button clearButton = new Button(composite, 8);
        clearButton.setImage(Resources.getInstance().getImage(Resources.ICON.BIG_TRASH));
        clearButton.setToolTipText("Suchkriterium Zur\u00fccksetzen");
        Button selectButton = new Button(composite, 8);
        selectButton.setImage(Resources.getInstance().getImage(Resources.ICON.SMALL_SEARCH));
        selectButton.setToolTipText("Suchen");
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractFilterHeaderTile.this.pageFilterController.clearFilter();
                if (AbstractFilterHeaderTile.this.isSelectOnClear()) {
                    AbstractFilterHeaderTile.this.search();
                }
            }
        });
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    AbstractFilterHeaderTile.this.search();
                }
                catch (Exception ex) {
                    MainApplicationWindow.getInstance().popupError("technischer Fehler. " + ex.getMessage());
                }
            }
        });
    }

    protected void search() {
        this.searchAction.run();
    }

    protected abstract void createGuiFilterElements(Composite var1) throws MappingException;

    protected Composite newComposite(Composite parent) {
        if (!ApplicationProperties.getInstance().hasBrand(this.guiUtil.getBrands())) {
            return null;
        }
        Composite c = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = this.layoutNumColumns;
        layout.marginHeight = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        c.setLayout((Layout)layout);
        return c;
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void toogle(boolean flag) {
    }

    public String getZusatzinfotext() {
        return this.zusatzinfotext;
    }

    protected boolean isSelectOnClear() {
        return this.pageFilterController.getPageController().isLoadAllDataDuringInitialization();
    }

    protected class FilterSelectionListener
    implements SelectionListener {
        IFilterController controller;

        public FilterSelectionListener(IFilterController controller) {
            this.controller = controller;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            AbstractFilterHeaderTile.this.search();
        }

        public void widgetSelected(SelectionEvent arg0) {
            AbstractFilterHeaderTile.this.search();
        }
    }

    protected class FilterTraverseListener
    implements TraverseListener {
        IFilterController controller;

        public FilterTraverseListener(IFilterController controller) {
            this.controller = controller;
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 4) {
                if (e.getSource() instanceof AdvancedDateChooser) {
                    AdvancedDateChooser w = (AdvancedDateChooser)((Object)e.getSource());
                    w.validateInput();
                }
                AbstractFilterHeaderTile.this.search();
            }
        }
    }
}

