/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.tableselection;

import de.cni.client.gui.popup.tableselection.ContentProvider;
import de.cni.client.gui.popup.tableselection.LabelProvider;
import de.cni.client.gui.popup.tableselection.SelectionDialog;
import de.cni.client.gui.popup.tableselection.SelectionDialogController;
import de.cni.client.gui.popup.tableselection.TableViewerSorter;
import de.cni.client.gui.util.GuiContainer;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class TableComposite {
    SelectionDialogController controller;
    SelectionDialog dialog;
    TableViewer tableViewer = null;
    Composite parent;
    String[] columnNameArray;

    public TableComposite(SelectionDialogController controller, SelectionDialog dialog, String[] columnNameArray) {
        this.controller = controller;
        this.dialog = dialog;
        this.columnNameArray = columnNameArray;
    }

    public Composite createContent(Composite parent) {
        this.parent = parent;
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite composite = GuiContainer.newComposite((Composite)sc, 1);
        this.tableViewer = new TableViewer(composite, 68372);
        LabelProvider labelProvider = new LabelProvider();
        ContentProvider contentProvider = new ContentProvider();
        labelProvider.createColumns(this.tableViewer, this.columnNameArray);
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.tableViewer.setSorter((ViewerSorter)new TableViewerSorter());
        this.tableViewer.setInput(this.controller.getObjectList());
        Table table = this.tableViewer.getTable();
        GridData tableGridData = new GridData(4);
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            table.getColumn(i).pack();
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)tableGridData);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                TableComposite.this.controller.selectionChanged(selection.getFirstElement(), selection.size());
                TableComposite.this.dialog.buttonPressed(1);
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                TableComposite.this.controller.selectionChanged(selection.getFirstElement(), selection.size());
            }
        });
        GuiContainer.configureScrolledComposite(sc, composite);
        return parent;
    }

    public List<Object> getSelectedObjects() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        return selection.toList();
    }

    public void refresh() {
        this.tableViewer.setInput(this.controller.getObjectList());
        Table table = this.tableViewer.getTable();
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            table.getColumn(i).pack();
        }
        this.tableViewer.refresh();
    }
}

