/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.tableselection;

import de.cni.client.gui.action.toolbar.ExecuteMethodeAction;
import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.tableselection.SelectionDialog;
import de.cni.client.gui.popup.tableselection.TableRowElement;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SelectionDialogController {
    PageSelectionStatus pageSelectionStatus;
    SelectionDialog dialog;
    Object object;
    List<TableRowElement> objectList;
    private String[] columnNameArray;
    int buttonPressed;
    boolean emptySelectionAllowed = false;
    boolean withDeleteButton = false;
    ExecuteMethodeAction action;
    String actionLabel;
    String title = "";
    String notFoundMessage = "Zu diesem Filterkriterium gibt es keine Daten.";

    public SelectionDialogController(List<TableRowElement> ObjectList, String[] columnNameArray, ExecuteMethodeAction action, boolean emptySelectionAllowed, boolean withDeleteButton) {
        this.objectList = ObjectList;
        this.columnNameArray = columnNameArray;
        this.emptySelectionAllowed = emptySelectionAllowed;
        this.withDeleteButton = withDeleteButton;
        this.action = action;
        if (action != null) {
            this.actionLabel = action.getName();
        }
    }

    public Object getSelectedObject() {
        Object Object2 = null;
        if (!(this.objectList != null && this.objectList.size() != 0 || this.emptySelectionAllowed)) {
            MessageDialog.openInformation((Shell)MainApplicationWindow.getInstance().getShell(), (String)"Warnung", (String)this.notFoundMessage);
            return Object2;
        }
        if (this.objectList != null && this.objectList.size() == 1 && !this.emptySelectionAllowed) {
            return this.objectList.get(0);
        }
        this.dialog = new SelectionDialog(this, MainApplicationWindow.getInstance().getShell(), this.columnNameArray, this.actionLabel, this.withDeleteButton, this.emptySelectionAllowed, this.title);
        this.buttonPressed = this.dialog.open();
        if (this.buttonPressed == 1 || this.buttonPressed == 2) {
            Object2 = this.dialog.getObject();
        }
        return Object2;
    }

    public void setObjectList(List<TableRowElement> objectList) {
        this.objectList = objectList;
    }

    public void selectionChanged(Object firstObject, int cnt) {
        if (cnt == 0) {
            this.pageSelectionStatus = PageSelectionStatus.noSelection;
        } else if (cnt == 1) {
            this.object = firstObject;
            this.pageSelectionStatus = PageSelectionStatus.oneLineSelected;
        } else {
            this.pageSelectionStatus = PageSelectionStatus.multiLinesSelected;
        }
        this.dialog.handleSelectionChanged();
    }

    public void abortSelection() {
        this.object = null;
    }

    public PageSelectionStatus getPageSelectionStatus() {
        return this.pageSelectionStatus;
    }

    public List<TableRowElement> getObjectList() {
        return this.objectList;
    }

    public int getButtonPressed() {
        return this.buttonPressed;
    }

    public void actionButtonPressed() {
        if (this.action == null) {
            return;
        }
        this.action.run();
    }

    public void refreshTable() {
        this.dialog.refreshTable();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setNotFoundMessage(String notFoundMessage) {
        this.notFoundMessage = notFoundMessage;
    }

    public static enum PageSelectionStatus {
        noSelection,
        oneLineSelected,
        multiLinesSelected;

    }
}

