/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.tableselection;

import de.cni.client.gui.popup.tableselection.SelectionDialogController;
import de.cni.client.gui.popup.tableselection.TableComposite;
import de.cni.common.core.Util;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SelectionDialog
extends TitleAreaDialog {
    String title = "Auswahlliste";
    public String ACTION_LABEL = "Aktion";
    public final String CANCEL_LABEL = "Keinen";
    public final String DELETE_LABEL = "L\u00f6schen";
    public final String ABORT_LABEL = "Abbrechen";
    public final String SELECTED_LABEL = "\u00dcbernehmen";
    public SelectionDialogController controller;
    private TableComposite tableComposite;
    private String[] columnNameArray;
    private Object object;
    boolean withActionButton = false;
    boolean withDeleteButton = false;
    boolean withEmptyButton = true;

    public SelectionDialog(SelectionDialogController controller, Shell shell, String[] columnNameArray) {
        super(shell);
        this.controller = controller;
        this.columnNameArray = columnNameArray;
    }

    public SelectionDialog(SelectionDialogController controller, Shell shell, String[] columnNameArray, String actionLabel, boolean withDeleteButton, boolean withEmptyButton, String title) {
        super(shell);
        this.controller = controller;
        this.columnNameArray = columnNameArray;
        this.withDeleteButton = withDeleteButton;
        this.withEmptyButton = withEmptyButton;
        if (!Util.isEmpty(title)) {
            this.title = title;
        }
        if (!Util.isEmpty(actionLabel)) {
            this.withActionButton = true;
            this.ACTION_LABEL = actionLabel;
        }
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected void setNotFoundMessage(String notFoundMessage) {
        this.controller.setNotFoundMessage(notFoundMessage);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 4) {
            this.controller.actionButtonPressed();
            return;
        }
        if (buttonId == 1 || buttonId == 2) {
            List<Object> list = this.tableComposite.getSelectedObjects();
            this.object = list.size() > 0 ? list.get(0) : null;
        }
        this.setReturnCode(buttonId);
        this.close();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.title);
        this.setMessage("Bitte einen Datensatz ausw\u00e4hlen", 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.tableComposite = new TableComposite(this.controller, this, this.columnNameArray);
        this.tableComposite.createContent(composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.withActionButton) {
            this.createButton(parent, 4, this.ACTION_LABEL, true);
        }
        this.createButton(parent, 1, "\u00dcbernehmen", true);
        if (this.withDeleteButton) {
            Button b = this.createButton(parent, 2, "L\u00f6schen", true);
            b.setToolTipText("Der ausgew\u00e4hlte Datensatz wird gel\u00f6scht (deaktiviert)\nund es wird stattdessen ein leerer Eintrag ausgew\u00e4hlt");
        }
        if (this.withEmptyButton) {
            this.createButton(parent, 3, "Keinen", true);
        }
        this.createButton(parent, 0, "Abbrechen", false);
        this.handleSelectionChanged();
    }

    public void handleSelectionChanged() {
        if (this.controller.getPageSelectionStatus() == SelectionDialogController.PageSelectionStatus.oneLineSelected) {
            this.getButton(1).setEnabled(true);
            this.getButton(1).setFocus();
            if (this.withDeleteButton) {
                this.getButton(2).setEnabled(true);
            }
        } else {
            this.getButton(1).setEnabled(false);
            this.getButton(0).setFocus();
            if (this.withDeleteButton) {
                this.getButton(2).setEnabled(false);
            }
        }
    }

    public Object getObject() {
        return this.object;
    }

    public void refreshTable() {
        Point oldShellSize = this.getShell().getSize();
        this.tableComposite.refresh();
        this.dialogArea.pack();
        this.getShell().pack();
        Point newShellSize = this.getShell().getSize();
        newShellSize.y = oldShellSize.y;
        this.getShell().setSize(newShellSize);
    }
}

