/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.util.ComboWrapper;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.Popup;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.core.ServerConnection;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.DokumentVorlage;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import de.cni.common.exceptions.TechnicalException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class PopupWordTile {
    private static Log log = LogFactory.getLog(PopupWordTile.class);
    private ComboWrapper template;
    private Object dataObject;
    String[] templateArray = null;
    String[] nameArray = null;
    IBusinessObjectVerwaltung<IBusinessObject> bean = null;
    WidgetFactory guiUtil = new WidgetFactory(2);

    protected PopupWordTile(List<IBusinessObject> list) throws DatabaseException {
        this.bean = ServerConnection.getInstance().getObjectVerwaltung();
        this.dokumentvorlage2Array(list);
    }

    protected void createContent(Composite parent) throws MappingException {
        Composite mainSpacer = GuiContainer.newSpacer(parent);
        Composite master = GuiContainer.newFillComposite(mainSpacer, 3);
        Group bottom = GuiContainer.newGroup(master, "Dokumentenvorlage", 9, 3);
        this.template = this.guiUtil.createCombo((Composite)bottom, this.nameArray, "Dokumentenvorlage", 0);
    }

    protected void setData(Object dataObject) throws MappingException, DatabaseException {
        try {
            this.dataObject = dataObject;
            this.template.setStringValue("");
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.handleError(log, e);
        }
    }

    protected Object getData() throws MappingException, DatabaseException {
        return this.dataObject;
    }

    public String getTemplateName() throws MappingException, DatabaseException, TechnicalException {
        int index = this.template.getSelectionIndex();
        if (index <= 0) {
            Popup.error("Sie m\u00fcssen eine Briefvorlage ausw\u00e4hlen");
            return null;
        }
        String templatename = this.templateArray[index];
        return templatename;
    }

    private void dokumentvorlage2Array(List<IBusinessObject> list) {
        int index = 0;
        if (list == null || list.size() == 0) {
            return;
        }
        this.templateArray = new String[list.size() + 1];
        this.nameArray = new String[list.size() + 1];
        this.templateArray[index] = "";
        this.nameArray[index] = "";
        for (IBusinessObject element : list) {
            DokumentVorlage vorlage = (DokumentVorlage)element;
            this.templateArray[++index] = vorlage.getTemplate();
            this.nameArray[index] = vorlage.getName();
        }
    }

    static enum dokument {
        schadenformular,
        schadenabrechnung;

    }
}

