/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupWordTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupWordDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupWordDialog.class);
    public static final int CLOSE_ID = 0;
    public static final String CLOSE_LABEL = "Abbrechen";
    public static final int CREATE_ID = 1;
    public static final String CREATE_LABEL = "OK";
    PopupWordTile tile = null;
    Object dataObject;
    IBusinessObject businessObject;
    List<IBusinessObject> dokumentvorlageList;
    String templatename = null;

    public PopupWordDialog(Shell parentShell, List<IBusinessObject> dokumentvorlageList, Object dataObject) {
        super(parentShell);
        try {
            this.dataObject = dataObject;
            this.dokumentvorlageList = dokumentvorlageList;
            this.tile = new PopupWordTile(dokumentvorlageList);
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, CREATE_LABEL, false);
        this.createButton(parent, 0, CLOSE_LABEL, false);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Word Dokument erstellen");
        this.setMessage("Bitte w\u00e4hlen Sie eine Vorlage aus", 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(parent);
            this.tile.setData(this.dataObject);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.businessObject = null;
            this.setReturnCode(buttonId);
            if (buttonId == 0) {
                this.close();
            }
            if (buttonId == 1) {
                this.templatename = this.tile.getTemplateName();
                if (!Util.isEmpty(this.templatename)) {
                    this.close();
                }
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    public IBusinessObject getBusinessObject() {
        return this.businessObject;
    }

    public String getTemplatename() {
        return this.templatename;
    }
}

