/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupValueTile;
import de.cni.client.gui.util.ErrorHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupValueDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupValueDialog.class);
    public static final int OK_ID = 0;
    public static final int ABORT_ID = 1;
    PopupValueTile tile = null;
    String value;
    int limit = 0;
    String title = "Daten erfassen";
    String message = "Bitte erg\u00e4nzen Sie die Daten.";

    public PopupValueDialog(Shell parentShell, String name, String value, boolean isInteger) {
        super(parentShell);
        this.value = value;
        this.tile = new PopupValueTile(name, isInteger);
    }

    public PopupValueDialog(Shell parentShell, String title, String message, String name, String value, boolean isInteger, int limit) {
        super(parentShell);
        this.value = value;
        this.limit = limit;
        this.title = title;
        this.message = message;
        this.tile = new PopupValueTile(name, isInteger);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.title);
        this.setMessage(this.message, 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(parent);
            this.tile.setData(this.value);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.value = null;
            this.setReturnCode(buttonId);
            if (buttonId == 0) {
                this.value = this.tile.getData();
                if (!this.tile.isValid(this.value)) {
                    return;
                }
                this.close();
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    public String getBusinessObject() {
        return this.value;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Speichern", true);
        this.createButton(parent, 1, "Abbrechen", false);
    }
}

