/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.TextWrapper;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.ServerConnection;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;

public class PopupTimeTile {
    private static Log log = LogFactory.getLog(PopupTimeTile.class);
    final int layoutNumColumns = 3;
    TextWrapper geburtsdatum;
    TextWrapper geburtszeit;
    ButtonWrapper cetButton;
    IBusinessObjectVerwaltung<IBusinessObject> bean = null;
    WidgetFactory guiUtil = new WidgetFactory(2);
    String name;

    protected PopupTimeTile(String name) {
        this.bean = ServerConnection.getInstance().getObjectVerwaltung();
        this.name = name;
    }

    protected void createContent(Composite parent) throws MappingException {
        Composite spacer = GuiContainer.newSpacer(parent);
        Composite left1 = GuiContainer.newFillComposite(spacer, 3);
        String tip = "CET = Central European Time\nUTC = Coordinated Universal Time (Weltzeit)";
        Composite rc = this.guiUtil.createRowComposite(left1, 3);
        this.guiUtil.setDefaultSpan(1);
        this.guiUtil.createLabel(rc, "Datum/-Zeit", tip);
        this.geburtsdatum = this.guiUtil.createText(rc, "Datum (mm.tt.yyyy)\n\n" + tip, 90, 10);
        this.geburtszeit = this.guiUtil.createText(rc, "Zeit (hh:mm)\n\n" + tip, 90, 5);
        this.guiUtil.createLabel(rc, "CET");
        this.cetButton = this.guiUtil.createCheckbox(rc, "Ortszeit");
        this.guiUtil.setDefaultSpan(2);
        this.cetButton.setValue(true);
    }

    protected void setData(Date value) throws MappingException, DatabaseException {
        boolean cet = this.cetButton.getValue();
        this.geburtsdatum.setValue(Converter.dateToString(value, "CET"));
        this.geburtszeit.setValue(Converter.timeToHHmmString(value, "CET"));
        this.cetButton.setValue(true);
    }

    protected Date getData() throws MappingException, DatabaseException {
        String datum = DateUtil.fixDate(this.geburtsdatum.getValue());
        String time = DateUtil.fixTime(this.geburtszeit.getValue());
        String timezone = this.cetButton.getValue() ? "CET" : "UTC";
        Date date = Converter.stringToDate(datum, timezone);
        date = DateUtil.setTime(date, time, timezone);
        return date;
    }

    public void enable(boolean flag) {
        this.geburtsdatum.getWidget().setEditable(flag);
        this.geburtszeit.getWidget().setEditable(flag);
        this.cetButton.setEnabled(flag);
    }
}

