/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.core.ServerConnection;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;

public class PopupRadiobuttonTile {
    private static Log log = LogFactory.getLog(PopupRadiobuttonTile.class);
    final int layoutNumColumns = 3;
    ButtonWrapper[] radiobuttonArray;
    IBusinessObjectVerwaltung<IBusinessObject> bean = null;
    WidgetFactory guiUtil = new WidgetFactory(2);
    String name;
    String[] items;

    protected PopupRadiobuttonTile(String name, String[] items) {
        this.bean = ServerConnection.getInstance().getObjectVerwaltung();
        this.name = name;
        this.items = items;
    }

    protected void createContent(Composite parent) throws MappingException {
        this.radiobuttonArray = new ButtonWrapper[this.items.length];
        Composite spacer = GuiContainer.newSpacer(parent);
        Composite c = GuiContainer.newFillComposite(spacer, 1);
        for (int i = 0; i < this.items.length; ++i) {
            this.radiobuttonArray[i] = this.guiUtil.createRadiobox(c, this.items[i], null);
        }
    }

    protected void setData(String value) throws MappingException, DatabaseException {
        for (int i = 0; i < this.items.length; ++i) {
            if (!Util.equals(this.items[i], value)) continue;
            this.radiobuttonArray[i].setValue(true);
        }
    }

    protected String getData() throws MappingException, DatabaseException {
        return this.items[this.getIndex()];
    }

    protected int getIndex() {
        for (int i = 0; i < this.items.length; ++i) {
            if (!this.radiobuttonArray[i].getValue()) continue;
            return i;
        }
        return 0;
    }

    public void enable(boolean flag) {
        for (int i = 0; i < this.items.length; ++i) {
            this.radiobuttonArray[i].getWidget().setEnabled(flag);
        }
    }
}

