/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupRadiobuttonTile;
import de.cni.client.gui.util.ErrorHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupRadiobuttonDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupRadiobuttonDialog.class);
    public static final int OK_ID = 0;
    public static final int ABORT_ID = 1;
    public static final int EMPTY_ID = 2;
    private String name;
    private PopupRadiobuttonTile tile = null;
    private String value;
    private int valueIndex;
    private boolean onlyInfoPopup;
    private boolean emptyAllowed = false;
    private String[] items;

    public PopupRadiobuttonDialog(Shell parentShell, String name, String[] items) {
        super(parentShell);
        this.name = name;
        this.items = items;
        this.tile = new PopupRadiobuttonTile(name, items);
        this.onlyInfoPopup = false;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (!this.onlyInfoPopup) {
            this.setTitle(this.name);
            this.setMessage("Bitte w\u00e4hlen Sie einen Eintrag aus.", 1);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(composite);
            this.tile.enable(!this.onlyInfoPopup);
            this.tile.setData(this.value);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.value = null;
            this.setReturnCode(buttonId);
            if (!this.onlyInfoPopup && buttonId == 0) {
                this.value = this.tile.getData();
                this.valueIndex = this.tile.getIndex();
                this.close();
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    public String getBusinessObject() {
        return this.value;
    }

    public int getIndex() {
        return this.valueIndex;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        if (!this.onlyInfoPopup) {
            if (this.emptyAllowed) {
                this.createButton(parent, 2, "Leer", false);
            }
            this.createButton(parent, 1, "Abbrechen", false);
        }
    }

    public boolean isEmptyAllowed() {
        return this.emptyAllowed;
    }

    public void setEmptyAllowed(boolean emptyAllowed) {
        this.emptyAllowed = emptyAllowed;
    }
}

