/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.popup.filter.ExchangeParameter;
import de.cni.client.gui.util.ComboWrapper;
import de.cni.client.gui.util.DateChooserWrapper;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.astrologie.AspektTyp;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.MappingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;

public class PopupPlanetenzyklusTile {
    private static Log log = LogFactory.getLog(PopupPlanetenzyklusTile.class);
    final int layoutNumColumns = 3;
    public ExchangeParameter exchangeParameter = null;
    private DateChooserWrapper date;
    private ComboWrapper aspekt;
    private ComboWrapper planet1;
    private ComboWrapper planet2;
    IBusinessObjectVerwaltung<IBusinessObject> bean = null;
    WidgetFactory guiUtil = new WidgetFactory(2);
    public static int planetenOffset = 6;
    public static String[] planeten = new String[]{"", "Saturn", "Uranus", "Neptun", "Pluto"};
    public static String[] aspekte = new String[]{"n\u00e4chstes Ereignis", AspektTyp.getAspekt((int)1).langname, AspektTyp.getAspekt((int)2).langname, AspektTyp.getAspekt((int)3).langname, AspektTyp.getAspekt((int)4).langname};

    protected PopupPlanetenzyklusTile() {
        this.exchangeParameter = new ExchangeParameter();
        this.exchangeParameter.personendaten1 = new Personendaten();
        this.exchangeParameter.personendaten2 = new Personendaten();
    }

    protected void createContent(Composite parent) throws MappingException {
        Composite spacer = GuiContainer.newSpacer(parent);
        Composite c = GuiContainer.newComposite(spacer, 3);
        this.guiUtil.createLabel(c, "Ausgangsdatum");
        this.date = this.guiUtil.createDateChooser(c, "Ausgangsdatum", 90);
        this.guiUtil.createLabel(c, "Aspekt");
        this.aspekt = this.guiUtil.createCombo(c, aspekte, "Aspekt", 90);
        this.guiUtil.createLabel(c, "Planet 1");
        this.planet1 = this.guiUtil.createCombo(c, planeten, "Planet 1", 90);
        this.guiUtil.createLabel(c, "Planet 2");
        this.planet2 = this.guiUtil.createCombo(c, planeten, "Planet 2", 90);
    }

    protected void setData(ExchangeParameter exchangeParameter) throws MappingException {
        if (exchangeParameter != null) {
            this.exchangeParameter = exchangeParameter;
            if (exchangeParameter.aspektTyp != null && exchangeParameter.aspektTyp != AspektTyp.empty) {
                this.aspekt.setValueByIndex(exchangeParameter.aspektTyp.ordinal());
            } else {
                this.aspekt.setValueByIndex(0);
            }
            PopupPlanetenzyklusTile.setPlanet(this.planet1, exchangeParameter.planet1);
            PopupPlanetenzyklusTile.setPlanet(this.planet2, exchangeParameter.planet2);
            this.date.setValue(exchangeParameter.date);
        } else {
            exchangeParameter = new ExchangeParameter();
        }
    }

    public static void setPlanet(ComboWrapper combo, int planet) throws MappingException {
        int idx = planet - planetenOffset + 1;
        combo.setValueByIndex(idx < 0 ? 0 : idx);
    }

    protected ExchangeParameter getData() throws MappingException {
        this.exchangeParameter.aspektTyp = AspektTyp.getAspektTyp(this.aspekt.getStringValue());
        this.exchangeParameter.date = this.date.getValue();
        this.exchangeParameter.planet1 = PopupPlanetenzyklusTile.getPlanetId(this.planet1);
        this.exchangeParameter.planet2 = PopupPlanetenzyklusTile.getPlanetId(this.planet2);
        if (this.exchangeParameter.planet2 < 0) {
            this.exchangeParameter.planet2 = this.exchangeParameter.planet1;
        }
        if (this.exchangeParameter.planet1 < 0) {
            this.exchangeParameter.planet1 = this.exchangeParameter.planet2;
        }
        return this.exchangeParameter;
    }

    public static int getPlanetId(ComboWrapper wrapper) throws MappingException {
        int idx = wrapper.getSelectionIndex();
        return idx > 0 ? idx + planetenOffset - 1 : -1;
    }

    public void enable(boolean flag) {
        if (flag) {
            this.guiUtil.enableOneWidget(this.date);
            this.guiUtil.enableOneWidget(this.aspekt);
            this.guiUtil.enableOneWidget(this.planet1);
            this.guiUtil.enableOneWidget(this.planet2);
        } else {
            this.guiUtil.disableOneWidget(this.date);
            this.guiUtil.disableOneWidget(this.aspekt);
            this.guiUtil.disableOneWidget(this.planet1);
            this.guiUtil.disableOneWidget(this.planet2);
        }
    }
}

