/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.util.DateChooserWrapper;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.TextWrapper;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.ServerConnection;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.PersonBefund;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class PopupPersonBefundTile {
    private static Log log = LogFactory.getLog(PopupPersonBefundTile.class);
    final int layoutNumColumns = 3;
    int numberOfTExtfields = 2;
    DateChooserWrapper date;
    TextWrapper time;
    TextWrapper ueberschrift;
    TextWrapper text;
    IBusinessObjectVerwaltung<IBusinessObject> bean = null;
    WidgetFactory guiUtil = new WidgetFactory(2);
    PersonBefund personBefund;

    protected PopupPersonBefundTile(PersonBefund personBefund) {
        this.bean = ServerConnection.getInstance().getObjectVerwaltung();
        this.personBefund = personBefund;
    }

    protected void createContent(Composite parent, int limit) throws MappingException {
        Composite spacer = GuiContainer.newFillComposite(parent, 2);
        Composite c1 = GuiContainer.newFillComposite(spacer, 3);
        int hight = MainApplicationWindow.getInstance().getShell().getSize().y / 2;
        this.date = this.guiUtil.createLabelAndDateChooser(c1, "Datum", 90);
        this.time = this.guiUtil.createLabelAndText(c1, "Uhrzeit", 90, 10);
        this.ueberschrift = this.guiUtil.createLabelAndText(c1, "\u00dcberschrift", 0, 0);
        this.text = this.guiUtil.createScrollTextBlock(c1, "Text", hight, 3);
        if (limit > 0) {
            this.text.getWidget().setTextLimit(limit);
        }
    }

    protected void setData(PersonBefund personBefund) throws MappingException, DatabaseException {
        this.personBefund = personBefund;
        this.date.setValue(personBefund.getDatum());
        this.time.setValue(Converter.timeToHHmmString(personBefund.getDatum()));
        this.ueberschrift.setValue(personBefund.getUeberschrift());
        this.text.setValue(personBefund.getText());
    }

    protected PersonBefund getData() {
        String localDate = DateUtil.fixDate(Converter.dateToString(this.date.getValue()));
        String localTime = DateUtil.fixTime(this.time.getValue());
        DateTime dt = DateUtil.localString2jodaDateTime(localDate, localTime, DateTimeZone.getDefault().getID());
        this.personBefund.setDatum(dt.toDate());
        this.personBefund.setUeberschrift(this.ueberschrift.getValue());
        this.personBefund.setText(this.text.getValue());
        return this.personBefund;
    }

    public void enable(boolean flag) {
        this.date.getWidget().setEditable(flag);
        this.ueberschrift.getWidget().setEditable(flag);
        this.text.getWidget().setEditable(flag);
    }
}

