/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupPersonBefundTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.common.datamodel.admin.PersonBefund;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupPersonBefundDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupPersonBefundDialog.class);
    public static final int OK_ID = 0;
    public static final int ABORT_ID = 1;
    public static final int EMPTY_ID = 2;
    PopupPersonBefundTile tile = null;
    PersonBefund personBefund;
    boolean onlyInfoPopup;
    int limit = 0;

    public PopupPersonBefundDialog(Shell parentShell, PersonBefund personBefund) {
        this(parentShell, 0, personBefund, false);
    }

    public PopupPersonBefundDialog(Shell parentShell, int limit, PersonBefund personBefund, boolean onlyInfoPopup) {
        super(parentShell);
        this.personBefund = personBefund;
        this.onlyInfoPopup = onlyInfoPopup;
        this.limit = limit;
        this.tile = new PopupPersonBefundTile(personBefund);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (!this.onlyInfoPopup) {
            this.setTitle("Daten erfassen");
            this.setMessage("Bitte erg\u00e4nzen Sie die Daten.", 1);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(composite, this.limit);
            this.tile.enable(!this.onlyInfoPopup);
            this.tile.setData(this.personBefund);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.setReturnCode(buttonId);
            if (!this.onlyInfoPopup && buttonId == 0) {
                this.personBefund = this.tile.getData();
                this.close();
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    public PersonBefund getValue() {
        return this.personBefund;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        if (!this.onlyInfoPopup) {
            this.createButton(parent, 1, "Abbrechen", false);
        }
    }
}

