/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.ExchangeParameter;
import de.cni.client.gui.popup.filter.PopupHoroskopUndZeitraumTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.calculation.Horoskop;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupHoroskopUndZeitraum
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupHoroskopUndZeitraum.class);
    public static final int OK_ID = 0;
    public static final int ABORT_ID = 1;
    public static final int EMPTY_ID = 2;
    private PopupHoroskopUndZeitraumTile tile = new PopupHoroskopUndZeitraumTile();
    ExchangeParameter exchangeParameter;

    public PopupHoroskopUndZeitraum(Shell parentShell) {
        super(parentShell);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Transite-Tabelle erstellen");
        this.setMessage("Bitte w\u00e4hlen Sie die Parameter f\u00fcr die Berechnung aus.", 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(composite);
            this.tile.setData(this.exchangeParameter);
            this.tile.setData(this.exchangeParameter);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.exchangeParameter = null;
            this.setReturnCode(buttonId);
            if (buttonId == 0) {
                this.exchangeParameter = this.tile.getData();
                if (!this.isValid()) {
                    Popup.warning("Sie m\u00fcssen die Pflichtfelder korrekt ausf\u00fcllen.");
                    return;
                }
                this.close();
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        this.createButton(parent, 1, "Abbrechen", false);
    }

    private boolean isValid() {
        if (this.exchangeParameter == null || this.exchangeParameter.horoskop == null || this.exchangeParameter.von == null || this.exchangeParameter.bis == null || this.exchangeParameter.personendaten1 == null) {
            return false;
        }
        if (this.exchangeParameter.horoskop != null && (this.exchangeParameter.horoskop == Horoskop.KompositSeptar || this.exchangeParameter.horoskop == Horoskop.Synastrie) && this.exchangeParameter.personendaten2 == null) {
            Popup.info("Sie m\u00fcssen eine zweite Person ausw\u00e4hlen");
            return false;
        }
        return true;
    }

    public ExchangeParameter getValue() {
        return this.exchangeParameter;
    }

    public void setValue(ExchangeParameter exchangeParameter) {
        this.exchangeParameter = exchangeParameter;
    }
}

