/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.ControlpanelTile;
import de.cni.client.gui.popup.filter.IPictureDrawer;
import de.cni.client.gui.popup.filter.PopupAnalyseDialog;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.Popup;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.client.paint.Controlpanel;
import de.cni.client.paint.Disposer;
import de.cni.common.calculation.AnalyseResult;
import de.cni.common.calculation.HerrscherCalculator;
import de.cni.common.calculation.HerrscherResultList;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.HoroskopCalculator;
import de.cni.common.core.LicenseHandler;
import de.cni.common.core.Trigo;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;

public class PopupHoroskopPictureTile {
    private static Log log = LogFactory.getLog(PopupHoroskopPictureTile.class);
    final int layoutNumColumns = 3;
    Group group;
    WidgetFactory guiUtil = new WidgetFactory(2);
    public Composite pictureComposite;
    private Image image;
    IPictureDrawer pictureDrawer;
    Controlpanel controlpanel = new Controlpanel();
    ControlpanelTile controlpanelTile;
    HoroskopCalculator horoskopCalculator;
    int xVorher = 0;
    int yVorher = 0;
    int lastMouseClickX = 0;
    int lastMouseClickY = 0;
    boolean toolTipActive = false;
    DefaultToolTip toolTip = null;

    protected PopupHoroskopPictureTile(IPictureDrawer pictureDrawer, HoroskopCalculator horoskopCalculator) {
        this.pictureDrawer = pictureDrawer;
        this.horoskopCalculator = horoskopCalculator;
        this.controlpanelTile = new ControlpanelTile(pictureDrawer, horoskopCalculator);
    }

    public Composite createContent(Composite parent) {
        try {
            int[] tableDetailWeights = new int[]{30, 70, 0};
            Composite pageComposite = GuiContainer.newFillComposite(parent, 1);
            GridData detailGridData = new GridData(1808);
            detailGridData.grabExcessHorizontalSpace = true;
            SashForm tableDetailSash = new SashForm(pageComposite, 256);
            tableDetailSash.setLayoutData((Object)detailGridData);
            ScrolledComposite sc = GuiContainer.newScrolledComposite((Composite)tableDetailSash);
            Composite controlPanelComposite = GuiContainer.newComposite((Composite)sc, 1);
            this.controlpanelTile.createContent(controlPanelComposite);
            GuiContainer.configureScrolledComposite(sc, controlPanelComposite);
            int x = tableDetailSash.getSize().x;
            Composite margin = GuiContainer.newFillMarginComposite((Composite)tableDetailSash, 10);
            this.pictureComposite = GuiContainer.newFillComposite(margin, 1);
            GuiContainer.newDummy((Composite)tableDetailSash);
            tableDetailSash.setWeights(tableDetailWeights);
            this.pictureComposite.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Point size = PopupHoroskopPictureTile.this.pictureComposite.getSize();
                    int l = Math.min(size.x, size.y);
                    if (l < 400 && PopupHoroskopPictureTile.this.image != null) {
                        PopupHoroskopPictureTile.this.xVorher = 0;
                        PopupHoroskopPictureTile.this.yVorher = 0;
                        ImageData imageData = PopupHoroskopPictureTile.this.image.getImageData().scaledTo(l, l);
                        Image i = new Image((Device)Display.getCurrent(), imageData);
                        e.gc.drawImage(i, 0, 0);
                        Disposer.dispose(e.gc);
                        Disposer.dispose(i);
                    } else {
                        if (size.x != PopupHoroskopPictureTile.this.xVorher && size.y != PopupHoroskopPictureTile.this.yVorher) {
                            Disposer.dispose(PopupHoroskopPictureTile.this.image);
                            PopupHoroskopPictureTile.this.image = PopupHoroskopPictureTile.this.pictureDrawer.recreatePicture(size.x, size.y);
                            PopupHoroskopPictureTile.this.xVorher = size.x;
                            PopupHoroskopPictureTile.this.yVorher = size.y;
                        }
                        e.gc.drawImage(PopupHoroskopPictureTile.this.image, 0, 0);
                        Disposer.dispose(e.gc);
                    }
                }
            });
            if (this.horoskopCalculator.getHoroskop() == Horoskop.Radix && LicenseHandler.getInstance().isAllowed(LicenseHandler.LicenseType.STANDARD) || LicenseHandler.getInstance().isAllowed(LicenseHandler.LicenseType.PROFESSIONAL)) {
                this.pictureComposite.addMouseListener(new MouseListener(){
                    private boolean doubleClick;

                    public void mouseDoubleClick(MouseEvent event) {
                        this.doubleClick = true;
                        System.out.println("mouseDoubleClick " + PopupHoroskopPictureTile.this.getMousePosition(event, true));
                    }

                    public void mouseDown(final MouseEvent event) {
                        if (PopupHoroskopPictureTile.this.toolTipActive && PopupHoroskopPictureTile.this.toolTip != null) {
                            PopupHoroskopPictureTile.this.toolTip.hide();
                            PopupHoroskopPictureTile.this.toolTipActive = false;
                            return;
                        }
                        this.doubleClick = false;
                        Display.getDefault().timerExec(Display.getDefault().getDoubleClickTime(), new Runnable(){

                            @Override
                            public void run() {
                                if (!doubleClick) {
                                    System.out.println("mouseSingleClick " + PopupHoroskopPictureTile.this.getMousePosition(event, false));
                                }
                            }
                        });
                    }

                    public void mouseUp(MouseEvent event) {
                    }
                });
                this.pictureComposite.addMouseMoveListener(new MouseMoveListener(){

                    public void mouseMove(MouseEvent mouseEvent) {
                        double diff = Math.sqrt((PopupHoroskopPictureTile.this.lastMouseClickX - mouseEvent.x) * (PopupHoroskopPictureTile.this.lastMouseClickX - mouseEvent.x) + (PopupHoroskopPictureTile.this.lastMouseClickY - mouseEvent.y) * (PopupHoroskopPictureTile.this.lastMouseClickY - mouseEvent.y));
                        if (diff > 50.0) {
                            if (PopupHoroskopPictureTile.this.toolTip != null) {
                                PopupHoroskopPictureTile.this.toolTip.hide();
                            }
                            PopupHoroskopPictureTile.this.toolTipActive = false;
                        }
                    }
                });
            }
            return pageComposite;
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
            e.printStackTrace();
            return null;
        }
    }

    private String getMousePosition(MouseEvent event, boolean doppelclick) {
        if (!LicenseHandler.getInstance().isAllowed(LicenseHandler.LicenseType.STANDARD)) {
            return "";
        }
        this.lastMouseClickX = event.x;
        this.lastMouseClickY = event.y;
        double xcenter = this.horoskopCalculator.getClickKoordinaten().xcenter;
        double ycenter = this.horoskopCalculator.getClickKoordinaten().ycenter;
        double x = (double)event.x - xcenter;
        double y = -((double)event.y - ycenter);
        double alpha = 0.0;
        if (x != 0.0) {
            alpha = Math.atan2(y, x);
        }
        double winkel = Trigo.grad(alpha * 360.0 / 2.0 / Math.PI);
        double l = Math.sqrt(x * x + y * y);
        AnalyseResult analyseResult = this.horoskopCalculator.getClickKoordinaten().getAllMatches(winkel, l);
        HerrscherCalculator hc = new HerrscherCalculator(this.horoskopCalculator.getHoroskop().name, this.horoskopCalculator.getAstrodaten1());
        hc.calculateHerrscherAnalyseNachRandolf(3);
        HerrscherResultList herrscherResultList = hc.getHerrscherResultList();
        if (!doppelclick) {
            this.showToolTip(event.display.getCursorControl(), event.x, event.y, analyseResult.toString());
        } else {
            log.debug((Object)"vor PopupAnalyseDialog");
            PopupAnalyseDialog dialog = new PopupAnalyseDialog(MainApplicationWindow.getInstance().getShell(), analyseResult, herrscherResultList, true);
            dialog.open();
            log.debug((Object)"nach PopupAnalyseDialog");
        }
        return analyseResult.toString();
    }

    public void showToolTip(Control c, int x, int y, String text) {
        if (!LicenseHandler.getInstance().isAllowed(LicenseHandler.LicenseType.STANDARD)) {
            return;
        }
        if (this.toolTip == null) {
            this.toolTip = new DefaultToolTip(c, 1, true);
        }
        this.toolTip.setRespectMonitorBounds(true);
        this.toolTip.setRespectDisplayBounds(true);
        this.toolTip.setPopupDelay(1);
        this.toolTip.setHideDelay(0);
        this.toolTip.setRespectDisplayBounds(false);
        this.toolTip.setText(text);
        this.toolTip.hide();
        this.toolTip.show(new Point(x + 50, y - 50));
        this.toolTipActive = true;
    }

    public void showWindows(String text) {
        if (!LicenseHandler.getInstance().isAllowed(LicenseHandler.LicenseType.STANDARD)) {
            return;
        }
        Popup.info(text);
    }

    public void refreshPicture() {
        this.pictureComposite.redraw();
    }

    protected void setData(Image image, Controlpanel controlpanel) throws MappingException, DatabaseException {
        this.image = image;
        this.controlpanel = controlpanel;
        this.controlpanelTile.setData(controlpanel);
    }

    protected IBusinessObject getData() throws MappingException, DatabaseException {
        this.controlpanel = this.controlpanelTile.getData();
        return this.controlpanel;
    }

    public boolean isValid(IBusinessObject bo) {
        return true;
    }

    public Composite getPictureComposite() {
        return this.pictureComposite;
    }

    public void setPictureComposite(Composite pictureComposite) {
        this.pictureComposite = pictureComposite;
    }
}

