/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.IPictureDrawer;
import de.cni.client.gui.popup.filter.PopupBrowserDialog;
import de.cni.client.gui.popup.filter.PopupHoroskopPictureTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.client.gui.util.PopupRohdaten;
import de.cni.client.paint.AstroLeinwand;
import de.cni.client.paint.Controlpanel;
import de.cni.client.paint.Disposer;
import de.cni.client.paint.DocumentCreator;
import de.cni.client.paint.PaintRawData;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.HoroskopCalculator;
import de.cni.common.calculation.TextanalyseCalculator;
import de.cni.common.calculation.TexteDrucken;
import de.cni.common.core.Converter;
import de.cni.common.core.GlobalData;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import de.cni.common.exceptions.TechnicalException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PopupHoroskopPictureDialog
extends TitleAreaDialog
implements IPictureDrawer {
    private static Log log = LogFactory.getLog(PopupHoroskopPictureDialog.class);
    public static final int CLOSE_ID = 0;
    public static final String CLOSE_LABEL = "Beenden";
    public static final int SAVEL_ID = 1;
    public static final String SAVEL_LABEL = "Speichern";
    public static final int PRINT_ID = 4;
    public static final String PRINT_LABEL = "Drucken";
    public static final int SWITCH_ID = 5;
    public static final String SWITCH_LABEL = "Tauschen";
    public static final int PREV_YEAR_ID = 6;
    public static final String PREV_YEAR_LABEL = "<<";
    public static final int PREV_DAY_ID = 7;
    public static final String PREV_DAY_LABEL = "<";
    public static final int NEXT_DAY_ID = 8;
    public static final String NEXT_DAY_LABEL = ">";
    public static final int NEXT_YEAR_ID = 9;
    public static final String NEXT_YEAR_LABEL = ">>";
    public static final int NEW_DATE_ID = 10;
    public static final String NEW_DATE_LABEL = "Datum";
    public static final int ROHDATEN_ID = 11;
    public static final String ROHDATEN_LABEL = "Rohdaten";
    public static final int ANALYSE_ID = 12;
    public static final String ANALYSE_LABEL = "Analyse";
    public static final int PREV_HOUR_ID = 15;
    public static final String PREV_HOUR_LABEL = "-";
    public static final int NEXT_HOUR_ID = 17;
    public static final String NEXT_HOUR_LABEL = "+";
    public static final int TEXTE_ID = 20;
    public static final String TEXTE_LABEL = "Texte";
    Controlpanel controlpanel = new Controlpanel(GlobalData.getInstance().getSettings());
    public static int xOffset;
    private PopupHoroskopPictureTile tile;
    private Image image;
    private int x;
    private int y;
    private Composite composite;
    Listener keyListener = null;
    HoroskopCalculator horoskopCalculator;

    public PopupHoroskopPictureDialog(HoroskopCalculator horoskopCalculator, Shell parentShell, int x, int y) {
        super(parentShell);
        this.horoskopCalculator = horoskopCalculator;
        this.x = x;
        this.y = y;
        if (horoskopCalculator.getHoroskop().getPlanetenSaetze() > 1) {
            this.controlpanel.setAspekte1(false);
            this.controlpanel.setAspekte2(false);
            this.controlpanel.setHoroskopCalculator(horoskopCalculator);
            if (horoskopCalculator.getHoroskop() == Horoskop.Transit) {
                this.controlpanel.setPlaneten2(this.controlpanel.planetenTransite);
            }
        }
        this.tile = new PopupHoroskopPictureTile(this, horoskopCalculator);
    }

    private String getTitleText() {
        String title = this.horoskopCalculator.getTitle();
        return title;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        Display display = Display.getCurrent();
        shell.setSize(this.x + 250, this.y);
        Rectangle bounds = display.getPrimaryMonitor().getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x + xOffset, y);
        xOffset = (xOffset + 30) % 150;
    }

    protected void setShellStyle(int arg0) {
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.composite = (Composite)super.createDialogArea(parent);
        try {
            MainApplicationWindow.setShellTitle(this.getShell(), false);
            this.tile.createContent(this.composite);
            this.setTitle(this.getTitleText());
            this.tile.setData(this.image, this.controlpanel);
            this.keyListener = new Listener(){

                public void handleEvent(Event event) {
                    try {
                        if (PopupHoroskopPictureDialog.this.horoskopCalculator == null || !PopupHoroskopPictureDialog.this.horoskopCalculator.getHoroskop().isDayChangeAllowed()) {
                            return;
                        }
                        if (event.character == 'q') {
                            PopupHoroskopPictureDialog.this.horoskopCalculator.decreaseDateMinute();
                            PopupHoroskopPictureDialog.this.repaintHoroskop();
                        }
                        if (event.character == 'w') {
                            PopupHoroskopPictureDialog.this.horoskopCalculator.increaseDateMinute();
                            PopupHoroskopPictureDialog.this.repaintHoroskop();
                        }
                        if (event.character == 'e') {
                            PopupHoroskopPictureDialog.this.horoskopCalculator.decreaseDateHour();
                            PopupHoroskopPictureDialog.this.repaintHoroskop();
                        }
                        if (event.character == 'r') {
                            PopupHoroskopPictureDialog.this.horoskopCalculator.increaseDateHour();
                            PopupHoroskopPictureDialog.this.repaintHoroskop();
                        }
                        if (event.character == 't') {
                            PopupHoroskopPictureDialog.this.horoskopCalculator.decreaseDateSmall();
                            PopupHoroskopPictureDialog.this.repaintHoroskop();
                        }
                        if (event.character == 'z') {
                            PopupHoroskopPictureDialog.this.horoskopCalculator.increaseDateSmall();
                            PopupHoroskopPictureDialog.this.repaintHoroskop();
                        }
                        if (event.character == 'u') {
                            PopupHoroskopPictureDialog.this.horoskopCalculator.decreaseDateMonth();
                            PopupHoroskopPictureDialog.this.repaintHoroskop();
                        }
                        if (event.character == 'i') {
                            PopupHoroskopPictureDialog.this.horoskopCalculator.increaseDateMonth();
                            PopupHoroskopPictureDialog.this.repaintHoroskop();
                        }
                        if (event.character == 'o') {
                            PopupHoroskopPictureDialog.this.horoskopCalculator.decreaseDateBig();
                            PopupHoroskopPictureDialog.this.repaintHoroskop();
                        }
                        if (event.character == 'p') {
                            PopupHoroskopPictureDialog.this.horoskopCalculator.increaseDateBig();
                            PopupHoroskopPictureDialog.this.repaintHoroskop();
                        }
                    }
                    catch (Exception e) {
                        ErrorHandler.handleError(log, e);
                    }
                }
            };
            this.getShell().getDisplay().addFilter(1, this.keyListener);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return this.composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.setReturnCode(buttonId);
            if (buttonId == 0) {
                this.closePopup();
                return;
            }
            if (buttonId == 1) {
                this.save(buttonId);
            }
            if (buttonId == 4) {
                this.print(buttonId);
            }
            if (buttonId == 5) {
                this.horoskopCalculator.switchPersonendaten();
            }
            if (buttonId == 20) {
                try {
                    this.controlpanel.setHoroskopCalculator(this.horoskopCalculator);
                    TexteDrucken drucker = new TexteDrucken();
                    String texte = drucker.drucken(this.horoskopCalculator, this.controlpanel);
                    Shell shell = MainApplicationWindow.getInstance().getShell();
                    String dateiname = this.horoskopCalculator.getHoroskop().getName() + "_";
                    String name = this.horoskopCalculator.getPd1().getName();
                    if (this.horoskopCalculator.getPd2() != null && !Util.equals(this.horoskopCalculator.getPd1().getName(), this.horoskopCalculator.getPd2().getName())) {
                        name = this.horoskopCalculator.getPd1().getName() + "_" + this.horoskopCalculator.getPd2().getName();
                    }
                    dateiname = dateiname + name + "_" + Converter.timeToSortableString(new Date());
                    PopupBrowserDialog popup = new PopupBrowserDialog(shell, 0, dateiname, texte);
                    popup.open();
                }
                catch (Exception e) {
                    Popup.error("Die Texte k\u00f6nnen nicht angezeigt werden. " + e.getClass() + "/" + Util.NotNull(e.getMessage()));
                }
            }
            if (buttonId == 11) {
                PopupRohdaten.popupHoroskopdaten(this.horoskopCalculator, this.controlpanel);
                if (this.composite.isDisposed()) {
                    return;
                }
            }
            if (buttonId == 12) {
                try {
                    this.controlpanel.setHoroskopCalculator(this.horoskopCalculator);
                    TextanalyseCalculator ac = this.horoskopCalculator.getAstrodaten2() == null ? new TextanalyseCalculator(this.controlpanel, this.horoskopCalculator.getAstrodaten1(), null) : new TextanalyseCalculator(this.controlpanel, this.horoskopCalculator.getAstrodaten1(), this.horoskopCalculator.getAstrodaten2(), null);
                    String result1 = ac.calculateKonstellation(3).toString();
                    String result2 = ac.calculateKonstellation(0).toString();
                    Popup.infoPopup("Analyse (3-Grad Regel)", ANALYSE_LABEL, result1, result2, 0);
                    if (this.composite.isDisposed()) {
                        return;
                    }
                }
                catch (Exception e) {
                    ErrorHandler.handleError(log, "Beim Berechnen der Analyse-Daten ist ein Fehler aufgetreten.");
                }
            }
            if (buttonId == 10) {
                Date d = Popup.timePopup(NEW_DATE_LABEL, this.horoskopCalculator.getRelevantDate());
                this.horoskopCalculator.setNewDate(d);
            } else if (buttonId == 7) {
                this.horoskopCalculator.decreaseDateSmall();
            } else if (buttonId == 8) {
                this.horoskopCalculator.increaseDateSmall();
            } else if (buttonId == 6) {
                this.horoskopCalculator.decreaseDateBig();
            } else if (buttonId == 9) {
                this.horoskopCalculator.increaseDateBig();
            } else if (buttonId == 15) {
                this.horoskopCalculator.decreaseDateHour();
            } else if (buttonId == 17) {
                this.horoskopCalculator.increaseDateHour();
            }
            this.repaintHoroskop();
        }
        catch (Exception e) {
            e.printStackTrace();
            Popup.error("Zum Datum " + Converter.timeToString(this.horoskopCalculator.getDate1()) + " kann keine Berechnung durchgef\u00fchrt werden");
            this.horoskopCalculator.undoDateChange();
        }
    }

    @Override
    public void repaintHoroskop() throws TechnicalException, DatabaseException, MappingException {
        Disposer.dispose(this.image);
        this.image = this.paintNewImage(this.horoskopCalculator, this.controlpanel);
        if (this.image != null) {
            this.tile.setData(this.image, this.controlpanel);
            this.tile.refreshPicture();
            this.setTitle(this.getTitleText());
        } else {
            Popup.error("Zum Datum " + Converter.timeToString(this.horoskopCalculator.getDate1()) + " kann keine Berechnung durchgef\u00fchrt werden");
            this.horoskopCalculator.undoDateChange();
        }
    }

    private boolean closePopup() throws Exception {
        try {
            IBusinessObject object = this.tile.getData();
            if (!this.tile.isValid(object)) {
                return false;
            }
            if (this.image != null) {
                this.image.dispose();
            }
            if (this.keyListener != null) {
                this.getShell().getDisplay().removeFilter(1, this.keyListener);
            }
            return super.close();
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return false;
        }
    }

    public boolean close() {
        try {
            return this.closePopup();
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return false;
        }
    }

    private void print(int id) {
        try {
            this.controlpanel = (Controlpanel)this.tile.getData();
            DocumentCreator dc = new DocumentCreator(this.horoskopCalculator, this.controlpanel).createDocument();
            if (this.controlpanel.getReporttypId() == 2) {
                dc.popupJasperViewer(1);
            } else {
                dc.popupJasperViewer(2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.handleError(log, e);
        }
    }

    private void save(int id) {
        try {
            this.controlpanel = (Controlpanel)this.tile.getData();
            DocumentCreator dc = new DocumentCreator(this.horoskopCalculator, this.controlpanel).createDocument();
            if (this.controlpanel.getReporttypId() == 2) {
                dc.saveJasperDokument(1);
            } else {
                dc.saveJasperDokument(2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.handleError(log, e);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, SAVEL_LABEL, false);
        this.createButton(parent, 4, PRINT_LABEL, false);
        this.createButton(parent, 11, ROHDATEN_LABEL, false);
        if (this.horoskopCalculator.getHoroskop() == Horoskop.Synastrie) {
            this.createButton(parent, 5, SWITCH_LABEL, false);
        }
        if (this.horoskopCalculator.getHoroskop().isDayChangeAllowed()) {
            this.createButton(parent, 10, NEW_DATE_LABEL, false);
        }
        if (this.horoskopCalculator.getHoroskop().isYearChangeAllowed()) {
            this.createButton(parent, 6, PREV_YEAR_LABEL, false);
        }
        if (this.horoskopCalculator.getHoroskop().isDayChangeAllowed()) {
            this.createButton(parent, 7, PREV_DAY_LABEL, false);
        }
        if (this.horoskopCalculator.getHoroskop().isDayChangeAllowed()) {
            this.createButton(parent, 8, NEXT_DAY_LABEL, false);
        }
        if (this.horoskopCalculator.getHoroskop().isYearChangeAllowed()) {
            this.createButton(parent, 9, NEXT_YEAR_LABEL, false);
        }
        this.createButton(parent, 0, CLOSE_LABEL, false);
    }

    @Override
    public Image recreatePicture(int x, int y) {
        this.x = x;
        this.y = y;
        return this.recreatePicture();
    }

    @Override
    public Image recreatePicture() {
        try {
            this.controlpanel = (Controlpanel)this.tile.getData();
            Disposer.dispose(this.image);
            this.image = this.paintNewImage(this.horoskopCalculator, this.controlpanel);
            this.tile.setData(this.image, this.controlpanel);
            this.tile.refreshPicture();
            return this.image;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image paintNewImage(HoroskopCalculator horoskopCalculator, Controlpanel controlpanel) throws TechnicalException {
        Image image;
        GC gc = null;
        Image image2 = null;
        try {
            PaintRawData paintRawData = new PaintRawData(this.x, this.y, horoskopCalculator.getTitle() + "_" + Converter.dateToSortableString(new Date()));
            paintRawData.getObjectList().add(controlpanel);
            paintRawData.getObjectList().add(horoskopCalculator);
            paintRawData.setSizeX(this.x);
            paintRawData.setSizeX(this.y);
            AstroLeinwand leinwand = new AstroLeinwand(paintRawData);
            Disposer.dispose(image2);
            image2 = new Image((Device)MainApplicationWindow.getInstance().getShell().getDisplay(), this.x, this.y);
            gc = new GC((Drawable)image2);
            leinwand.initialize(gc);
            leinwand.writeCopyright();
            leinwand.paint();
            leinwand.finalize();
            image = image2;
        }
        catch (Throwable throwable) {
            Disposer.dispose(gc);
            throw throwable;
        }
        Disposer.dispose(gc);
        return image;
    }

    public Controlpanel getControlpanel() {
        return this.controlpanel;
    }

    public void setControlpanel(Controlpanel controlpanel) {
        this.controlpanel = controlpanel;
    }
}

