/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.action.toolbar.ExecuteMethodeAction;
import de.cni.client.gui.action.toolbar.ISearchable;
import de.cni.client.gui.action.toolbar.SearchAction;
import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.FilterDialog;
import de.cni.client.gui.popup.filter.PopupFilterTile;
import de.cni.client.gui.popup.tableselection.SelectionDialogController;
import de.cni.client.gui.popup.tableselection.TableRowElement;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.exceptions.DatabaseException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PopupFilterController
implements ISearchable {
    private static Log log = LogFactory.getLog(PopupFilterController.class);
    String popupName = null;
    IBusinessObject filterObject = null;
    String[] selectionColumnNameArray = null;
    FilterDialog dialog = null;
    List<IBusinessObject> filterObjectList = null;
    boolean autoselectWhenOnlyOneRecord = false;
    public static final boolean DO_ALLOW_EMPTY_SELECTION = true;
    public static final boolean DO_NOT_ALLOW_EMPTY_SELECTION = false;
    public static final boolean DO_NOTHING_WHEN_EMPTY = true;
    public static final boolean DO_ALLOW_DELETE = true;
    public static final boolean DO_NOT_ALLOW_DELETE = false;
    public static final int ABORT_ID = 0;
    public static final int SELECTED_ID = 1;
    public static final int DELETE_ID = 2;
    public static final int EMPTY_ID = 3;
    public static final int ACTION_ID = 4;
    public static final int NOTHING_FOUND = 5;
    private int buttonPressed;
    private boolean emptySelectionAllowed;
    private boolean deleteAllowed = false;
    private boolean doNothingWhenEmpty = false;
    SearchAction searchAction;
    protected SelectionDialogController selectionDialogController;
    protected String notFoundMessage = "";

    public PopupFilterController(String popupName, String[] columnNameArray) {
        this.popupName = popupName;
        this.selectionColumnNameArray = columnNameArray;
        this.emptySelectionAllowed = false;
        this.deleteAllowed = false;
        this.searchAction = new SearchAction(this);
    }

    public PopupFilterController(String popupName, String[] columnNameArray, String actionLabel) {
        this.popupName = popupName;
        this.selectionColumnNameArray = columnNameArray;
        this.emptySelectionAllowed = false;
        this.deleteAllowed = false;
        this.searchAction = new SearchAction(this);
    }

    public PopupFilterController(String popupName, String[] columnNameArray, boolean emptySelectionAllowed) {
        this.popupName = popupName;
        this.selectionColumnNameArray = columnNameArray;
        this.emptySelectionAllowed = emptySelectionAllowed;
        this.deleteAllowed = false;
        this.searchAction = new SearchAction(this);
    }

    public PopupFilterController(String popupName, String[] columnNameArray, boolean emptySelectionAllowed, boolean doNothingWhenEmpty) {
        this.popupName = popupName;
        this.selectionColumnNameArray = columnNameArray;
        this.emptySelectionAllowed = emptySelectionAllowed;
        this.searchAction = new SearchAction(this);
        this.doNothingWhenEmpty = doNothingWhenEmpty;
    }

    public IBusinessObject selectOneRecordFromDB(List<IBusinessObject> objectList) {
        return this.selectOneRecordFromDB(null, objectList, false);
    }

    public IBusinessObject selectOneRecordFromDB(IBusinessObject filterObject) {
        return this.selectOneRecordFromDB(filterObject, null, true);
    }

    public IBusinessObject selectOneRecordFromDB(IBusinessObject filterObject, List<IBusinessObject> objectList, boolean fromDB) {
        List<TableRowElement> tableRowElementList = null;
        try {
            if (fromDB) {
                this.filterObject = filterObject;
                this.searchAction.run();
                if (this.filterObjectList == null) {
                    return null;
                }
            } else {
                this.filterObjectList = objectList;
            }
            if (this.filterObjectList != null && this.filterObjectList.size() == 1 && this.autoselectWhenOnlyOneRecord) {
                IBusinessObject resultObject = this.filterObjectList.get(0);
                return this.convertSlimToFat(resultObject);
            }
            if (this.filterObjectList != null && this.filterObjectList.size() > 0) {
                log.debug((Object)(this.filterObjectList.size() + " Eintr\u00e4ge gefunden."));
                tableRowElementList = this.objectList2tableRowElementList(this.filterObjectList);
            } else if (this.doNothingWhenEmpty) {
                this.buttonPressed = 5;
                return null;
            }
            this.selectionDialogController = new SelectionDialogController(tableRowElementList, this.selectionColumnNameArray, this.getExecuteMethodeAction(), this.emptySelectionAllowed, this.deleteAllowed);
            if (!Util.isEmpty(this.notFoundMessage)) {
                this.selectionDialogController.setNotFoundMessage(this.notFoundMessage);
            }
            TableRowElement tableRowElement = (TableRowElement)this.selectionDialogController.getSelectedObject();
            this.buttonPressed = this.selectionDialogController.getButtonPressed();
            if (tableRowElement != null) {
                IBusinessObject resultObject = this.filterObjectList.get(tableRowElement.row);
                log.debug((Object)("Popup Auswahl:" + resultObject.toString()));
                resultObject = this.convertSlimToFat(resultObject);
                return resultObject;
            }
            log.debug((Object)"keine Auswahl getroffen");
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.handleUnknownError(log, e);
        }
        return null;
    }

    protected ExecuteMethodeAction getExecuteMethodeAction() {
        return null;
    }

    public IBusinessObject openFilterPopupAndGetValue(IBusinessObject initialFilter) {
        this.filterObject = initialFilter;
        if (this.filterObject != null) {
            this.filterObject = this.selectOneRecordFromDB(this.filterObject);
        }
        if (this.filterObject == null) {
            this.filterObject = this.createNewFilterObject();
        }
        this.dialog = new FilterDialog(this, MainApplicationWindow.getInstance().getShell(), this.filterObject);
        this.buttonPressed = this.dialog.open();
        if (this.buttonPressed == 1) {
            return this.filterObject;
        }
        if (this.buttonPressed == 3) {
            return null;
        }
        return null;
    }

    public void clearFilter() {
        this.filterObject = this.createNewFilterObject();
        this.dialog.setData(this.filterObject);
    }

    public void setData(IBusinessObject filterObject) {
        this.filterObject = filterObject;
    }

    public String getPopupName() {
        return this.popupName;
    }

    protected IBusinessObject convertSlimToFat(IBusinessObject slimObject) throws DatabaseException {
        return slimObject;
    }

    protected abstract List<TableRowElement> objectList2tableRowElementList(List var1);

    protected abstract IBusinessObject createNewFilterObject();

    protected abstract PopupFilterTile createPopupFilterTile();

    protected abstract List findObject(IBusinessObject var1) throws DatabaseException;

    public int getButton_pressed() {
        return this.buttonPressed;
    }

    @Override
    public boolean isDiscardChanges() {
        return true;
    }

    @Override
    public void search() {
        try {
            this.filterObjectList = this.findObject(this.filterObject);
        }
        catch (Exception e) {
            this.filterObjectList = null;
            e.printStackTrace();
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    public boolean isDeleteAllowed() {
        return this.deleteAllowed;
    }

    public void setDeleteAllowed(boolean deleteAllowed) {
        this.deleteAllowed = deleteAllowed;
    }

    public boolean isAutoselectWhenOnlyOneRecord() {
        return this.autoselectWhenOnlyOneRecord;
    }

    public void setAutoselectWhenOnlyOneRecord(boolean autoselectWhenOnlyOneRecord) {
        this.autoselectWhenOnlyOneRecord = autoselectWhenOnlyOneRecord;
    }
}

