/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupAnalyseResultListTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.common.calculation.AnalyseResult;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupAnalyseResultListDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupAnalyseResultListDialog.class);
    public static final int OK_ID = 0;
    public static final int ABORT_ID = 1;
    public static final int EMPTY_ID = 2;
    PopupAnalyseResultListTile tile = null;
    String title;
    List<AnalyseResult> analyseResultList;
    boolean onlyInfoPopup;

    public PopupAnalyseResultListDialog(Shell parentShell) {
        this(parentShell, "", null, true);
    }

    public PopupAnalyseResultListDialog(Shell parentShell, String title, List<AnalyseResult> analyseResultList, boolean onlyInfoPopup) {
        super(parentShell);
        this.analyseResultList = analyseResultList;
        this.onlyInfoPopup = onlyInfoPopup;
        this.title = title;
        this.tile = new PopupAnalyseResultListTile(analyseResultList);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (!this.onlyInfoPopup) {
            this.setTitle("Analyse: " + this.title);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(composite);
            this.tile.enable(!this.onlyInfoPopup);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.analyseResultList = null;
            this.setReturnCode(buttonId);
            if (!this.onlyInfoPopup && buttonId == 0) {
                this.analyseResultList = this.tile.getData();
                if (!this.validation(this.analyseResultList)) {
                    return;
                }
                this.close();
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    public List<AnalyseResult> getBusinessObject() {
        return this.analyseResultList;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        if (!this.onlyInfoPopup) {
            this.createButton(parent, 1, "Abbrechen", false);
        }
    }

    private boolean validation(List<AnalyseResult> analyseResultList) {
        return true;
    }
}

