/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupAnalyseTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.common.calculation.AnalyseResult;
import de.cni.common.calculation.HerrscherResultList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupAnalyseDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupAnalyseDialog.class);
    public static final int OK_ID = 0;
    public static final int ABORT_ID = 1;
    public static final int EMPTY_ID = 2;
    PopupAnalyseTile tile = null;
    AnalyseResult analyseResult;
    HerrscherResultList herrscherResultList;
    boolean onlyInfoPopup;

    public PopupAnalyseDialog(Shell parentShell) {
        this(parentShell, null, null, true);
    }

    public PopupAnalyseDialog(Shell parentShell, AnalyseResult analyseResult, HerrscherResultList herrscherResultList, boolean onlyInfoPopup) {
        super(parentShell);
        log.debug((Object)"PopupAnalyseDialog initialisiert - Start");
        this.analyseResult = analyseResult;
        this.onlyInfoPopup = onlyInfoPopup;
        this.herrscherResultList = herrscherResultList;
        this.tile = new PopupAnalyseTile();
        log.debug((Object)"PopupAnalyseDialog initialisiert - Ende");
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (!this.onlyInfoPopup) {
            this.setTitle("Analyse");
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(composite, this.analyseResult, this.herrscherResultList);
            this.tile.enable(!this.onlyInfoPopup);
            composite.setSize(700, 300);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.analyseResult = null;
            this.setReturnCode(buttonId);
            if (!this.onlyInfoPopup && buttonId == 0) {
                this.analyseResult = this.tile.getData();
                if (!this.validation(this.analyseResult)) {
                    return;
                }
                this.close();
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    public AnalyseResult getBusinessObject() {
        return this.analyseResult;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        if (!this.onlyInfoPopup) {
            this.createButton(parent, 1, "Abbrechen", false);
        }
    }

    private boolean validation(AnalyseResult analyseResult) {
        return true;
    }
}

