/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.ExchangeParameter;
import de.cni.client.gui.popup.filter.IPictureDrawer;
import de.cni.client.gui.popup.filter.PopupPlanetenzyklusDialog;
import de.cni.client.gui.popup.filter.PopupTkzGmsDialog;
import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.ComboWrapper;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.Popup;
import de.cni.client.gui.util.Resources;
import de.cni.client.gui.util.TextWrapper;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.client.paint.ColorFactory;
import de.cni.client.paint.Controlpanel;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.HoroskopCalculator;
import de.cni.common.calculation.NextPlanetMatch;
import de.cni.common.core.Brand;
import de.cni.common.core.Constants;
import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.Domain;
import de.cni.common.core.GlobalData;
import de.cni.common.core.LicenseHandler;
import de.cni.common.core.Trigo;
import de.cni.common.core.Util;
import de.cni.common.datamodel.TkzGms;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import de.cni.common.exceptions.TechnicalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class ControlpanelTile {
    private static Log log = LogFactory.getLog(ControlpanelTile.class);
    private IPictureDrawer pictureDrawer;
    private WidgetFactory guiUtil = new WidgetFactory(3);
    private int[] transformerIDs = new int[]{6, 7, 8, 9};
    private int[] allImportantPlanetIDs = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private Controlpanel obj;
    private ButtonWrapper horoskop1;
    private ButtonWrapper horoskop2;
    private ButtonWrapper aspekte1;
    private ButtonWrapper aspekte2;
    private ButtonWrapper interAspekte;
    private ButtonWrapper gradzahlen;
    private ButtonWrapper gradzahlenMitZahl;
    private ButtonWrapper zwischenskala;
    private ButtonWrapper jahresring;
    private ButtonWrapper hauslinien;
    private ButtonWrapper zeiger;
    private ButtonWrapper invisible;
    private ButtonWrapper anonym;
    private ButtonWrapper konjunktion;
    private ButtonWrapper sextil;
    private ButtonWrapper quadrat;
    private ButtonWrapper trigon;
    private ButtonWrapper opposition;
    private ButtonWrapper quinkunx;
    private ComboWrapper iconType;
    private ComboWrapper iconSize;
    private ComboWrapper reporttyp;
    private TextWrapper lineWidth;
    private ButtonWrapper eigeneAnalysetexte;
    private ButtonWrapper schablone;
    private ButtonWrapper schabloneWinkelButton;
    private ButtonWrapper schabloneLinksDrehen;
    private ButtonWrapper schabloneRechtsDrehen;
    private ComboWrapper schablonePlanet1;
    private ComboWrapper schablonePlanet2;
    private Horoskop horoskop;
    private ButtonWrapper[] planeten1 = new ButtonWrapper[Controlpanel.anzPlaneten];
    private ButtonWrapper[] planeten2 = new ButtonWrapper[Controlpanel.anzPlaneten];
    private ButtonWrapper retrograde1;
    private ButtonWrapper retrograde2;
    private ButtonWrapper switchPlanetenButton1;
    private ButtonWrapper switchPlanetenButton2;
    private ButtonWrapper switchAspekteButton;
    private TextWrapper schabloneWinkel;
    private ButtonWrapper popupPlanetzyklus;
    boolean aspekteAnAus = false;
    TripleAnAus planetenAnAus1 = TripleAnAus.Ein;
    TripleAnAus planetenAnAus2 = TripleAnAus.Ein;
    private String[] planeten1Array = new String[Constants.planeten.length + 1];
    private String[] planeten2Array = new String[Constants.planeten.length + 1 - 4];
    private HoroskopCalculator horoskopCalculator;

    public ControlpanelTile(IPictureDrawer pictureDrawer, HoroskopCalculator horoskopCalculator) {
        int i;
        this.pictureDrawer = pictureDrawer;
        this.horoskopCalculator = horoskopCalculator;
        this.horoskop = horoskopCalculator.getHoroskop();
        if (this.horoskop == Horoskop.Transit) {
            this.planetenAnAus2 = TripleAnAus.Halb;
        }
        this.planeten1Array[0] = "";
        for (i = 0; i < Constants.planeten.length; ++i) {
            this.planeten1Array[i + 1] = Constants.planeten[i];
        }
        this.planeten2Array[0] = "";
        for (i = 0; i < Constants.planeten.length - 4; ++i) {
            this.planeten2Array[i + 1] = Constants.planeten[i];
        }
    }

    public void createContent(Composite composite) throws MappingException {
        Composite master = GuiContainer.newComposite(composite, 2);
        Composite c1 = GuiContainer.newFillComposite(master, 1);
        Composite c2 = GuiContainer.newFillComposite(master, 1);
        if (this.horoskop.planetenSaetze > 1) {
            Group g1 = GuiContainer.newGroup(c1, "Anzeige", 1, 1);
            this.horoskop1 = this.guiUtil.createCheckbox((Composite)g1, "Horoskop 1", null);
            this.addListener(this.horoskop1);
            this.horoskop2 = this.guiUtil.createCheckbox((Composite)g1, "Horoskop 2", null);
            this.horoskop2.getWidget().setForeground(ColorFactory.getInstance().colorRed);
            this.addListener(this.horoskop2);
            this.aspekte1 = this.guiUtil.createCheckbox((Composite)g1, "Aspekte 1", null);
            this.addListener(this.aspekte1);
            this.aspekte2 = this.guiUtil.createCheckbox((Composite)g1, "Aspekte 2", null);
            this.aspekte2.getWidget().setForeground(ColorFactory.getInstance().colorRed);
            this.addListener(this.aspekte2);
            this.interAspekte = this.guiUtil.createCheckbox((Composite)g1, "Inter-Aspekte", null);
            this.addListener(this.interAspekte);
        }
        if (this.horoskop == Horoskop.Transit) {
            this.planetenAnAus2 = TripleAnAus.Halb;
        }
        Group g2 = GuiContainer.newGroup(c1, "Darstellung", 1, 1);
        this.guiUtil.setDefaultSpan(1);
        this.iconType = this.guiUtil.createCombo((Composite)g2, Domain.IconType, "Darstellungsart der grafischen Symbole", 0, 0);
        this.addComboListener(this.iconType);
        this.iconSize = this.guiUtil.createCombo((Composite)g2, Domain.IconSize, "Gr\u00f6\u00dfe der grafischen Symbole", 0, 0);
        this.addComboListener(this.iconSize);
        this.reporttyp = this.guiUtil.createCombo((Composite)g2, Domain.Reporttyp, "Typ des gedruckten Dokuments", 0, 0);
        this.addComboListener(this.reporttyp);
        this.anonym = this.guiUtil.createCheckbox((Composite)g2, "Person anonym", null);
        this.invisible = this.guiUtil.createCheckbox((Composite)g2, "Person unsichtbar", null);
        this.eigeneAnalysetexte = this.guiUtil.createCheckbox((Composite)g2, "Eigene Text", null);
        this.addListener(this.eigeneAnalysetexte);
        this.guiUtil.setDefaultSpan(1);
        Composite g2Line = GuiContainer.newComposite((Composite)g2, 3);
        this.guiUtil.createLabel(g2Line, "St\u00e4rke");
        this.lineWidth = this.guiUtil.createLeftNumberText(g2Line, "Strichst\u00e4rke", 10, 1);
        this.addListener(this.lineWidth);
        Group g3 = GuiContainer.newGroup(c1, "Skalen", 1, 1);
        this.gradzahlen = this.guiUtil.createCheckbox((Composite)g3, "Skala-TKZ", null);
        this.addListener(this.gradzahlen);
        this.guiUtil.setBrand(Brand.OPEN);
        this.gradzahlenMitZahl = this.guiUtil.createCheckbox((Composite)g3, "Gradzahlen", null);
        this.addListener(this.gradzahlenMitZahl);
        this.guiUtil.resetBrand();
        this.zwischenskala = this.guiUtil.createCheckbox((Composite)g3, "Skala-AC", null);
        this.addListener(this.zwischenskala);
        this.jahresring = this.guiUtil.createCheckbox((Composite)g3, "Jahresring", null);
        this.addListener(this.jahresring);
        this.hauslinien = this.guiUtil.createCheckbox((Composite)g3, "H\u00e4user-Segmente", null);
        this.addListener(this.hauslinien);
        this.zeiger = this.guiUtil.createCheckbox((Composite)g3, "Zeiger", null);
        this.addListener(this.zeiger);
        Group g4 = GuiContainer.newGroup(c1, "Aspekte", 1, 1);
        this.konjunktion = this.guiUtil.createCheckbox((Composite)g4, "Konjunktion", null);
        this.addListener(this.konjunktion);
        this.sextil = this.guiUtil.createCheckbox((Composite)g4, "Sextil", null);
        this.addListener(this.sextil);
        this.quadrat = this.guiUtil.createCheckbox((Composite)g4, "Quadrat", null);
        this.addListener(this.quadrat);
        this.trigon = this.guiUtil.createCheckbox((Composite)g4, "Trigon", null);
        this.addListener(this.trigon);
        this.opposition = this.guiUtil.createCheckbox((Composite)g4, "Opposition", null);
        this.addListener(this.opposition);
        this.quinkunx = this.guiUtil.createCheckbox((Composite)g4, "Quikunx", null);
        this.addListener(this.quinkunx);
        this.switchAspekteButton = this.guiUtil.createPushButton((Composite)g4, "Ein/Aus", "Alle Aspekte Ein/Aus schalten", null);
        this.switchAspekteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ControlpanelTile.this.obj.setKonjunktion(ControlpanelTile.this.aspekteAnAus);
                ControlpanelTile.this.obj.setSextil(ControlpanelTile.this.aspekteAnAus);
                ControlpanelTile.this.obj.setQuadrat(ControlpanelTile.this.aspekteAnAus);
                ControlpanelTile.this.obj.setTrigon(ControlpanelTile.this.aspekteAnAus);
                ControlpanelTile.this.obj.setOpposition(ControlpanelTile.this.aspekteAnAus);
                ControlpanelTile.this.obj.setQuinkunx(ControlpanelTile.this.aspekteAnAus);
                ControlpanelTile.this.konjunktion.setValue(ControlpanelTile.this.obj.isKonjunktion());
                ControlpanelTile.this.sextil.setValue(ControlpanelTile.this.obj.isSextil());
                ControlpanelTile.this.quadrat.setValue(ControlpanelTile.this.obj.isQuadrat());
                ControlpanelTile.this.trigon.setValue(ControlpanelTile.this.obj.isTrigon());
                ControlpanelTile.this.opposition.setValue(ControlpanelTile.this.obj.isOpposition());
                ControlpanelTile.this.quinkunx.setValue(ControlpanelTile.this.obj.isQuinkunx());
                ControlpanelTile.this.aspekteAnAus = !ControlpanelTile.this.aspekteAnAus;
                ControlpanelTile.this.pictureDrawer.recreatePicture();
            }
        });
        if (this.horoskop.planetenSaetze <= 1) {
            this.createPlanetenEinAusGroup1(c2, "Planeten");
        } else {
            Composite c2r = this.guiUtil.createRowComposite(c2, 2);
            this.createPlanetenEinAusGroup1(c2r, "Planeten 1");
            Composite g = this.createPlanetenEinAusGroup2(c2r, "Planeten 2");
            g.setForeground(ColorFactory.getInstance().colorRed);
        }
        Group g6 = GuiContainer.newGroup(c2, "Schablone", 1, 1);
        Composite g6a = this.guiUtil.createRowComposite((Composite)g6, 2);
        this.schablone = this.guiUtil.createCheckbox(g6a, "anzeigen", null);
        this.schabloneWinkelButton = this.guiUtil.createPushButton(g6a, "Winkel", null);
        this.addListener(this.schablone);
        this.schabloneWinkel = this.guiUtil.createText((Composite)g6, "Winkel", 0, 0);
        this.guiUtil.disableOneWidget(this.schabloneWinkel);
        this.schablonePlanet1 = this.guiUtil.createCombo((Composite)g6, this.planeten1Array, "Bezugs-Planet", 0);
        if (this.horoskop.getPlanetenSaetze() > 1) {
            this.schablonePlanet2 = this.guiUtil.createCombo((Composite)g6, this.planeten2Array, "Bezugs-Planet", 0);
            this.schablonePlanet2.getWidget().setForeground(ColorFactory.getInstance().colorRed);
        }
        Composite g6b = this.guiUtil.createRowComposite((Composite)g6, 2);
        this.schabloneLinksDrehen = this.guiUtil.createPushButton(g6b, "links drehen", Resources.ICON.ROTATE_LEFT);
        this.schabloneRechtsDrehen = this.guiUtil.createPushButton(g6b, "rechts drehen", Resources.ICON.ROTATE_RIGHT);
        this.schabloneLinksDrehen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ControlpanelTile.this.schablone.setValue(true);
                if (ControlpanelTile.this.schablonePlanet1 != null) {
                    ControlpanelTile.this.schablonePlanet1.setStringValue("");
                }
                if (ControlpanelTile.this.schablonePlanet2 != null) {
                    ControlpanelTile.this.schablonePlanet2.setStringValue("");
                }
                ControlpanelTile.this.obj.setSchablonePlanetIdSatz1(-1);
                ControlpanelTile.this.obj.setSchablonePlanetIdSatz2(-1);
                ControlpanelTile.this.obj.setSchabloneAlpha(Trigo.grad(ControlpanelTile.this.obj.getSchabloneAlpha() + 1.0));
                ControlpanelTile.this.pictureDrawer.recreatePicture();
            }
        });
        this.schabloneRechtsDrehen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ControlpanelTile.this.schablone.setValue(true);
                if (ControlpanelTile.this.schablonePlanet1 != null) {
                    ControlpanelTile.this.schablonePlanet1.setStringValue("");
                }
                if (ControlpanelTile.this.schablonePlanet2 != null) {
                    ControlpanelTile.this.schablonePlanet2.setStringValue("");
                }
                ControlpanelTile.this.obj.setSchablonePlanetIdSatz1(-1);
                ControlpanelTile.this.obj.setSchablonePlanetIdSatz2(-1);
                ControlpanelTile.this.obj.setSchabloneAlpha(Trigo.grad(ControlpanelTile.this.obj.getSchabloneAlpha() - 1.0));
                ControlpanelTile.this.pictureDrawer.recreatePicture();
            }
        });
        if (this.schablonePlanet1 != null) {
            this.schablonePlanet1.getWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int idx = 0;
                    try {
                        ControlpanelTile.this.schablone.setValue(true);
                        idx = ControlpanelTile.this.schablonePlanet1.getSelectionIndex() - 1;
                        ControlpanelTile.this.obj.setSchablonePlanetIdSatz1(idx);
                        if (ControlpanelTile.this.schablonePlanet2 != null) {
                            ControlpanelTile.this.schablonePlanet2.setStringValue("");
                            ControlpanelTile.this.obj.setSchablonePlanetIdSatz2(-1);
                        }
                        ControlpanelTile.this.pictureDrawer.recreatePicture();
                    }
                    catch (Exception ex) {
                        ErrorHandler.handleError(log, "Es gibt keinen Planeten mit dem Index " + idx);
                    }
                }
            });
        }
        if (this.schablonePlanet2 != null) {
            this.schablonePlanet2.getWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int idx = 0;
                    try {
                        ControlpanelTile.this.schablone.setValue(true);
                        idx = ControlpanelTile.this.schablonePlanet2.getSelectionIndex() - 1;
                        ControlpanelTile.this.obj.setSchablonePlanetIdSatz2(idx);
                        if (ControlpanelTile.this.schablonePlanet1 != null) {
                            ControlpanelTile.this.schablonePlanet1.setStringValue("");
                            ControlpanelTile.this.obj.setSchablonePlanetIdSatz1(-1);
                        }
                        ControlpanelTile.this.pictureDrawer.recreatePicture();
                    }
                    catch (Exception ex) {
                        ErrorHandler.handleError(log, "Es gibt keinen Planeten mit dem Index " + idx);
                    }
                }
            });
        }
        this.schabloneWinkelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ControlpanelTile.this.schablone.setValue(true);
                    PopupTkzGmsDialog dialog = new PopupTkzGmsDialog(MainApplicationWindow.getInstance().getShell(), new TkzGms(), false);
                    dialog.open();
                    if (dialog.getReturnCode() != 1 && dialog.getReturnCode() != 2) {
                        ControlpanelTile.this.schablone.setValue(true);
                        TkzGms gms = dialog.getBusinessObject();
                        if (ControlpanelTile.this.schablonePlanet1 != null) {
                            ControlpanelTile.this.obj.setSchablonePlanetIdSatz1(-1);
                            ControlpanelTile.this.schablonePlanet1.setStringValue("");
                        }
                        if (ControlpanelTile.this.schablonePlanet2 != null) {
                            ControlpanelTile.this.obj.setSchablonePlanetIdSatz2(-1);
                            ControlpanelTile.this.schablonePlanet2.setStringValue("");
                        }
                        ControlpanelTile.this.obj.setSchabloneAlpha(gms.getWinkel(((ControlpanelTile)ControlpanelTile.this).horoskopCalculator.getAstrodaten1().housesInfo.getAc()));
                        ControlpanelTile.this.pictureDrawer.recreatePicture();
                    }
                }
                catch (Exception ex) {
                    ErrorHandler.handleError(log, "Dieser Winkel kann nicht eingestellt werden");
                }
            }
        });
        if (LicenseHandler.getInstance().isAllowed(LicenseHandler.LicenseType.BASIC) && this.horoskop.planetenSaetze == 2) {
            Group g7 = GuiContainer.newGroup(c2, "Planetzyklus", 1, 1);
            this.popupPlanetzyklus = this.guiUtil.createPushButton((Composite)g7, "Planetenzyklus", "Planetenzyklus", null);
            this.popupPlanetzyklus.getWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        ControlpanelTile.this.popupPlanetenzyklus();
                    }
                    catch (Exception ex) {
                        ErrorHandler.handleError(log, ex);
                    }
                }
            });
        }
    }

    private void popupPlanetenzyklus() throws MappingException, TechnicalException, DatabaseException {
        ExchangeParameter exchangeParameter = new ExchangeParameter();
        exchangeParameter.planet1 = GlobalData.getInstance().getPlanetenzyklus_planet1();
        exchangeParameter.planet2 = GlobalData.getInstance().getPlanetenzyklus_planet2();
        exchangeParameter.aspektTyp = GlobalData.getInstance().getPlanetenzyklus_aspektTyp();
        exchangeParameter.date = this.horoskopCalculator.getRelevantDate();
        PopupPlanetenzyklusDialog dialog = new PopupPlanetenzyklusDialog(MainApplicationWindow.getInstance().getShell());
        dialog.setValue(exchangeParameter);
        dialog.open();
        if (dialog.getReturnCode() != 1 && dialog.getReturnCode() != 2 && dialog.getReturnCode() == 0) {
            exchangeParameter = dialog.getValue();
            this.pictureDrawer.repaintHoroskop();
            NextPlanetMatch npm = new NextPlanetMatch(this.horoskopCalculator);
            switch (exchangeParameter.planet2) {
                case 6: {
                    exchangeParameter.date = DateUtil.dateAddYears(exchangeParameter.date, 1);
                    break;
                }
                case 7: {
                    exchangeParameter.date = DateUtil.dateAddYears(exchangeParameter.date, 2);
                    break;
                }
                case 8: {
                    exchangeParameter.date = DateUtil.dateAddYears(exchangeParameter.date, 3);
                    break;
                }
                case 9: {
                    exchangeParameter.date = DateUtil.dateAddYears(exchangeParameter.date, 5);
                }
            }
            npm.gotoNextPosition(exchangeParameter);
            this.pictureDrawer.repaintHoroskop();
            Popup.info(Constants.planeten[exchangeParameter.planet1] + " - " + Constants.planeten[exchangeParameter.planet2] + " " + npm.getLastAspekt().langname + " am " + Converter.dateToString(npm.getLastDate()));
        }
    }

    private void createPlanetenEinAusGroup1(Composite c, String ueberschrift) {
        Group g5 = GuiContainer.newGroup(c, ueberschrift, 1, 1);
        for (int i = 0; i < Controlpanel.anzPlaneten; ++i) {
            this.planeten1[i] = this.guiUtil.createCheckbox((Composite)g5, Constants.planeten[i], null);
            this.addListener(this.planeten1[i]);
        }
        this.retrograde1 = this.guiUtil.createCheckbox((Composite)g5, "R", null);
        this.addListener(this.retrograde1);
        this.switchPlanetenButton1 = this.guiUtil.createPushButton((Composite)g5, "Ein/Aus", "Alle Planeten Ein/Aus schalten", null);
        this.switchPlanetenButton1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ControlpanelTile.this.planetenAnAus1 = ControlpanelTile.this.planetenAnAus1.getNext();
                for (int i = 0; i < Controlpanel.anzPlaneten; ++i) {
                    if (ControlpanelTile.this.planetenAnAus1 == TripleAnAus.Ein) {
                        ControlpanelTile.this.planeten1[i].setValue(Util.equals(i, ControlpanelTile.this.allImportantPlanetIDs));
                        continue;
                    }
                    if (ControlpanelTile.this.planetenAnAus1 == TripleAnAus.Halb) {
                        ControlpanelTile.this.planeten1[i].setValue(Util.equals(i, ControlpanelTile.this.transformerIDs));
                        continue;
                    }
                    if (ControlpanelTile.this.planetenAnAus1 != TripleAnAus.Aus) continue;
                    ControlpanelTile.this.planeten1[i].setValue(false);
                }
                ControlpanelTile.this.pictureDrawer.recreatePicture();
            }
        });
    }

    private Composite createPlanetenEinAusGroup2(Composite c, String ueberschrift) {
        Group g5 = GuiContainer.newGroup(c, ueberschrift, 1, 1);
        for (int i = 0; i < Controlpanel.anzPlaneten; ++i) {
            this.planeten2[i] = this.guiUtil.createCheckbox((Composite)g5, Constants.planeten[i], null);
            this.planeten2[i].getWidget().setForeground(ColorFactory.getInstance().colorRed);
            this.addListener(this.planeten2[i]);
        }
        this.retrograde2 = this.guiUtil.createCheckbox((Composite)g5, "R", null);
        this.retrograde2.getWidget().setForeground(ColorFactory.getInstance().colorRed);
        this.addListener(this.retrograde2);
        this.switchPlanetenButton2 = this.guiUtil.createPushButton((Composite)g5, "Ein/Aus", "Alle Planeten Ein/Aus schalten", null);
        this.switchPlanetenButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ControlpanelTile.this.planetenAnAus2 = ControlpanelTile.this.planetenAnAus2.getNext();
                for (int i = 0; i < Controlpanel.anzPlaneten; ++i) {
                    if (ControlpanelTile.this.planetenAnAus2 == TripleAnAus.Ein) {
                        ControlpanelTile.this.planeten2[i].setValue(Util.equals(i, ControlpanelTile.this.allImportantPlanetIDs));
                        continue;
                    }
                    if (ControlpanelTile.this.planetenAnAus2 == TripleAnAus.Halb) {
                        ControlpanelTile.this.planeten2[i].setValue(Util.equals(i, ControlpanelTile.this.transformerIDs));
                        continue;
                    }
                    if (ControlpanelTile.this.planetenAnAus2 != TripleAnAus.Aus) continue;
                    ControlpanelTile.this.planeten2[i].setValue(false);
                }
                ControlpanelTile.this.pictureDrawer.recreatePicture();
            }
        });
        return g5;
    }

    public void setData(Controlpanel obj) throws MappingException {
        int i;
        this.obj = obj;
        if (this.horoskop.planetenSaetze > 1) {
            this.horoskop1.setValue(obj.isHoroskop1());
            this.horoskop2.setValue(obj.isHoroskop2());
            this.aspekte1.setValue(obj.isAspekte1());
            this.aspekte2.setValue(obj.isAspekte2());
            this.interAspekte.setValue(obj.isInterAspekte());
        }
        this.iconType.setValue(obj.getIconTypeId());
        this.iconSize.setValue(obj.getIconSizeId());
        this.reporttyp.setValue(obj.getReporttypId());
        this.lineWidth.setValue(obj.getLineWidth());
        this.eigeneAnalysetexte.setValue(obj.isEigeneAnalysetexte());
        this.gradzahlen.setValue(obj.isGradzahlen());
        this.gradzahlenMitZahl.setValue(obj.isGradzahlenMitZahl());
        this.zwischenskala.setValue(obj.isZwischenskala());
        this.jahresring.setValue(obj.isJahresring());
        this.hauslinien.setValue(obj.isHauslinien());
        this.zeiger.setValue(obj.isZeiger());
        this.konjunktion.setValue(obj.isKonjunktion());
        this.sextil.setValue(obj.isSextil());
        this.quadrat.setValue(obj.isQuadrat());
        this.trigon.setValue(obj.isTrigon());
        this.opposition.setValue(obj.isOpposition());
        this.quinkunx.setValue(obj.isQuinkunx());
        this.schablone.setValue(obj.isSchablone());
        if (obj.isSchablone()) {
            this.schabloneWinkel.setValue(obj.getSchabloneWinkelAsString());
        } else {
            this.schabloneWinkel.setValue("");
            this.schablonePlanet1.setValueByText("");
            if (this.schablonePlanet2 != null) {
                this.schablonePlanet2.setValueByText("");
            }
        }
        for (i = 0; i < Controlpanel.anzPlaneten; ++i) {
            this.planeten1[i].setValue(obj.getPlaneten1()[i]);
        }
        this.retrograde1.setValue(obj.isRetrograde1());
        if (this.horoskop.planetenSaetze > 1) {
            for (i = 0; i < Controlpanel.anzPlaneten; ++i) {
                this.planeten2[i].setValue(obj.getPlaneten2()[i]);
            }
            this.retrograde2.setValue(obj.isRetrograde2());
        }
    }

    public Controlpanel getData() throws MappingException {
        if (this.horoskop.planetenSaetze > 1) {
            this.obj.setHoroskop1(this.horoskop1.getValue());
            this.obj.setHoroskop2(this.horoskop2.getValue());
            this.obj.setAspekte1(this.aspekte1.getValue());
            this.obj.setAspekte2(this.aspekte2.getValue());
            this.obj.setInterAspekte(this.interAspekte.getValue());
        } else {
            this.obj.setHoroskop2(false);
            this.obj.setAspekte2(false);
            this.obj.setInterAspekte(false);
        }
        this.obj.setIconTypeId(this.iconType.getValue());
        this.obj.setIconSizeId(this.iconSize.getValue());
        this.obj.setReporttypId(this.reporttyp.getValue());
        this.obj.setLineWidth(this.lineWidth.getIntValue());
        this.obj.setEigeneAnalysetexte(this.eigeneAnalysetexte.getValue());
        this.obj.setGradzahlen(this.gradzahlen.getValue());
        this.obj.setGradzahlenMitZahl(this.gradzahlenMitZahl.getValue());
        this.obj.setJahresring(this.jahresring.getValue());
        this.obj.setHauslinien(this.hauslinien.getValue());
        this.obj.setZeiger(this.zeiger.getValue());
        this.obj.setZwischenskala(this.zwischenskala.getValue());
        this.obj.setAnonym(this.anonym.getValue());
        this.obj.setInvisible(this.invisible.getValue());
        this.obj.setKonjunktion(this.konjunktion.getValue());
        this.obj.setSextil(this.sextil.getValue());
        this.obj.setQuadrat(this.quadrat.getValue());
        this.obj.setTrigon(this.trigon.getValue());
        this.obj.setOpposition(this.opposition.getValue());
        this.obj.setQuinkunx(this.quinkunx.getValue());
        this.obj.setSchablone(this.schablone.getValue());
        for (int i = 0; i < Controlpanel.anzPlaneten; ++i) {
            this.obj.getPlaneten1()[i] = this.planeten1[i].getValue();
            this.obj.setRetrograde1(this.retrograde1.getValue());
            if (this.horoskop.planetenSaetze <= 1) continue;
            this.obj.getPlaneten2()[i] = this.planeten2[i].getValue();
            this.obj.setRetrograde2(this.retrograde2.getValue());
        }
        if (this.horoskop == Horoskop.Transit) {
            // empty if block
        }
        return this.obj;
    }

    private void addListener(ButtonWrapper button) {
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ControlpanelTile.this.pictureDrawer.recreatePicture();
            }
        });
    }

    private void addComboListener(ComboWrapper button) {
        button.getWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ControlpanelTile.this.pictureDrawer.recreatePicture();
            }
        });
    }

    private void addListener(TextWrapper text) {
        text.getWidget().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                ControlpanelTile.this.pictureDrawer.recreatePicture();
            }
        });
    }

    static enum TripleAnAus {
        Ein,
        Halb,
        Aus;


        TripleAnAus getNext() {
            if (this == Ein) {
                return Aus;
            }
            if (this == Aus) {
                return Halb;
            }
            return Ein;
        }
    }
}

