/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.settings;

import de.cni.client.calculation.CalculatorFactoryClient;
import de.cni.client.gui.action.toolbar.EditAction;
import de.cni.client.gui.action.toolbar.IEditable;
import de.cni.client.gui.action.toolbar.IRefreshable;
import de.cni.client.gui.action.toolbar.ISearchable;
import de.cni.client.gui.action.toolbar.RefreshAction;
import de.cni.client.gui.action.toolbar.SaveAction;
import de.cni.client.gui.pageflow.IPageController;
import de.cni.client.gui.pageflow.Page;
import de.cni.client.gui.pageflow.PageController;
import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.pages.settings.SettingsTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.GlobalData;
import de.cni.common.core.ObjectCopier;
import de.cni.common.core.ServerConnection;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Settings;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.CalculationException;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import de.cni.common.validation.IValidator;
import de.cni.common.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Composite;

public class SettingsController
extends PageController
implements ISearchable,
IEditable,
IRefreshable {
    private static Log log = LogFactory.getLog(SettingsController.class);
    protected List<IContributionItem> toolbarItems = new ArrayList<IContributionItem>();
    boolean loadDataDuringInitialization = true;
    protected IPageController.PageEditStatus pageEditStatus;
    protected boolean withText = true;
    IBusinessObject currentBusinessObject;
    IBusinessObjectVerwaltung<IBusinessObject> bean;
    SettingsTile tableDetailPage = null;
    protected IValidator validator = null;

    public SettingsController() {
        this.addToolbarItem(new ActionContributionItem((IAction)new SaveAction(this)), this.withText);
        if (!GlobalData.getInstance().isAlwaysEnabled()) {
            this.addToolbarItem(new ActionContributionItem((IAction)new EditAction(this)), this.withText);
        }
        this.addToolbarItem(new ActionContributionItem((IAction)new RefreshAction(this)), this.withText);
        this.bean = this.getServerBean();
    }

    @Override
    public Page getPage() {
        return Page.settings;
    }

    protected IBusinessObject createNewBusinessObject() {
        Settings object = new Settings();
        return object;
    }

    protected IBusinessObjectVerwaltung getServerBean() {
        ServerConnection serverConnection = ServerConnection.getInstance();
        IBusinessObjectVerwaltung<IBusinessObject> bean = serverConnection.getObjectVerwaltung();
        return bean;
    }

    @Override
    public void openPage(Composite parent) {
        try {
            this.pageEditStatus = IPageController.PageEditStatus.disabled;
            this.tableDetailPage = new SettingsTile(this);
            this.tableDetailPage.createContent(parent);
            this.getToolbarWrapper().initialize(MainApplicationWindow.getInstance().getToolBarManager());
            this.getToolbarWrapper().setToolbar(this.toolbarItems);
            if (this.loadDataDuringInitialization) {
                this.search();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    @Override
    public IBusinessObject getCurrentBusinessObject() {
        return this.currentBusinessObject;
    }

    @Override
    public void refresh() {
        this.search();
    }

    @Override
    public void search() {
        try {
            Settings object = null;
            Settings filter = new Settings();
            SqLiteDatabase db = new SqLiteDatabase();
            List<IBusinessObject> boList = db.select(filter);
            IBusinessObject bo = null;
            if (boList.size() == 0) {
                bo = this.createNewBusinessObject();
                object = (Settings)bo;
            } else if (boList.size() == 1) {
                bo = boList.get(0);
            } else if (boList.size() == 1) {
                bo = boList.get(0);
                Popup.warning("Es gibt mehrere Datens\u00e4tze f\u00fcr die Einstellungen");
            }
            this.currentBusinessObject = bo;
            this.tableDetailPage.setData(bo);
            this.pageEditStatus = IPageController.PageEditStatus.disabled;
            this.tableDetailPage.handleEditChanged();
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    @Override
    public void edit() {
        log.debug((Object)"edit aufgerufen");
        this.pageEditStatus = this.pageEditStatus != IPageController.PageEditStatus.disabled ? IPageController.PageEditStatus.disabled : (this.currentBusinessObject.getId() == 0 ? IPageController.PageEditStatus.enabledforNew : IPageController.PageEditStatus.enabledforUpdate);
        this.tableDetailPage.handleEditChanged();
    }

    @Override
    public boolean isDataChanged() {
        return this.tableDetailPage.isDataChanged();
    }

    @Override
    public IPageController.PageEditStatus getPageEditStatus() {
        return this.pageEditStatus;
    }

    public void setPageEditStatus(IPageController.PageEditStatus pageEditStatus) {
        this.pageEditStatus = pageEditStatus;
    }

    public void useSettings() {
        try {
            this.currentBusinessObject = this.tableDetailPage.getData();
            this.setSettings();
            this.tableDetailPage.setData(this.currentBusinessObject);
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    public void setSettings() {
        Settings userSettings = new Settings();
        ObjectCopier.getInstance().copyCorrespondingFields(userSettings, this.currentBusinessObject);
        GlobalData.getInstance().setSettings(userSettings);
    }

    @Override
    public void setFocusOnFilterHeader() {
    }

    public boolean isSaveable(IBusinessObject bo) {
        boolean ret = true;
        if (bo == null) {
            return false;
        }
        this.validator = ValidatorFactory.createValidator(bo, GlobalData.getInstance().getBrand());
        if (this.validator != null) {
            ret = this.validator.isValid(bo);
        }
        return ret;
    }

    @Override
    public String getSaveableValidationError() {
        if (this.validator != null && !Util.isEmpty(this.validator.getErrorText())) {
            return this.validator.getErrorText();
        }
        return "";
    }

    @Override
    public void save() throws DatabaseException, CalculationException, MappingException {
        this.currentBusinessObject = this.tableDetailPage.getData();
        if (!this.isSaveable(this.currentBusinessObject)) {
            Popup.warning(this.getSaveableValidationError());
            return;
        }
        IBusinessObject savedBusinessObject = null;
        try {
            SqLiteDatabase db = new SqLiteDatabase();
            savedBusinessObject = db.save(this.currentBusinessObject);
        }
        catch (Exception e) {
            throw new DatabaseException(DatabaseException.ErrorType.customText, "Fehler beim Speicher. " + e.getClass() + ", " + e.getMessage());
        }
        this.currentBusinessObject = savedBusinessObject;
        this.currentBusinessObject = this.getCurrentBusinessObject();
        this.currentBusinessObject.setLetzterBearbeiter(GlobalData.getInstance().getUser().getBearbeiter());
        CalculatorFactoryClient.createCalculator(this.currentBusinessObject).prepareSave(this.currentBusinessObject);
        IBusinessObject objectBeforeSave = this.currentBusinessObject;
        this.tableDetailPage.setData(this.currentBusinessObject);
        this.pageEditStatus = IPageController.PageEditStatus.disabled;
        this.tableDetailPage.handleEditChanged();
        this.setSettings();
    }

    protected void addToolbarItem(ActionContributionItem item, boolean withText) {
        if (this.toolbarItems == null) {
            this.toolbarItems = new ArrayList<IContributionItem>();
        }
        if (withText) {
            item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        }
        this.toolbarItems.add((IContributionItem)item);
    }

    @Override
    public boolean isLoadAllDataDuringInitialization() {
        return false;
    }
}

