/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.personendaten;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.pages.personendaten.PersonendatenTile;
import de.cni.client.gui.popup.filter.PopupPersonBefundDialog;
import de.cni.client.gui.tiles.table.PersonBefundTableController;
import de.cni.client.gui.tiles.table.templates.ITableListener;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.datamodel.admin.PersonBefund;
import de.cni.common.datamodel.admin.Personendaten;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersonBefundTableListener
implements ITableListener {
    private static Log log = LogFactory.getLog(PersonBefundTableListener.class);
    PersonBefundTableController personBefundTableController;
    private PersonendatenTile personendatenTile;

    public PersonBefundTableListener(PersonBefundTableController personBefundTableController, PersonendatenTile personendatenTile) {
        this.personBefundTableController = personBefundTableController;
        this.personendatenTile = personendatenTile;
    }

    @Override
    public void selectionChanged(Object firstObject, int cnt) {
        PersonBefund pb = (PersonBefund)firstObject;
        if (pb != null) {
            this.personendatenTile.setPersonBefundText(pb.getText());
        } else {
            this.personendatenTile.setPersonBefundText("");
        }
    }

    @Override
    public boolean deleteLine() {
        try {
            SqLiteDatabase db = new SqLiteDatabase();
            List<Object> l = this.personBefundTableController.getSelectedObjects();
            if (l != null && l.size() > 0) {
                for (Object obj : l) {
                    db.delete((PersonBefund)obj);
                }
            }
            return true;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return false;
        }
    }

    @Override
    public boolean newLine() {
        try {
            Personendaten personendaten = this.personendatenTile.getData();
            if (personendaten.getId() == 0) {
                Popup.warning("Sie m\u00fcssen eine neue Person zun\u00e4chst einmal speichern, bevor Sie einen Befund erfassen k\u00f6nnen.");
                return false;
            }
            PersonBefund personBefund = new PersonBefund();
            personBefund.setPersonId(personendaten.getId());
            personBefund.setDatum(new Date());
            personBefund = this.editLine(personBefund);
            if (personBefund != null) {
                personendaten.getPersonBefundList().add(0, personBefund);
                this.personBefundTableController.setObjectList(personendaten.getPersonBefundList());
                this.personBefundTableController.setSelection(personBefund);
            }
            return true;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return false;
        }
    }

    public PersonBefund editLine(PersonBefund personBefund) {
        try {
            PopupPersonBefundDialog dialog = new PopupPersonBefundDialog(MainApplicationWindow.getInstance().getShell(), personBefund);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                personBefund = dialog.getValue();
                SqLiteDatabase db = new SqLiteDatabase();
                personBefund = (PersonBefund)db.save(personBefund);
                this.personendatenTile.setPersonBefundText(personBefund.getText());
                return personBefund;
            }
            return null;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return null;
        }
    }

    @Override
    public void doubleClick(Object object) {
        try {
            Personendaten personendaten = this.personendatenTile.getData();
            if (personendaten.getId() == 0) {
                Popup.warning("Sie m\u00fcssen eine neue Person zun\u00e4chst einmal speichern, bevor Sie einen Befund erfassen k\u00f6nnen.");
                return;
            }
            PersonBefund personBefund = (PersonBefund)object;
            if ((personBefund = this.editLine(personBefund)) != null) {
                this.personBefundTableController.setSelection(personBefund);
            }
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }
}

