/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.main;

import de.cni.client.gui.pageflow.IPageController;
import de.cni.client.gui.pageflow.MainController;
import de.cni.client.gui.pageflow.PageFlowController;
import de.cni.client.gui.pages.main.MainMenuBar;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.Popup;
import de.cni.client.gui.util.Resources;
import de.cni.client.gui.util.ToolbarWrapper;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.Converter;
import de.cni.common.core.Datensicherung;
import de.cni.common.core.Formatter;
import de.cni.common.core.GlobalData;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.datamodel.admin.Monitoraufloesung;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class MainApplicationWindow
extends ApplicationWindow {
    private static Log log = LogFactory.getLog(MainApplicationWindow.class);
    private static MainApplicationWindow APP;
    Composite mainComposite;
    MainController mainController;
    Composite child = null;
    int width = 0;
    int height = 0;

    public MainApplicationWindow() {
        super(null);
        try {
            log.debug((Object)"Beginn MainApplicationWindow");
            APP = this;
            this.addMenuBar();
            this.addToolBar(0x800000);
            this.addStatusLine();
            this.mainController = new MainController();
            log.debug((Object)"Ende MainApplicationWindow");
        }
        catch (Exception e) {
            log.error((Object)"Technischer Fehler. Applikation kann nicht gestartet werden.");
            e.printStackTrace();
        }
    }

    public static final MainApplicationWindow getInstance() {
        if (APP == null) {
            APP = new MainApplicationWindow();
        }
        return APP;
    }

    public void run() {
        log.debug((Object)"Before this.getParentShell()");
        log.debug((Object)"Before this.getParentShell()");
        log.debug((Object)"Before setBlockOnOpen");
        this.setBlockOnOpen(true);
        log.debug((Object)"Before open");
        this.open();
        log.debug((Object)"Display.getCurrent().dispose()");
    }

    protected Control createContents(Composite parent) {
        Composite master;
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        this.mainComposite = master = (this.child = GuiContainer.newFrame((Composite)sc));
        this.mainController.openPage(master);
        sc.setContent((Control)this.child);
        log.debug((Object)("Child-Size " + this.getShell().getDisplay().getClientArea()));
        log.debug((Object)("Display-Bounds " + this.getShell().getDisplay().getBounds()));
        log.debug((Object)("Shell-Border " + this.getShell().getBorderWidth()));
        log.debug((Object)("Shell-Bounds " + this.getShell().getBounds()));
        log.debug((Object)("Shell-ClientArea " + this.getShell().getClientArea()));
        log.debug((Object)("Child-Bounds " + this.child.getShell().getBounds()));
        this.resizeWindow(true);
        this.getMenuBarManager().update();
        PageFlowController.getInstance().getCurrentPageController().setFocusOnFilterHeader();
        this.getShell().addListener(11, new Listener(){

            public void handleEvent(Event e) {
                MainApplicationWindow.this.resizeWindow(false);
            }
        });
        return master;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        MainApplicationWindow.setShellTitle(shell, false);
    }

    protected MenuManager createMenuManager() {
        return MainMenuBar.getMenuBar();
    }

    protected ToolBarManager createToolBarManager(int style) {
        ToolBarManager tbm = new ToolBarManager(style);
        return tbm;
    }

    protected CoolBarManager createCoolBarManager(int style) {
        CoolBarManager cbm = new CoolBarManager(style);
        cbm.add((IToolBarManager)this.createToolBarManager(0x800000));
        return cbm;
    }

    protected StatusLineManager createStatusLineManager() {
        StatusLineManager slm = new StatusLineManager();
        return slm;
    }

    public void clearMainComposite() {
        if (this.mainComposite != null && this.mainComposite.getChildren() != null && this.mainComposite.getChildren().length > 0) {
            this.mainComposite.getChildren()[0].dispose();
        }
        ToolbarWrapper tbw = new ToolbarWrapper();
        tbw.initialize(MainApplicationWindow.getInstance().getToolBarManager());
        tbw.resetToolbar();
    }

    public Composite getMainComposite() {
        return this.mainComposite;
    }

    protected void handleShellCloseEvent() {
        if (PageFlowController.getInstance().getCurrentPageController() == null) {
            super.handleShellCloseEvent();
            return;
        }
        if (PageFlowController.getInstance().getCurrentPageController().isDiscardChanges()) {
            Datensicherung.automatischeSicherung();
            for (IPageController controller : PageFlowController.getInstance().getAllPageControllers()) {
                controller.terminate();
            }
            super.handleShellCloseEvent();
        }
    }

    public void popupWarning(String text) {
        MessageDialog.openWarning((Shell)this.getShell(), (String)"Warnung", (String)text);
    }

    public void popupError(String text) {
        MessageDialog.openError((Shell)this.getShell(), (String)"Fehlermeldung", (String)text);
    }

    public boolean popupQuestion(String text) {
        MessageDialog md = new MessageDialog(this.getShell(), "Frage", null, text, 3, new String[]{"Ja", "Nein"}, 1);
        return md.open() == 0;
    }

    public int popupTripleQuestion(String text) {
        MessageDialog md = new MessageDialog(this.getShell(), "Frage", null, text, 3, new String[]{"Ja", "Nein", "Abbrechen"}, 2);
        return md.open();
    }

    public void popupInfo(String text) {
        Font f = new Font((Device)MainApplicationWindow.getInstance().getShell().getDisplay(), "Courier New", 8, 0);
        this.getShell().setFont(f);
        MessageDialog.openInformation((Shell)this.getShell(), (String)"Hinweis", (String)text);
    }

    public void asyncPopupInfo(final String text) {
        final Shell shell = this.getShell();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)shell, (String)"Hinweis", (String)text);
            }
        });
    }

    public void popupCourierInfo(String text) {
        Font f = new Font((Device)MainApplicationWindow.getInstance().getShell().getDisplay(), "Courier New", 8, 0);
        MessageBox messageBox = new MessageBox(MainApplicationWindow.getInstance().getShell(), 34);
        messageBox.setText("Hinweis");
        messageBox.getParent().setFont(f);
        messageBox.setMessage(text);
        messageBox.open();
    }

    public void popupNotImplemented() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)"Hinweis", (String)"Diese Funktionalit\u00e4t steht noch nicht zur Verf\u00fcgung");
    }

    public void popupNoDataFound() {
        MessageDialog.openQuestion((Shell)this.getShell(), (String)"Hinweis", (String)"Zu Ihrer Auswahl wurden keine Daten gefunden");
    }

    public void popupAbout() {
        String application_name = "";
        String jboss_version = "";
        String mysql_version = "";
        String client_version = "";
        String client_build = "";
        String client_branding = "";
        String server_version = "";
        String server_build = "";
        String server_branding = "";
        String server_name = "";
        try {
            ApplicationProperties props = ApplicationProperties.getInstance();
            application_name = props.getProperty("application.name");
            client_version = props.getProperty("application.version");
            client_build = props.getProperty("application.client.build");
            client_branding = props.getProperty("application.brand");
        }
        catch (Exception e) {
            log.error((Object)"Versions-Strings k\u00f6nnen nicht aus den Client Properties ermittelt werden.");
        }
        SqLiteDatabase db = new SqLiteDatabase();
        String dbVersion = db.getCurrentDbVersion() == -1 ? "unbekannt" : Converter.intToString(db.getCurrentDbVersion());
        String popupText = Formatter.aboutString(application_name, client_version, client_build, client_branding, server_version, server_build, server_name, server_branding, jboss_version, dbVersion);
        Popup.infoCourier(popupText);
    }

    public void resizeWindow(boolean fix) {
        Monitoraufloesung m = GlobalData.getInstance().getMonitoraufloesung();
        int xShellSize = this.getShell().getDisplay().getBounds().width;
        int yShellSize = this.getShell().getDisplay().getBounds().height;
        int xDisplayClientArea = this.getShell().getDisplay().getClientArea().width;
        int yDisplayClientArea = this.getShell().getDisplay().getClientArea().height;
        if (!fix) {
            int currentWidth = this.getShell().getSize().x;
            int currentHeight = this.getShell().getSize().y;
            m.setWidth(currentWidth);
            m.setHeight(currentHeight);
        }
        if (m != null) {
            int yShell;
            int xShell;
            if (m.getWidth() == xShellSize && m.getHeight() == yShellSize) {
                xShell = xDisplayClientArea;
                yShell = yDisplayClientArea;
                this.getShell().setMaximized(true);
                int xClient = xShell;
                int yClient = yShell - m.getyToolbarSize();
                this.child.setSize(xClient, yClient);
            } else if (m.getWidth() > xDisplayClientArea && m.getHeight() > yDisplayClientArea) {
                xShell = xDisplayClientArea;
                yShell = yDisplayClientArea;
                this.getShell().setMaximized(true);
                int xClient = m.getWidth() - m.getxBorderSize();
                int yClient = m.getHeight() - m.getyToolbarSize() - m.getyBorderSize();
                this.child.setSize(xClient, yClient);
            } else {
                xShell = m.getWidth();
                yShell = m.getHeight();
                this.getShell().setSize(xShell, yShell);
                int xClient = xShell - m.getxBorderSize();
                int yClient = yShell - m.getyBorderSize() - m.getyToolbarSize();
                this.child.setSize(xClient, yClient);
            }
        }
    }

    public StatusLineManager getStatusLineManager() {
        return super.getStatusLineManager();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static void setShellTitle(Shell shell, boolean withLicense) {
        shell.setImage(Resources.getInstance().getImage(Resources.ICON.TITLE_ICON));
        ApplicationProperties props = ApplicationProperties.getInstance();
        StringBuffer sb = new StringBuffer();
        sb.append(props.getProperty("application.name"));
        if (withLicense) {
            sb.append(" (");
            sb.append(props.getProperty("application.company"));
            sb.append(")");
        }
        shell.setText(sb.toString());
    }
}

