/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.geodaten;

import de.cni.client.gui.templates.filter.AbstractFilterHeaderTile;
import de.cni.client.gui.templates.filter.IFilterController;
import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.TextWrapper;
import de.cni.common.core.GlobalData;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Geodaten;
import de.cni.common.exceptions.MappingException;
import javax.naming.NamingException;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class GeodatenFilterTile
extends AbstractFilterHeaderTile {
    Group group;
    TextWrapper kontinent;
    TextWrapper lkz;
    TextWrapper plz;
    TextWrapper ort;
    ButtonWrapper datenbankButton;
    ButtonWrapper webserviceButton;

    protected GeodatenFilterTile(IFilterController controller, int[] weights) throws NamingException {
        super(controller, weights, PAGE_FILTER);
    }

    @Override
    public void createGuiFilterElements(Composite parent) throws MappingException {
        RowLayout filterRowLayout = new RowLayout();
        filterRowLayout.pack = false;
        Composite filterComposite = new Composite(parent, 0);
        filterComposite.setLayout((Layout)filterRowLayout);
        Composite c = this.newComposite(filterComposite);
        this.guiUtil.createLabel(c, "Kontinent-Kennzeichen");
        this.kontinent = this.guiUtil.createText(c, "Kontinent-Kennzeichen (2stellig)", 90, 10);
        this.kontinent.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
        this.guiUtil.createLabel(c, "L\u00e4nder-Kennzeichen");
        this.lkz = this.guiUtil.createText(c, "L\u00e4nderkennzeichen (2stellig)", 90, 2);
        this.lkz.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
        c = this.newComposite(filterComposite);
        this.guiUtil.createLabel(c, "PLZ");
        this.plz = this.guiUtil.createText(c, "PLZ", 90, 20);
        this.plz.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
        this.guiUtil.createLabel(c, "Ort");
        this.ort = this.guiUtil.createText(c, "Ort", 90, 200);
        this.ort.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
        if (this.pageFilterController.getPageController().isPopupMode()) {
            c = this.newComposite(filterComposite);
            this.guiUtil.createLabel(c, "Datenbank");
            this.datenbankButton = this.guiUtil.createRadiobox(c, "Datenbank");
            this.datenbankButton.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
            this.guiUtil.createLabel(c, "Webservice");
            this.webserviceButton = this.guiUtil.createRadiobox(c, "Web-Service");
            this.webserviceButton.getWidget().addSelectionListener((SelectionListener)this.filterSelectionListener);
        }
    }

    @Override
    public IBusinessObject getPageFilterData() throws MappingException {
        Geodaten object = new Geodaten();
        object.setKontinent(this.kontinent.getValue());
        object.setLkz(this.lkz.getValue());
        object.setPlz(this.plz.getValue());
        object.setOrt(this.ort.getValue());
        if (this.pageFilterController.getPageController().isPopupMode()) {
            object.setWebservice(this.webserviceButton.getValue());
        } else {
            object.setWebservice(false);
        }
        return object;
    }

    @Override
    public void setPageFilterData(IBusinessObject filterObject) throws MappingException {
        Geodaten object = (Geodaten)filterObject;
        this.kontinent.setValue(object.getKontinent());
        this.lkz.setValue(object.getLkz());
        this.plz.setValue(object.getPlz());
        this.ort.setValue(object.getOrt());
        if (this.pageFilterController.getPageController().isPopupMode()) {
            this.webserviceButton.setValue(GlobalData.getInstance().getSettings().isWebservice());
            this.datenbankButton.setValue(!GlobalData.getInstance().getSettings().isWebservice());
        }
    }

    @Override
    protected boolean isSelectOnClear() {
        return false;
    }

    @Override
    public void setFocus() {
        this.ort.setFocus();
    }
}

