/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.geodaten;

import de.cni.client.gui.action.toolbar.ISyncable;
import de.cni.client.gui.action.toolbar.SyncAction;
import de.cni.client.gui.pageflow.Page;
import de.cni.client.gui.pages.geodaten.GeodatenPage;
import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupRadiobuttonDialog;
import de.cni.client.gui.templates.tableAndDetail.ITableDetailPage;
import de.cni.client.gui.templates.tableAndDetail.ITableDetailPageController;
import de.cni.client.gui.templates.tableAndDetail.TableDetailPageController;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.GeoWebservice;
import de.cni.common.core.ServerConnection;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Geodaten;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.io.ImportGeodaten;
import de.cni.common.io.ImportPlzdaten;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;

public class GeodatenController
extends TableDetailPageController
implements ISyncable {
    private static Log log = LogFactory.getLog(GeodatenController.class);

    public GeodatenController() {
        super(DO_LOAD_ALL_DATA_DURING_INITIALIZATION);
        this.addToolbarItem(new ActionContributionItem((IAction)new SyncAction(this)), this.withText);
    }

    @Override
    public Page getPage() {
        return Page.geodaten;
    }

    @Override
    protected IBusinessObject createNewBusinessObject() {
        Geodaten object = new Geodaten();
        return object;
    }

    @Override
    protected ITableDetailPage createNewTableDetailPage(ITableDetailPageController controller) {
        return new GeodatenPage(controller);
    }

    protected IBusinessObjectVerwaltung getServerBean() {
        ServerConnection serverConnection = ServerConnection.getInstance();
        IBusinessObjectVerwaltung<IBusinessObject> gv = serverConnection.getObjectVerwaltung();
        return gv;
    }

    @Override
    public void sync() {
        try {
            if (!Popup.question("M\u00f6chten Sie neue Geo-Daten einlesen?\nAchtung: der vorhandene Bestand an Geo-Daten wird dabei gel\u00f6scht.")) {
                return;
            }
            PopupRadiobuttonDialog dialog = new PopupRadiobuttonDialog(MainApplicationWindow.getInstance().getShell(), "Bitte ...", new String[]{"PLZ-Datei", "Zeitzone-Datei"});
            dialog.open();
            if (dialog.getReturnCode() != 0) {
                return;
            }
            int index = dialog.getIndex();
            if (index == 0) {
                ImportPlzdaten.doImport();
            }
            if (index == 1) {
                ImportGeodaten.doImport();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    @Override
    protected List<IBusinessObject> doSelect(IBusinessObject filter) {
        List<IBusinessObject> selectedList = null;
        try {
            if (((Geodaten)filter).isWebservice()) {
                if (!((Geodaten)filter).isFilterEmpty()) {
                    GeoWebservice service = new GeoWebservice();
                    selectedList = service.search((Geodaten)filter);
                } else {
                    selectedList = new ArrayList();
                }
            } else {
                SqLiteDatabase db = new SqLiteDatabase();
                selectedList = db.select(filter);
            }
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            selectedList = new ArrayList<IBusinessObject>();
        }
        return selectedList;
    }
}

