/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.analyseHerrscher;

import de.cni.client.gui.action.toolbar.ISyncable;
import de.cni.client.gui.action.toolbar.IWerkseinstellungen;
import de.cni.client.gui.action.toolbar.SyncAction;
import de.cni.client.gui.action.toolbar.WerkseinstellungenAction;
import de.cni.client.gui.pageflow.Page;
import de.cni.client.gui.pages.analyseHerrscher.AnalyseHerrscherPage;
import de.cni.client.gui.templates.tableAndDetail.ITableDetailPage;
import de.cni.client.gui.templates.tableAndDetail.ITableDetailPageController;
import de.cni.client.gui.templates.tableAndDetail.TableDetailPageController;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.ServerConnection;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.AnalyseHerrscher;
import de.cni.common.datamodel.admin.CoreAnalyseHerrscher;
import de.cni.common.datamodel.admin.CustomAnalyseHerrscher;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.io.ImportAnalyseHerrscher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;

public class AnalyseHerrscherController
extends TableDetailPageController
implements ISyncable,
IWerkseinstellungen {
    private static Log log = LogFactory.getLog(AnalyseHerrscherController.class);
    private boolean core = true;

    public AnalyseHerrscherController(boolean core) {
        super(DO_LOAD_ALL_DATA_DURING_INITIALIZATION);
        this.core = core;
        this.addToolbarItem(new ActionContributionItem((IAction)new SyncAction(this)), this.withText);
        if (!core) {
            this.addToolbarItem(new ActionContributionItem((IAction)new WerkseinstellungenAction(this)), this.withText);
        }
    }

    @Override
    public Page getPage() {
        return this.core ? Page.coreAnalyseHerrscher : Page.customAnalyseHerrscher;
    }

    @Override
    protected IBusinessObject createNewBusinessObject() {
        AnalyseHerrscher object = this.core ? new CoreAnalyseHerrscher() : new CustomAnalyseHerrscher();
        return object;
    }

    @Override
    protected ITableDetailPage createNewTableDetailPage(ITableDetailPageController controller) {
        return new AnalyseHerrscherPage(controller);
    }

    protected IBusinessObjectVerwaltung getServerBean() {
        ServerConnection serverConnection = ServerConnection.getInstance();
        IBusinessObjectVerwaltung<IBusinessObject> gv = serverConnection.getObjectVerwaltung();
        return gv;
    }

    @Override
    public void sync() {
        try {
            if (!Popup.question("M\u00f6chten Sie neue Analyse-Schluessel-Themen einlesen?\nAchtung: der vorhandene Bestand an Analyse-Schl\u00fcssel-Themen wird dabei gel\u00f6scht.")) {
                return;
            }
            ImportAnalyseHerrscher.doImport(this.core);
            this.refresh();
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    public boolean isCore() {
        return this.core;
    }

    @Override
    public void werkseinstellungen() {
        try {
            SqLiteDatabase db = new SqLiteDatabase();
            db.analyseHerrscherCore2Custom();
            this.refresh();
            Popup.info("Die Analyse-Herrscher-Daten wurden erfolgreich auf Werkseinstellungen zur\u00fcckgesetzt.");
        }
        catch (Exception e) {
            Popup.error("Fehler beim Zur\u00fccksetzen auf Werkseinstellungen. " + e.getMessage());
        }
    }
}

