/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.calculation;

import de.cni.client.calculation.BasisCalculatorClient;
import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.exceptions.CalculationException;
import de.cni.common.exceptions.MappingException;
import java.util.Date;
import org.joda.time.DateTime;

public class PersonendatenCalculator
extends BasisCalculatorClient {
    private static final long serialVersionUID = 1L;

    @Override
    public void setDefaultValues(IBusinessObject object) throws MappingException {
    }

    @Override
    public void prepareSave(IBusinessObject object) throws CalculationException {
        Personendaten p = (Personendaten)object;
        if (Util.isEmpty(p.getWohnort()) && Util.isEmpty(p.getWohnortLatitude()) && Util.isEmpty(p.getWohnortLongitude())) {
            p.setWohnort(p.getGeburtsort());
            p.setWohnortLatitude(p.getLatitude());
            p.setWohnortLongitude(p.getLongitude());
        }
        Date date = this.getGeburtsdatum((Personendaten)object);
        p.setGeburtsdatum(date);
    }

    public Date getGeburtsdatum(Personendaten object) throws CalculationException {
        String localDate = DateUtil.fixDate(object.getGeburtsdatumLocal());
        String localTime = DateUtil.fixTime(object.getGeburtszeitLocal());
        DateTime dt = null;
        if (object.isGmtOffsetManuell()) {
            int offset = object.getGmtOffsetInMinutes();
            dt = DateUtil.localString2jodaDateTime(localDate, localTime);
            dt = dt.minusMinutes(offset);
        } else {
            dt = DateUtil.localString2jodaDateTime(localDate, localTime, object.getTimezoneId());
            double offset = DateUtil.getTimeZoneOffsetInHours(dt, object.getTimezoneId());
            object.setGmtOffsetInMinutes(Converter.gmtOffset2GmtOffsetInMinutes(offset));
        }
        String utcDateString = DateUtil.joda2UtcDateString(dt);
        String utcTimeString = DateUtil.joda2UtcHHmmTimeString(dt);
        object.setGeburtsdatumUtc(utcDateString);
        object.setGeburtszeitUtc(utcTimeString);
        Date date = DateUtil.jodaDate2UtcDate(dt);
        return date;
    }
}

