/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax0.license3j.License;
import javax0.license3j.io.IOFormat;

public class LicenseWriter
implements Closeable {
    private final OutputStream os;

    public LicenseWriter(OutputStream os) {
        this.os = os;
    }

    public LicenseWriter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public LicenseWriter(String fileName) throws FileNotFoundException {
        this(new File(fileName));
    }

    public void write(License license, IOFormat format) throws IOException {
        switch (format) {
            case BINARY: {
                this.os.write(license.serialized());
                return;
            }
            case BASE64: {
                this.os.write(Base64.getEncoder().encode(license.serialized()));
                return;
            }
            case STRING: {
                this.os.write(license.toString().getBytes(StandardCharsets.UTF_8));
                return;
            }
        }
        throw new IllegalArgumentException("License format " + (Object)((Object)format) + " is unknown");
    }

    public void write(License license) throws IOException {
        this.write(license, IOFormat.BINARY);
    }

    @Override
    public void close() {
    }
}

