/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import swisseph.SwephData;
import swisseph.SwissEph;
import swisseph.SwissephException;
import swisseph.TransitCalculator;

public class TCPlanet
extends TransitCalculator {
    private int planet;
    private int idx = 0;
    private int tflags = 0;
    private int flags = 0;
    private double min = 0.0;
    private double max = 0.0;
    private double offset = 0.0;
    double minVal = 0.0;
    double maxVal = 0.0;

    public TCPlanet(SwissEph sw, int planet, int flags, double offset) {
        this.tflags = flags;
        int vFlags = 2064391;
        if ((flags & ~vFlags) != 0) {
            throw new IllegalArgumentException("Invalid flag(s): " + (flags & ~vFlags));
        }
        int type = flags & 0xE0000;
        if (type != 131072 && type != 262144 && type != 524288) {
            throw new IllegalArgumentException("Invalid flag combination '" + flags + "': specify at least exactly one of SEFLG_TRANSIT_LONGITUDE (" + 131072 + "), SEFLG_TRANSIT_LATITUDE (" + 262144 + "), SEFLG_TRANSIT_DISTANCE (" + 524288 + ").");
        }
        if (planet < 0 || planet > 20 || planet == 14) {
            throw new IllegalArgumentException("Unsupported planet: " + sw.swe_get_planet_name(planet));
        }
        this.planet = planet;
        this.sw = sw;
        if (this.sw == null) {
            this.sw = new SwissEph();
        }
        if ((flags & 0x40000) != 0) {
            this.idx = 1;
        } else if ((flags & 0x80000) != 0) {
            this.idx = 2;
        }
        if ((flags & 0x100000) != 0) {
            this.idx += 3;
            flags |= 0x100;
        }
        this.flags = flags &= 0xFFE1FFFF;
        this.rollover = this.idx == 0;
        this.offset = this.checkOffset(offset);
        this.max = this.getSpeed(false);
        this.min = this.getSpeed(true);
    }

    @Override
    public boolean getRollover() {
        return this.rollover;
    }

    @Override
    public void setOffset(double value) {
        this.offset = this.checkOffset(value);
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    protected double calc(double jdET) {
        double[] xx = new double[6];
        StringBuffer serr = new StringBuffer();
        int ret = this.sw.swe_calc(jdET, this.planet, this.flags, xx, serr);
        if (ret < 0) {
            throw new SwissephException(jdET, 0, "Calculation failed with return code " + ret + ":\n" + serr.toString());
        }
        return xx[this.idx];
    }

    @Override
    protected double getMaxSpeed() {
        return this.max;
    }

    @Override
    protected double getMinSpeed() {
        return this.min;
    }

    @Override
    protected double getTimePrecision(double degPrec) {
        double maxTimePerDeg = Math.max(Math.abs(this.min), Math.abs(this.max));
        if (maxTimePerDeg != 0.0) {
            return degPrec / maxTimePerDeg;
        }
        return 1.0E-9;
    }

    @Override
    protected double getDegreePrecision(double jd) {
        double degPrec = 0.005;
        if (this.idx > 2) {
            degPrec = 0.002;
        } else if (this.planet >= 0 && this.planet <= 5) {
            if (jd < 1980.0 || jd > 2099.0) {
                degPrec = 0.08;
            }
        } else if (jd >= 1900.0 && jd < 1980.0) {
            degPrec = 0.08;
        } else if (jd < 1900.0 || jd > 2099.0) {
            degPrec = 1.0;
        }
        degPrec /= 3600.0;
        degPrec *= 0.5;
        switch (this.idx) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: 
            case 5: {
                degPrec *= this.sw.ext.maxBaryDist[this.planet];
            }
        }
        return degPrec;
    }

    private double checkOffset(double val) {
        if (this.rollover) {
            while (val < 0.0) {
                val += 360.0;
            }
            val %= 360.0;
            this.minVal = 0.0;
            this.maxVal = 360.0;
        } else if (this.idx == 1) {
            while (val < -90.0) {
                val += 180.0;
            }
            while (val > 90.0) {
                val -= 180.0;
            }
            this.minVal = -90.0;
            this.maxVal = 90.0;
        }
        return val;
    }

    private double getSpeed(boolean min) {
        boolean topo;
        boolean lat = (this.tflags & 0x40000) != 0;
        boolean dist = (this.tflags & 0x80000) != 0;
        boolean lon = !lat && !dist;
        boolean speed = (this.tflags & 0x100000) != 0;
        boolean bl = topo = (this.tflags & 0x8000) != 0;
        if (topo) {
            if (!this.sw.swed.geopos_is_set) {
                throw new IllegalArgumentException("Geographic position is not set for requested topocentric calculations.");
            }
            if (this.sw.swed.topd.geoalt > 50000.0) {
                throw new IllegalArgumentException("Topocentric transit calculations are restricted to a maximum altitude of 50km so far.");
            }
            if (this.sw.swed.topd.geoalt < -1.2E7) {
                throw new IllegalArgumentException("Topocentric transit calculations are restricted to a minimum altitude of -12000km so far.");
            }
            if (speed) {
                if (lat) {
                    return min ? SwephData.minTopoLatAccel[this.planet] : SwephData.maxTopoLatAccel[this.planet];
                }
                if (dist) {
                    return min ? SwephData.minTopoDistAccel[this.planet] : SwephData.maxTopoDistAccel[this.planet];
                }
                return min ? SwephData.minTopoLonAccel[this.planet] : SwephData.maxTopoLonAccel[this.planet];
            }
            if (lat) {
                return min ? SwephData.minTopoLatSpeed[this.planet] : SwephData.maxTopoLatSpeed[this.planet];
            }
            if (dist) {
                return min ? SwephData.minTopoDistSpeed[this.planet] : SwephData.maxTopoDistSpeed[this.planet];
            }
            return min ? SwephData.minTopoLonSpeed[this.planet] : SwephData.maxTopoLonSpeed[this.planet];
        }
        if (speed) {
            if (lat) {
                return min ? SwephData.minLatAccel[this.planet] : SwephData.maxLatAccel[this.planet];
            }
            if (dist) {
                return min ? SwephData.minDistAccel[this.planet] : SwephData.maxDistAccel[this.planet];
            }
            return min ? SwephData.minLonAccel[this.planet] : SwephData.maxLonAccel[this.planet];
        }
        if (lat) {
            return min ? SwephData.minLatSpeed[this.planet] : SwephData.maxLatSpeed[this.planet];
        }
        if (dist) {
            return min ? SwephData.minDistSpeed[this.planet] : SwephData.maxDistSpeed[this.planet];
        }
        return min ? SwephData.minLonSpeed[this.planet] : SwephData.maxLonSpeed[this.planet];
    }
}

