/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.IOException;
import swisseph.DblObj;
import swisseph.FilePtr;
import swisseph.IntObj;
import swisseph.PlanData;
import swisseph.SweDate;
import swisseph.Swemmoon;
import swisseph.SwissData;
import swisseph.SwissEph;
import swisseph.SwissLib;

class SwephMosh {
    SwissLib sl = null;
    SwissEph sw = null;
    SwissData swed = null;
    Swemmoon sm = null;
    SweDate sd = null;
    private static final double TIMESCALE = 3652500.0;
    private static final int FICT_GEO = 1;
    private static final int[] pnoint2msh = new int[]{2, 2, 0, 1, 3, 4, 5, 6, 7, 8};
    private static final double[] freqs = new double[]{5.38101628688982E10, 2.10664136433548E10, 1.29597742283429E10, 6.8905077493988E9, 1.0925660377991E9, 4.399609855372E8, 1.542481193933E8, 7.86550320744E7, 5.22722451795E7};
    private static final double[] phases = new double[]{908103.259872, 655127.28306, 361679.244588, 1279558.798488, 123665.46746400002, 180278.79948000002, 1130598.0183960001, 1095655.195728, 860492.1546};
    double[][] ss = new double[9][24];
    double[][] cc = new double[9][24];
    static final String[] plan_fict_nam = new String[]{"Cupido", "Hades", "Zeus", "Kronos", "Apollon", "Admetos", "Vulkanus", "Poseidon", "Isis-Transpluto", "Nibiru", "Harrington", "Leverrier", "Adams", "Lowell", "Pickering"};
    private static final double[][] plan_oscu_elem = new double[][]{{2415020.0, 2415020.0, 163.7409, 40.99837, 0.0046, 171.4333, 129.8325, 1.0833}, {2415020.0, 2415020.0, 27.6496, 50.66744, 0.00245, 148.1796, 161.3339, 1.05}, {2415020.0, 2415020.0, 165.1232, 59.21436, 0.0012, 299.044, 0.0, 0.0}, {2415020.0, 2415020.0, 169.0193, 64.8196, 0.00305, 208.8801, 0.0, 0.0}, {2415020.0, 2415020.0, 138.0533, 70.29949, 0.0, 0.0, 0.0, 0.0}, {2415020.0, 2415020.0, 351.335, 73.62765, 0.0, 0.0, 0.0, 0.0}, {2415020.0, 2415020.0, 55.8983, 77.25568, 0.0, 0.0, 0.0, 0.0}, {2415020.0, 2415020.0, 165.5163, 83.66907, 0.0, 0.0, 0.0, 0.0}, {2368547.66, 2431456.5, 0.0, 77.775, 0.3, 0.7, 0.0, 0.0}, {1856113.380954, 1856113.380954, 0.0, 234.8921, 0.981092, 103.966, -44.567, 158.708}, {2374696.5, 2451545.0, 0.0, 101.2, 0.411, 208.5, 275.4, 32.4}, {2395662.5, 2395662.5, 34.05, 36.15, 0.10761, 284.75, 0.0, 0.0}, {2395662.5, 2395662.5, 24.28, 37.25, 0.12062, 299.11, 0.0, 0.0}, {2425977.5, 2425977.5, 281.0, 43.0, 0.202, 204.9, 0.0, 0.0}, {2425977.5, 2425977.5, 48.95, 55.1, 0.31, 280.1, 100.0, 15.0}};

    SwephMosh(SwissLib sl, SwissEph sw, SwissData swed) {
        this.sl = sl;
        this.sw = sw;
        this.swed = swed;
        this.sm = new Swemmoon();
        if (this.sl == null) {
            this.sl = new SwissLib();
        }
        if (this.sw == null) {
            this.sw = new SwissEph();
        }
        if (this.swed == null) {
            this.swed = new SwissData();
        }
    }

    String swi_get_fict_name(int ipl, String snam) {
        StringBuffer sbnam;
        if (snam == null) {
            snam = "";
        }
        if (this.read_elements_file(ipl, 0.0, null, null, null, null, null, null, null, null, sbnam = new StringBuffer(snam), null, null) == -1) {
            return "name not found";
        }
        return sbnam.toString();
    }

    int swi_osc_el_plan(double tjd, double[] xp, int ipl, int ipli, double[] xearth, double[] xsun, StringBuffer serr) {
        double M;
        double[] pqr = new double[9];
        double[] x = new double[6];
        DblObj tjd0 = new DblObj();
        DblObj tequ = new DblObj();
        DblObj mano = new DblObj();
        DblObj sema = new DblObj();
        DblObj ecce = new DblObj();
        DblObj parg = new DblObj();
        DblObj node = new DblObj();
        DblObj incl = new DblObj();
        PlanData pedp = this.swed.pldat[0];
        PlanData pdp = this.swed.pldat[ipli];
        IntObj fict_ifl = new IntObj();
        fict_ifl.val = 0;
        if (this.read_elements_file(ipl, tjd, tjd0, tequ, mano, sema, ecce, parg, node, incl, null, fict_ifl, serr) == -1) {
            return -1;
        }
        double dmot = 0.017202098949975136 / sema.val / Math.sqrt(sema.val);
        if ((fict_ifl.val & 1) != 0) {
            dmot /= Math.sqrt(332946.0);
        }
        double cosnode = Math.cos(node.val);
        double sinnode = Math.sin(node.val);
        double cosincl = Math.cos(incl.val);
        double sinincl = Math.sin(incl.val);
        double cosparg = Math.cos(parg.val);
        double sinparg = Math.sin(parg.val);
        pqr[0] = cosparg * cosnode - sinparg * cosincl * sinnode;
        pqr[1] = -sinparg * cosnode - cosparg * cosincl * sinnode;
        pqr[2] = sinincl * sinnode;
        pqr[3] = cosparg * sinnode + sinparg * cosincl * cosnode;
        pqr[4] = -sinparg * sinnode + cosparg * cosincl * cosnode;
        pqr[5] = -sinincl * cosnode;
        pqr[6] = sinparg * sinincl;
        pqr[7] = cosparg * sinincl;
        pqr[8] = cosincl;
        double E = M = this.sl.swi_mod2PI(mano.val + (tjd - tjd0.val) * dmot);
        if (ecce.val > 0.975) {
            double Msgn;
            double M_180_or_0;
            double M2 = M * 57.2957795130823;
            if (M2 > 150.0 && M2 < 210.0) {
                M2 -= 180.0;
                M_180_or_0 = 180.0;
            } else {
                M_180_or_0 = 0.0;
            }
            if (M2 > 330.0) {
                M2 -= 360.0;
            }
            if (M2 < 0.0) {
                M2 = -M2;
                Msgn = -1.0;
            } else {
                Msgn = 1.0;
            }
            if (M2 < 30.0) {
                double alpha = (1.0 - ecce.val) / (4.0 * ecce.val + 0.5);
                double beta = (M2 *= 0.0174532925199433) / (8.0 * ecce.val + 1.0);
                double zeta = Math.pow(beta + Math.sqrt(beta * beta + alpha * alpha), 0.0);
                double sigma = zeta - alpha / 2.0;
                sigma -= 0.078 * sigma * sigma * sigma * sigma * sigma / (1.0 + ecce.val);
                E = Msgn * (M2 + ecce.val * (3.0 * sigma - 4.0 * sigma * sigma * sigma)) + M_180_or_0;
            }
        }
        E = this.sl.swi_kepler(E, M, ecce.val);
        double K = (fict_ifl.val & 1) != 0 ? 2.98122353216E-5 / Math.sqrt(sema.val) : 0.01720209895 / Math.sqrt(sema.val);
        double cose = Math.cos(E);
        double sine = Math.sin(E);
        double fac = Math.sqrt((1.0 - ecce.val) * (1.0 + ecce.val));
        double rho = 1.0 - ecce.val * cose;
        x[0] = sema.val * (cose - ecce.val);
        x[1] = sema.val * fac * sine;
        x[3] = -K * sine / rho;
        x[4] = K * fac * cose / rho;
        xp[0] = pqr[0] * x[0] + pqr[1] * x[1];
        xp[1] = pqr[3] * x[0] + pqr[4] * x[1];
        xp[2] = pqr[6] * x[0] + pqr[7] * x[1];
        xp[3] = pqr[0] * x[3] + pqr[1] * x[4];
        xp[4] = pqr[3] * x[3] + pqr[4] * x[4];
        xp[5] = pqr[6] * x[3] + pqr[7] * x[4];
        double eps = this.sl.swi_epsiln(tequ.val);
        this.sl.swi_coortrf(xp, xp, -eps);
        this.sl.swi_coortrf(xp, 3, xp, 3, -eps);
        if (tequ.val != 2451545.0) {
            this.sl.swi_precess(xp, tequ.val, 1);
            this.sl.swi_precess(xp, 3, tequ.val, 1);
        }
        if ((fict_ifl.val & 1) != 0) {
            for (int i = 0; i <= 5; ++i) {
                int n = i;
                xp[n] = xp[n] + xearth[i];
            }
        } else {
            for (int i = 0; i <= 5; ++i) {
                int n = i;
                xp[n] = xp[n] + xsun[i];
            }
        }
        if (pdp.x == xp) {
            pdp.teval = tjd;
            pdp.iephe = pedp.iephe;
        }
        return 0;
    }

    private int read_elements_file(int ipl, double tjd, DblObj tjd0, DblObj tequ, DblObj mano, DblObj sema, DblObj ecce, DblObj parg, DblObj node, DblObj incl, StringBuffer pname, IntObj fict_ifl, StringBuffer serr) {
        FilePtr fp = null;
        int spIdx = 0;
        String[] cpos = new String[20];
        String serri = "";
        boolean elem_found = false;
        double tt = 0.0;
        fp = this.sw.swi_fopen(-1, "seorbel.txt", this.swed.ephepath, serr);
        if (fp == null) {
            if (ipl >= 15) {
                if (serr != null) {
                    serr.append("error no elements for fictitious body no ").append(ipl);
                }
                return -1;
            }
            if (tjd0 != null) {
                tjd0.val = plan_oscu_elem[ipl][0];
            }
            if (tequ != null) {
                tequ.val = plan_oscu_elem[ipl][1];
            }
            if (mano != null) {
                mano.val = plan_oscu_elem[ipl][2] * 0.0174532925199433;
            }
            if (sema != null) {
                sema.val = plan_oscu_elem[ipl][3];
            }
            if (ecce != null) {
                ecce.val = plan_oscu_elem[ipl][4];
            }
            if (parg != null) {
                parg.val = plan_oscu_elem[ipl][5] * 0.0174532925199433;
            }
            if (node != null) {
                node.val = plan_oscu_elem[ipl][6] * 0.0174532925199433;
            }
            if (incl != null) {
                incl.val = plan_oscu_elem[ipl][7] * 0.0174532925199433;
            }
            if (pname != null) {
                pname.setLength(0);
                pname.append(plan_fict_nam[ipl]);
            }
            return 0;
        }
        int iline = 0;
        int iplan = -1;
        try {
            String s;
            while ((s = fp.readLine()) != null) {
                int retc;
                String sp = s = s.trim();
                spIdx = 0;
                char ch = s.charAt(spIdx);
                if (ch == '#' || ch == '\r' || ch == '\n' || ch == '\u0000') continue;
                sp = null;
                spIdx = s.indexOf(35);
                if (spIdx >= 0) {
                    s = s.substring(0, s.indexOf(35));
                    sp = "";
                }
                int ncpos = this.sl.swi_cutstr(s, ",", cpos, 20);
                serri = "error in file seorbel.txt, line " + iline + ":";
                if (ncpos < 9) {
                    if (serr != null) {
                        serr.setLength(0);
                        serr.append(serri).append(" nine elements required");
                    }
                    return -1;
                }
                if (++iplan != ipl) continue;
                elem_found = true;
                if (tjd0 != null) {
                    sp = cpos[0];
                    String string = sp = sp.length() <= 5 ? sp.toLowerCase() : sp.substring(0, 5).toLowerCase() + sp.substring(5);
                    if (sp.startsWith("j2000")) {
                        tjd0.val = 2451545.0;
                    } else if (sp.startsWith("b1950")) {
                        tjd0.val = 2433282.42345905;
                    } else if (sp.startsWith("j1900")) {
                        tjd0.val = 2415020.0;
                    } else {
                        if (sp.charAt(0) == 'j' || sp.charAt(0) == 'b') {
                            if (serr != null) {
                                serr.setLength(0);
                                serr.append(serri).append(" invalid epoch");
                            }
                            fp.close();
                            return -1;
                        }
                        tjd0.val = SwissLib.atof(sp);
                    }
                    tt = tjd - tjd0.val;
                }
                if (tequ != null) {
                    sp = cpos[1];
                    spIdx = 0;
                    while (sp.charAt(spIdx) == ' ' || sp.charAt(spIdx) == '\t') {
                        ++spIdx;
                    }
                    String string = sp = (sp = sp.substring(spIdx)).length() < 5 ? sp.toLowerCase() : sp.substring(0, 5).toLowerCase() + sp.substring(5);
                    if (sp.startsWith("j2000")) {
                        tequ.val = 2451545.0;
                    } else if (sp.startsWith("b1950")) {
                        tequ.val = 2433282.42345905;
                    } else if (sp.startsWith("j1900")) {
                        tequ.val = 2415020.0;
                    } else if (sp.startsWith("jdate")) {
                        tequ.val = tjd;
                    } else {
                        if (sp.charAt(0) == 'j' || sp.charAt(0) == 'b') {
                            if (serr != null) {
                                serr.setLength(0);
                                serr.append(serri).append(" invalid equinox");
                            }
                            fp.close();
                            return -1;
                        }
                        tequ.val = SwissLib.atof(sp);
                    }
                }
                if (mano != null) {
                    retc = this.check_t_terms(tt, cpos[2], mano);
                    mano.val = this.sl.swe_degnorm(mano.val);
                    if (retc == -1) {
                        if (serr != null) {
                            serr.append(serri).append(" mean anomaly value invalid");
                        }
                        fp.close();
                        return -1;
                    }
                    if (retc == 1) {
                        tjd0.val = tjd;
                    }
                    mano.val *= 0.0174532925199433;
                }
                if (sema != null) {
                    retc = this.check_t_terms(tt, cpos[3], sema);
                    if (sema.val <= 0.0 || retc == -1) {
                        if (serr != null) {
                            serr.append(serri).append(" semi-axis value invalid");
                        }
                        fp.close();
                        return -1;
                    }
                }
                if (ecce != null) {
                    retc = this.check_t_terms(tt, cpos[4], ecce);
                    if (ecce.val >= 1.0 || ecce.val < 0.0 || retc == -1) {
                        if (serr != null) {
                            serr.setLength(0);
                            serr.append(serri).append(" eccentricity invalid (no parabolic or hyperbolic or bits allowed)");
                        }
                        fp.close();
                        return -1;
                    }
                }
                if (parg != null) {
                    retc = this.check_t_terms(tt, cpos[5], parg);
                    parg.val = this.sl.swe_degnorm(parg.val);
                    if (retc == -1) {
                        if (serr != null) {
                            serr.setLength(0);
                            serr.append(serri).append(" perihelion argument value invalid");
                        }
                        fp.close();
                        return -1;
                    }
                    parg.val *= 0.0174532925199433;
                }
                if (node != null) {
                    retc = this.check_t_terms(tt, cpos[6], node);
                    node.val = this.sl.swe_degnorm(node.val);
                    if (retc == -1) {
                        if (serr != null) {
                            serr.setLength(0);
                            serr.append(serri).append(" node value invalid");
                        }
                        fp.close();
                        return -1;
                    }
                    node.val *= 0.0174532925199433;
                }
                if (incl != null) {
                    retc = this.check_t_terms(tt, cpos[7], incl);
                    incl.val = this.sl.swe_degnorm(incl.val);
                    if (retc == -1) {
                        if (serr != null) {
                            serr.setLength(0);
                            serr.append(serri).append(" inclination value invalid");
                        }
                        fp.close();
                        return -1;
                    }
                    incl.val *= 0.0174532925199433;
                }
                if (pname != null) {
                    sp = cpos[8];
                    spIdx = 0;
                    while (sp.charAt(spIdx) == ' ' || sp.charAt(spIdx) == '\t') {
                        ++spIdx;
                    }
                    sp = sp.substring(spIdx);
                    sp = sp.trim();
                    pname.setLength(0);
                    pname.append(sp);
                }
                if (fict_ifl == null || ncpos <= 9) break;
                sp = sp.substring(0, Math.min(sp.length(), spIdx + 9)) + sp.substring(Math.min(sp.length(), spIdx + 9)).toLowerCase();
                if (cpos[9].indexOf("geo") < 0) break;
                fict_ifl.val |= 1;
                break;
            }
            if (!elem_found) {
                if (serr != null) {
                    serr.append(serri).append(" elements for planet ").append(ipl).append(" not found");
                }
                fp.close();
                return -1;
            }
            fp.close();
            return 0;
        }
        catch (IOException e) {
            if (fp != null) {
                try {
                    fp.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return -1;
        }
    }

    private int check_t_terms(double t, String sinp, DblObj doutp) {
        double[] tt;
        int isgn = 1;
        int retc = 0;
        tt = new double[]{t / 36525.0, tt[0], tt[1] * tt[1], tt[2] * tt[1], tt[3] * tt[1]};
        if (sinp.indexOf(43) + sinp.indexOf(45) > -2) {
            retc = 1;
        }
        int spidx = 0;
        doutp.val = 0.0;
        double fac = 1.0;
        int z = 0;
        while (true) {
            if (spidx < sinp.length() && (sinp.charAt(spidx) == ' ' || sinp.charAt(spidx) == '\t')) {
                ++spidx;
                continue;
            }
            if (spidx == sinp.length() || sinp.charAt(spidx) == '+' || sinp.charAt(spidx) == '-') {
                if (z > 0) {
                    doutp.val += fac;
                }
                isgn = 1;
                if (spidx != sinp.length() && sinp.charAt(spidx) == '-') {
                    isgn = -1;
                }
                fac = 1 * isgn;
                if (spidx == sinp.length()) {
                    return retc;
                }
                ++spidx;
            } else {
                while (spidx < sinp.length() && (sinp.charAt(spidx) == '*' || sinp.charAt(spidx) == ' ' || sinp.charAt(spidx) == '\t')) {
                    ++spidx;
                }
                if (spidx < sinp.length() && (sinp.charAt(spidx) == 't' || sinp.charAt(spidx) == 'T')) {
                    if (++spidx < sinp.length() && (sinp.charAt(spidx) == '+' || sinp.charAt(spidx) == '-')) {
                        fac *= tt[0];
                    } else {
                        int i = SwissLib.atoi(sinp.substring(Math.min(sinp.length(), spidx)));
                        if (i <= 4 && i >= 0) {
                            fac *= tt[i];
                        }
                    }
                } else {
                    double db = SwissLib.atof(sinp.substring(spidx));
                    if (db != 0.0 || sinp.charAt(spidx) == '0') {
                        fac *= db;
                    }
                }
                while (spidx < sinp.length() && (Character.isDigit(sinp.charAt(spidx)) || sinp.charAt(spidx) == '.')) {
                    ++spidx;
                }
            }
            ++z;
        }
    }
}

