/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import swisseph.Houses;
import swisseph.SidData;
import swisseph.SweDate;
import swisseph.SwissData;
import swisseph.SwissEph;
import swisseph.SwissLib;

class SweHouse {
    static final double MILLIARCSEC = 2.7777777777777776E-7;
    SwissLib sl = null;
    SwissEph sw = null;
    SwissData swed = null;
    SweDate sd = null;
    static final double VERY_SMALL = 1.0E-10;

    SweHouse() {
        this.sl = new SwissLib();
        this.sw = new SwissEph();
        this.swed = new SwissData();
    }

    SweHouse(SwissLib sl, SwissEph sw, SwissData swed) {
        this.sl = sl;
        this.sw = sw;
        this.swed = swed;
        if (this.sl == null) {
            this.sl = new SwissLib();
        }
        if (this.sw == null) {
            this.sw = new SwissEph();
        }
        if (this.swed == null) {
            this.swed = new SwissData();
        }
    }

    private double sind(double x) {
        return Math.sin(x * 0.0174532925199433);
    }

    private double cosd(double x) {
        return Math.cos(x * 0.0174532925199433);
    }

    private double tand(double x) {
        return Math.tan(x * 0.0174532925199433);
    }

    private double asind(double x) {
        return Math.asin(x) * 57.2957795130823;
    }

    private double acosd(double x) {
        return Math.acos(x) * 57.2957795130823;
    }

    private double atand(double x) {
        return Math.atan(x) * 57.2957795130823;
    }

    private double atan2d(double y, double x) {
        return Math.atan2(y, x) * 57.2957795130823;
    }

    int swe_houses(double tjd_ut, int iflag, double geolat, double geolon, int hsys, double[] cusp, double[] ascmc) {
        return this.swe_houses(tjd_ut, iflag, geolat, geolon, hsys, cusp, ascmc, 0);
    }

    int swe_houses(double tjd_ut, int iflag, double geolat, double geolon, int hsys, double[] cusp, double[] ascmc, int aOffs) {
        int retc = 0;
        double[] nutlo = new double[2];
        if (this.sd == null) {
            this.sd = new SweDate(tjd_ut);
        }
        double tjde = tjd_ut + SweDate.getDeltaT(tjd_ut);
        SidData sip = this.swed.sidd;
        int ito = Character.toUpperCase((char)hsys) == 'G' ? 36 : 12;
        if ((iflag & 0x10000) != 0 && !this.swed.ayana_is_set) {
            this.sw.swe_set_sid_mode(0, 0.0, 0.0);
        }
        double eps_mean = this.sl.swi_epsiln(tjde) * 57.2957795130823;
        this.sl.swi_nutation(tjde, nutlo);
        int i = 0;
        while (i < 2) {
            int n = i++;
            nutlo[n] = nutlo[n] * 57.2957795130823;
        }
        double armc = this.sl.swe_degnorm(this.sl.swe_sidtime0(tjd_ut, eps_mean + nutlo[1], nutlo[0]) * 15.0 + geolon);
        retc = (iflag & 0x10000) != 0 ? ((sip.sid_mode & 0x100) != 0 ? this.sidereal_houses_ecl_t0(tjde, armc, eps_mean + nutlo[1], nutlo, geolat, hsys, cusp, ascmc, aOffs) : ((sip.sid_mode & 0x200) != 0 ? this.sidereal_houses_ssypl(tjde, armc, eps_mean + nutlo[1], nutlo, geolat, hsys, cusp, ascmc, aOffs) : this.sidereal_houses_trad(tjde, armc, eps_mean + nutlo[1], nutlo[0], geolat, hsys, cusp, ascmc, aOffs))) : this.swe_houses_armc(armc, geolat, eps_mean + nutlo[1], hsys, cusp, ascmc, aOffs);
        if ((iflag & 0x2000) != 0) {
            i = 1;
            while (i <= ito) {
                int n = i++;
                cusp[n] = cusp[n] * 0.0174532925199433;
            }
            for (i = 0; i < 8; ++i) {
                int n = i + aOffs;
                ascmc[n] = ascmc[n] * 0.0174532925199433;
            }
        }
        return retc;
    }

    private int sidereal_houses_ecl_t0(double tjde, double armc, double eps, double[] nutlo, double lat, int hsys, double[] cusp, double[] ascmc, int aOffs) {
        int i;
        int retc = 0;
        double[] x = new double[6];
        double[] xvpx = new double[6];
        double[] x2 = new double[6];
        double[] xnorm = new double[6];
        SidData sip = this.swed.sidd;
        int ito = Character.toUpperCase((char)hsys) == 'G' ? 36 : 12;
        double epst0 = this.sl.swi_epsiln(sip.t0);
        x[4] = 1.0;
        x[0] = 1.0;
        x[5] = 0.0;
        x[3] = 0.0;
        x[2] = 0.0;
        x[1] = 0.0;
        this.sl.swi_coortrf(x, x, -epst0);
        this.sl.swi_coortrf(x, 3, x, 3, -epst0);
        this.sl.swi_precess(x, sip.t0, 1);
        this.sl.swi_precess(x, tjde, -1);
        this.sl.swi_precess(x, 3, sip.t0, 1);
        this.sl.swi_precess(x, 3, tjde, -1);
        this.sl.swi_coortrf(x, x, (eps - nutlo[1]) * 0.0174532925199433);
        this.sl.swi_coortrf(x, 3, x, 3, (eps - nutlo[1]) * 0.0174532925199433);
        this.sl.swi_cartpol_sp(x, 0, x, 0);
        x[0] = x[0] + nutlo[0] * 0.0174532925199433;
        this.sl.swi_polcart_sp(x, x);
        this.sl.swi_coortrf(x, x, -eps * 0.0174532925199433);
        this.sl.swi_coortrf(x, 3, x, 3, -eps * 0.0174532925199433);
        this.sl.swi_cross_prod(x, 0, x, 3, xnorm, 0);
        double rxy = xnorm[0] * xnorm[0] + xnorm[1] * xnorm[1];
        double c2 = rxy + xnorm[2] * xnorm[2];
        double rxyz = Math.sqrt(c2);
        rxy = Math.sqrt(rxy);
        double epsx = Math.asin(rxy / rxyz) * 57.2957795130823;
        if (Math.abs(x[5]) < 1.0E-15) {
            x[5] = 1.0E-15;
        }
        double fac = x[2] / x[5];
        double sgn = x[5] / Math.abs(x[5]);
        for (int j = 0; j <= 2; ++j) {
            xvpx[j] = (x[j] - fac * x[j + 3]) * sgn;
        }
        this.sl.swi_cartpol(xvpx, x2);
        double dvpx = x2[0] * 57.2957795130823;
        double armcx = this.sl.swe_degnorm(armc - dvpx);
        retc = this.swe_houses_armc(armcx, lat, epsx, hsys, cusp, ascmc, aOffs);
        double dvpxe = Math.acos(this.sl.swi_dot_prod_unit(x, xvpx)) * 57.2957795130823;
        if (tjde < sip.t0) {
            dvpxe = -dvpxe;
        }
        for (i = 1; i <= ito; ++i) {
            cusp[i] = this.sl.swe_degnorm(cusp[i] - dvpxe - sip.ayan_t0);
        }
        for (i = 0; i <= 8; ++i) {
            ascmc[aOffs + i] = this.sl.swe_degnorm(ascmc[aOffs + i] - dvpxe - sip.ayan_t0);
        }
        return retc;
    }

    private int sidereal_houses_ssypl(double tjde, double armc, double eps, double[] nutlo, double lat, int hsys, double[] cusp, double[] ascmc, int aOffs) {
        int i;
        int retc = 0;
        double[] x = new double[6];
        double[] x0 = new double[6];
        double[] xvpx = new double[6];
        double[] x2 = new double[6];
        double[] xnorm = new double[6];
        SidData sip = this.swed.sidd;
        int ito = Character.toUpperCase((char)hsys) == 'G' ? 36 : 12;
        double epst0 = this.sl.swi_epsiln(sip.t0);
        double eps2000 = this.sl.swi_epsiln(2451545.0);
        x[4] = 1.0;
        x[0] = 1.0;
        x[5] = 0.0;
        x[3] = 0.0;
        x[2] = 0.0;
        x[1] = 0.0;
        this.sl.swi_coortrf(x, x, -0.027553530354527005);
        this.sl.swi_coortrf(x, 3, x, 3, -0.027553530354527005);
        this.sl.swi_cartpol_sp(x, 0, x, 0);
        x[0] = x[0] + 1.877670046803984;
        this.sl.swi_polcart_sp(x, x);
        this.sl.swi_coortrf(x, x, -eps2000);
        this.sl.swi_coortrf(x, 3, x, 3, -eps2000);
        this.sl.swi_precess(x, tjde, -1);
        this.sl.swi_precess(x, 3, tjde, -1);
        this.sl.swi_coortrf(x, x, (eps - nutlo[1]) * 0.0174532925199433);
        this.sl.swi_coortrf(x, 3, x, 3, (eps - nutlo[1]) * 0.0174532925199433);
        this.sl.swi_cartpol_sp(x, 0, x, 0);
        x[0] = x[0] + nutlo[0] * 0.0174532925199433;
        this.sl.swi_polcart_sp(x, x);
        this.sl.swi_coortrf(x, x, -eps * 0.0174532925199433);
        this.sl.swi_coortrf(x, 3, x, 3, -eps * 0.0174532925199433);
        this.sl.swi_cross_prod(x, 0, x, 3, xnorm, 0);
        double rxy = xnorm[0] * xnorm[0] + xnorm[1] * xnorm[1];
        double c2 = rxy + xnorm[2] * xnorm[2];
        double rxyz = Math.sqrt(c2);
        rxy = Math.sqrt(rxy);
        double epsx = Math.asin(rxy / rxyz) * 57.2957795130823;
        if (Math.abs(x[5]) < 1.0E-15) {
            x[5] = 1.0E-15;
        }
        double fac = x[2] / x[5];
        double sgn = x[5] / Math.abs(x[5]);
        for (int j = 0; j <= 2; ++j) {
            xvpx[j] = (x[j] - fac * x[j + 3]) * sgn;
        }
        this.sl.swi_cartpol(xvpx, x2);
        double dvpx = x2[0] * 57.2957795130823;
        double armcx = this.sl.swe_degnorm(armc - dvpx);
        retc = this.swe_houses_armc(armcx, lat, epsx, hsys, cusp, ascmc, aOffs);
        double dvpxe = Math.acos(this.sl.swi_dot_prod_unit(x, xvpx)) * 57.2957795130823;
        dvpxe -= 107.58883387999998;
        x0[0] = 1.0;
        x0[2] = 0.0;
        x0[1] = 0.0;
        if (sip.t0 != 2451545.0) {
            this.sl.swi_precess(x0, sip.t0, 1);
        }
        this.sl.swi_coortrf(x0, x0, eps2000);
        this.sl.swi_cartpol(x0, x0);
        x0[0] = x0[0] - 1.877670046803984;
        this.sl.swi_polcart(x0, x0);
        this.sl.swi_coortrf(x0, x0, 0.027553530354527005);
        this.sl.swi_cartpol(x0, x0);
        x0[0] = x0[0] + 1.8777793895872261;
        double x00 = x0[0] * 57.2957795130823;
        for (i = 1; i <= ito; ++i) {
            cusp[i] = this.sl.swe_degnorm(cusp[i] - dvpxe - sip.ayan_t0 - x00);
        }
        for (i = 0; i <= 8; ++i) {
            ascmc[aOffs + i] = this.sl.swe_degnorm(ascmc[aOffs + i] - dvpxe - sip.ayan_t0 - x00);
        }
        return retc;
    }

    private int sidereal_houses_trad(double tjde, double armc, double eps, double nutl, double lat, int hsys, double[] cusp, double[] ascmc, int aOffs) {
        int i;
        int retc = 0;
        int ito = Character.toUpperCase((char)hsys) == 'G' ? 36 : 12;
        retc = this.swe_houses_armc(armc, lat, eps, hsys, cusp, ascmc, aOffs);
        double ay = this.sw.swe_get_ayanamsa(tjde);
        for (i = 1; i <= ito; ++i) {
            cusp[i] = this.sl.swe_degnorm(cusp[i] - ay - nutl);
        }
        for (i = 0; i < 8; ++i) {
            if (i == 2) continue;
            ascmc[aOffs + i] = this.sl.swe_degnorm(ascmc[aOffs + i] - ay - nutl);
        }
        return retc;
    }

    int swe_houses_armc(double armc, double geolat, double eps, int hsys, double[] cusp, double[] ascmc, int aOffs) {
        int i;
        Houses h = new Houses();
        int retc = 0;
        int ito = Character.toUpperCase((char)hsys) == 'G' ? 36 : 12;
        armc = this.sl.swe_degnorm(armc);
        retc = this.CalcH(armc, geolat, eps, (char)hsys, 2, h);
        cusp[0] = 0.0;
        for (i = 1; i <= ito; ++i) {
            cusp[i] = h.cusp[i];
        }
        ascmc[aOffs + 0] = h.ac;
        ascmc[aOffs + 1] = h.mc;
        ascmc[aOffs + 2] = armc;
        ascmc[aOffs + 3] = h.vertex;
        ascmc[aOffs + 4] = h.equasc;
        ascmc[aOffs + 5] = h.coasc1;
        ascmc[aOffs + 6] = h.coasc2;
        ascmc[aOffs + 7] = h.polasc;
        for (i = 8; i < 10; ++i) {
            ascmc[aOffs + i] = 0.0;
        }
        return retc;
    }

    private int CalcH(double th, double fi, double ekl, char hsy, int iteration_count, Houses hsp) {
        double th2;
        double vemc;
        double f;
        double tant;
        int retc = 0;
        double cose = this.cosd(ekl);
        double sine = this.sind(ekl);
        double tane = this.tand(ekl);
        if (Math.abs(Math.abs(fi) - 90.0) < 1.0E-10) {
            fi = fi < 0.0 ? -89.9999999999 : 89.9999999999;
        }
        double tanfi = this.tand(fi);
        if (Math.abs(th - 90.0) > 1.0E-10 && Math.abs(th - 270.0) > 1.0E-10) {
            tant = this.tand(th);
            hsp.mc = this.atand(tant / cose);
            if (th > 90.0 && th <= 270.0) {
                hsp.mc = this.sl.swe_degnorm(hsp.mc + 180.0);
            }
        } else {
            hsp.mc = Math.abs(th - 90.0) <= 1.0E-10 ? 90.0 : 270.0;
        }
        hsp.mc = this.sl.swe_degnorm(hsp.mc);
        hsp.cusp[1] = hsp.ac = this.Asc1(th + 90.0, fi, sine, cose);
        hsp.cusp[10] = hsp.mc;
        hsy = Character.toUpperCase(hsy);
        block0 : switch (hsy) {
            case 'A': 
            case 'E': {
                double acmc = this.sl.swe_difdeg2n(hsp.ac, hsp.mc);
                if (acmc < 0.0) {
                    hsp.cusp[1] = hsp.ac = this.sl.swe_degnorm(hsp.ac + 180.0);
                }
                for (int i = 2; i <= 12; ++i) {
                    hsp.cusp[i] = this.sl.swe_degnorm(hsp.cusp[1] + (double)((i - 1) * 30));
                }
                break;
            }
            case 'C': 
            case 'H': {
                int i;
                double acmc;
                double xh1;
                double xh2;
                if (hsy == 'H') {
                    if (Math.abs(Math.abs(fi = fi > 0.0 ? 90.0 - fi : -90.0 - fi) - 90.0) < 1.0E-10) {
                        fi = fi < 0.0 ? -89.9999999999 : 89.9999999999;
                    }
                    th = this.sl.swe_degnorm(th + 180.0);
                }
                double fh1 = this.asind(this.sind(fi) / 2.0);
                double fh2 = this.asind(Math.sqrt(3.0) / 2.0 * this.sind(fi));
                double cosfi = this.cosd(fi);
                if (Math.abs(cosfi) == 0.0) {
                    if (fi > 0.0) {
                        xh2 = 90.0;
                        xh1 = 90.0;
                    } else {
                        xh2 = 270.0;
                        xh1 = 270.0;
                    }
                } else {
                    xh1 = this.atand(Math.sqrt(3.0) / cosfi);
                    xh2 = this.atand(1.0 / Math.sqrt(3.0) / cosfi);
                }
                hsp.cusp[11] = this.Asc1(th + 90.0 - xh1, fh1, sine, cose);
                hsp.cusp[12] = this.Asc1(th + 90.0 - xh2, fh2, sine, cose);
                if (hsy == 'H') {
                    hsp.cusp[1] = this.Asc1(th + 90.0, fi, sine, cose);
                }
                hsp.cusp[2] = this.Asc1(th + 90.0 + xh2, fh2, sine, cose);
                hsp.cusp[3] = this.Asc1(th + 90.0 + xh1, fh1, sine, cose);
                if (Math.abs(fi) >= 90.0 - ekl && (acmc = this.sl.swe_difdeg2n(hsp.ac, hsp.mc)) < 0.0) {
                    hsp.ac = this.sl.swe_degnorm(hsp.ac + 180.0);
                    hsp.mc = this.sl.swe_degnorm(hsp.mc + 180.0);
                    for (i = 1; i <= 12; ++i) {
                        hsp.cusp[i] = this.sl.swe_degnorm(hsp.cusp[i] + 180.0);
                    }
                }
                if (hsy != 'H') break;
                for (i = 1; i <= 3; ++i) {
                    hsp.cusp[i] = this.sl.swe_degnorm(hsp.cusp[i] + 180.0);
                }
                for (i = 11; i <= 12; ++i) {
                    hsp.cusp[i] = this.sl.swe_degnorm(hsp.cusp[i] + 180.0);
                }
                fi = fi > 0.0 ? 90.0 - fi : -90.0 - fi;
                th = this.sl.swe_degnorm(th + 180.0);
                break;
            }
            case 'K': {
                if (Math.abs(fi) >= 90.0 - ekl) {
                    retc = -1;
                    this.makePorphyry(hsp);
                    break;
                }
                double sina = this.sind(hsp.mc) * sine / this.cosd(fi);
                double cosa = Math.sqrt(1.0 - sina * sina);
                double c = this.atand(tanfi / cosa);
                double ad3 = this.asind(this.sind(c) * sina) / 3.0;
                hsp.cusp[11] = this.Asc1(th + 30.0 - 2.0 * ad3, fi, sine, cose);
                hsp.cusp[12] = this.Asc1(th + 60.0 - ad3, fi, sine, cose);
                hsp.cusp[2] = this.Asc1(th + 120.0 + ad3, fi, sine, cose);
                hsp.cusp[3] = this.Asc1(th + 150.0 + 2.0 * ad3, fi, sine, cose);
                break;
            }
            case 'O': {
                this.makePorphyry(hsp);
                break;
            }
            case 'R': {
                double acmc;
                double fh1 = this.atand(tanfi * 0.5);
                double fh2 = this.atand(tanfi * this.cosd(30.0));
                hsp.cusp[11] = this.Asc1(30.0 + th, fh1, sine, cose);
                hsp.cusp[12] = this.Asc1(60.0 + th, fh2, sine, cose);
                hsp.cusp[2] = this.Asc1(120.0 + th, fh2, sine, cose);
                hsp.cusp[3] = this.Asc1(150.0 + th, fh1, sine, cose);
                if (!(Math.abs(fi) >= 90.0 - ekl) || !((acmc = this.sl.swe_difdeg2n(hsp.ac, hsp.mc)) < 0.0)) break;
                hsp.ac = this.sl.swe_degnorm(hsp.ac + 180.0);
                hsp.mc = this.sl.swe_degnorm(hsp.mc + 180.0);
                for (int i = 1; i <= 12; ++i) {
                    hsp.cusp[i] = this.sl.swe_degnorm(hsp.cusp[i] + 180.0);
                }
                break;
            }
            case 'T': {
                double acmc;
                double fh1 = this.atand(tanfi / 3.0);
                double fh2 = this.atand(tanfi * 2.0 / 3.0);
                hsp.cusp[11] = this.Asc1(30.0 + th, fh1, sine, cose);
                hsp.cusp[12] = this.Asc1(60.0 + th, fh2, sine, cose);
                hsp.cusp[2] = this.Asc1(120.0 + th, fh2, sine, cose);
                hsp.cusp[3] = this.Asc1(150.0 + th, fh1, sine, cose);
                if (!(Math.abs(fi) >= 90.0 - ekl) || !((acmc = this.sl.swe_difdeg2n(hsp.ac, hsp.mc)) < 0.0)) break;
                hsp.ac = this.sl.swe_degnorm(hsp.ac + 180.0);
                hsp.mc = this.sl.swe_degnorm(hsp.mc + 180.0);
                for (int i = 1; i <= 12; ++i) {
                    hsp.cusp[i] = this.sl.swe_degnorm(hsp.cusp[i] + 180.0);
                }
                break;
            }
            case 'V': {
                double acmc = this.sl.swe_difdeg2n(hsp.ac, hsp.mc);
                if (acmc < 0.0) {
                    hsp.cusp[1] = hsp.ac = this.sl.swe_degnorm(hsp.ac + 180.0);
                }
                hsp.cusp[1] = this.sl.swe_degnorm(hsp.ac - 15.0);
                for (int i = 2; i <= 12; ++i) {
                    hsp.cusp[i] = this.sl.swe_degnorm(hsp.cusp[1] + (double)((i - 1) * 30));
                }
                break;
            }
            case 'X': {
                double a2 = th;
                for (int i = 1; i <= 12; ++i) {
                    int j = i + 10;
                    if (j > 12) {
                        j -= 12;
                    }
                    if (Math.abs((a2 = this.sl.swe_degnorm(a2 + 30.0)) - 90.0) > 1.0E-10 && Math.abs(a2 - 270.0) > 1.0E-10) {
                        tant = this.tand(a2);
                        hsp.cusp[j] = this.atand(tant / cose);
                        if (a2 > 90.0 && a2 <= 270.0) {
                            hsp.cusp[j] = this.sl.swe_degnorm(hsp.cusp[j] + 180.0);
                        }
                    } else {
                        hsp.cusp[j] = Math.abs(a2 - 90.0) <= 1.0E-10 ? 90.0 : 270.0;
                    }
                    hsp.cusp[j] = this.sl.swe_degnorm(hsp.cusp[j]);
                }
                break;
            }
            case 'M': {
                double am = th;
                double[] x = new double[3];
                for (int i = 1; i <= 12; ++i) {
                    int j = i + 10;
                    if (j > 12) {
                        j -= 12;
                    }
                    x[0] = am = this.sl.swe_degnorm(am + 30.0);
                    x[1] = 0.0;
                    this.sl.swe_cotrans(x, 0, x, 0, ekl);
                    hsp.cusp[j] = x[0];
                }
                break;
            }
            case 'B': {
                double acmc = this.sl.swe_difdeg2n(hsp.ac, hsp.mc);
                if (acmc < 0.0) {
                    hsp.cusp[1] = hsp.ac = this.sl.swe_degnorm(hsp.ac + 180.0);
                    acmc = this.sl.swe_difdeg2n(hsp.ac, hsp.mc);
                }
                double dek = this.asind(this.sind(hsp.ac) * sine);
                double r = -tanfi * this.tand(dek);
                double sda = Math.acos(r) * 57.2957795130823;
                double sna = 180.0 - sda;
                double sd3 = sda / 3.0;
                double sn3 = sna / 3.0;
                double rectasc = this.sl.swe_degnorm(th + sd3);
                hsp.cusp[11] = this.Asc1(rectasc, 0.0, sine, cose);
                rectasc = this.sl.swe_degnorm(th + 2.0 * sd3);
                hsp.cusp[12] = this.Asc1(rectasc, 0.0, sine, cose);
                rectasc = this.sl.swe_degnorm(th + 180.0 - 2.0 * sn3);
                hsp.cusp[2] = this.Asc1(rectasc, 0.0, sine, cose);
                rectasc = this.sl.swe_degnorm(th + 180.0 - sn3);
                hsp.cusp[3] = this.Asc1(rectasc, 0.0, sine, cose);
                break;
            }
            case 'G': {
                double rectasc;
                double fh1;
                int ih2;
                int ih;
                int i;
                for (i = 1; i <= 36; ++i) {
                    hsp.cusp[i] = 0.0;
                }
                if (Math.abs(fi) >= 90.0 - ekl) {
                    retc = -1;
                    this.makePorphyry(hsp);
                }
                double a = this.asind(this.tand(fi) * tane);
                for (ih = 2; ih <= 9; ++ih) {
                    ih2 = 10 - ih;
                    fh1 = this.atand(this.sind(a * (double)ih2 / 9.0) / tane);
                    rectasc = this.sl.swe_degnorm((double)(10 * ih2) + th);
                    tant = this.tand(this.asind(sine * this.sind(this.Asc1(rectasc, fh1, sine, cose))));
                    if (Math.abs(tant) < 1.0E-10) {
                        hsp.cusp[ih] = rectasc;
                    } else {
                        f = this.atand(this.sind(this.asind(tanfi * tant) * (double)ih2 / 9.0) / tant);
                        hsp.cusp[ih] = this.Asc1(rectasc, f, sine, cose);
                        for (i = 1; i <= iteration_count; ++i) {
                            tant = this.tand(this.asind(sine * this.sind(hsp.cusp[ih])));
                            if (Math.abs(tant) < 1.0E-10) {
                                hsp.cusp[ih] = rectasc;
                                break;
                            }
                            f = this.atand(this.sind(this.asind(tanfi * tant) * (double)ih2 / 9.0) / tant);
                            hsp.cusp[ih] = this.Asc1(rectasc, f, sine, cose);
                        }
                    }
                    hsp.cusp[ih + 18] = this.sl.swe_degnorm(hsp.cusp[ih] + 180.0);
                }
                for (ih = 29; ih <= 36; ++ih) {
                    ih2 = ih - 28;
                    fh1 = this.atand(this.sind(a * (double)ih2 / 9.0) / tane);
                    rectasc = this.sl.swe_degnorm((double)(180 - ih2 * 90 / 9) + th);
                    tant = this.tand(this.asind(sine * this.sind(this.Asc1(rectasc, fh1, sine, cose))));
                    if (Math.abs(tant) < 1.0E-10) {
                        hsp.cusp[ih] = rectasc;
                    } else {
                        f = this.atand(this.sind(this.asind(tanfi * tant) * (double)ih2 / 9.0) / tant);
                        hsp.cusp[ih] = this.Asc1(rectasc, f, sine, cose);
                        for (i = 1; i <= iteration_count; ++i) {
                            tant = this.tand(this.asind(sine * this.sind(hsp.cusp[ih])));
                            if (Math.abs(tant) < 1.0E-10) {
                                hsp.cusp[ih] = rectasc;
                                break;
                            }
                            f = this.atand(this.sind(this.asind(tanfi * tant) * (double)ih2 / 9.0) / tant);
                            hsp.cusp[ih] = this.Asc1(rectasc, f, sine, cose);
                        }
                    }
                    hsp.cusp[ih - 18] = this.sl.swe_degnorm(hsp.cusp[ih] + 180.0);
                }
                hsp.cusp[1] = hsp.ac;
                hsp.cusp[10] = hsp.mc;
                hsp.cusp[19] = this.sl.swe_degnorm(hsp.ac + 180.0);
                hsp.cusp[28] = this.sl.swe_degnorm(hsp.mc + 180.0);
                break;
            }
            default: {
                int i;
                if (hsy != 'P') {
                    System.err.println("swe_houses: make Placidus, unknown key " + hsy);
                }
                if (Math.abs(fi) >= 90.0 - ekl) {
                    retc = -1;
                    this.makePorphyry(hsp);
                    break;
                }
                double a = this.asind(this.tand(fi) * tane);
                double fh1 = this.atand(this.sind(a / 3.0) / tane);
                double fh2 = this.atand(this.sind(a * 2.0 / 3.0) / tane);
                double rectasc = this.sl.swe_degnorm(30.0 + th);
                tant = this.tand(this.asind(sine * this.sind(this.Asc1(rectasc, fh1, sine, cose))));
                if (Math.abs(tant) < 1.0E-10) {
                    hsp.cusp[11] = rectasc;
                } else {
                    f = this.atand(this.sind(this.asind(tanfi * tant) / 3.0) / tant);
                    hsp.cusp[11] = this.Asc1(rectasc, f, sine, cose);
                    for (i = 1; i <= iteration_count; ++i) {
                        tant = this.tand(this.asind(sine * this.sind(hsp.cusp[11])));
                        if (Math.abs(tant) < 1.0E-10) {
                            hsp.cusp[11] = rectasc;
                            break;
                        }
                        f = this.atand(this.sind(this.asind(tanfi * tant) / 3.0) / tant);
                        hsp.cusp[11] = this.Asc1(rectasc, f, sine, cose);
                    }
                }
                rectasc = this.sl.swe_degnorm(60.0 + th);
                tant = this.tand(this.asind(sine * this.sind(this.Asc1(rectasc, fh2, sine, cose))));
                if (Math.abs(tant) < 1.0E-10) {
                    hsp.cusp[12] = rectasc;
                } else {
                    f = this.atand(this.sind(this.asind(tanfi * tant) / 1.5) / tant);
                    hsp.cusp[12] = this.Asc1(rectasc, f, sine, cose);
                    for (i = 1; i <= iteration_count; ++i) {
                        tant = this.tand(this.asind(sine * this.sind(hsp.cusp[12])));
                        if (Math.abs(tant) < 1.0E-10) {
                            hsp.cusp[12] = rectasc;
                            break;
                        }
                        f = this.atand(this.sind(this.asind(tanfi * tant) / 1.5) / tant);
                        hsp.cusp[12] = this.Asc1(rectasc, f, sine, cose);
                    }
                }
                rectasc = this.sl.swe_degnorm(120.0 + th);
                tant = this.tand(this.asind(sine * this.sind(this.Asc1(rectasc, fh2, sine, cose))));
                if (Math.abs(tant) < 1.0E-10) {
                    hsp.cusp[2] = rectasc;
                } else {
                    f = this.atand(this.sind(this.asind(tanfi * tant) / 1.5) / tant);
                    hsp.cusp[2] = this.Asc1(rectasc, f, sine, cose);
                    for (i = 1; i <= iteration_count; ++i) {
                        tant = this.tand(this.asind(sine * this.sind(hsp.cusp[2])));
                        if (Math.abs(tant) < 1.0E-10) {
                            hsp.cusp[2] = rectasc;
                            break;
                        }
                        f = this.atand(this.sind(this.asind(tanfi * tant) / 1.5) / tant);
                        hsp.cusp[2] = this.Asc1(rectasc, f, sine, cose);
                    }
                }
                rectasc = this.sl.swe_degnorm(150.0 + th);
                tant = this.tand(this.asind(sine * this.sind(this.Asc1(rectasc, fh1, sine, cose))));
                if (Math.abs(tant) < 1.0E-10) {
                    hsp.cusp[3] = rectasc;
                    break;
                }
                f = this.atand(this.sind(this.asind(tanfi * tant) / 3.0) / tant);
                hsp.cusp[3] = this.Asc1(rectasc, f, sine, cose);
                for (i = 1; i <= iteration_count; ++i) {
                    tant = this.tand(this.asind(sine * this.sind(hsp.cusp[3])));
                    if (Math.abs(tant) < 1.0E-10) {
                        hsp.cusp[3] = rectasc;
                        break block0;
                    }
                    f = this.atand(this.sind(this.asind(tanfi * tant) / 3.0) / tant);
                    hsp.cusp[3] = this.Asc1(rectasc, f, sine, cose);
                }
            }
        }
        if (hsy != 'G') {
            hsp.cusp[4] = this.sl.swe_degnorm(hsp.cusp[10] + 180.0);
            hsp.cusp[5] = this.sl.swe_degnorm(hsp.cusp[11] + 180.0);
            hsp.cusp[6] = this.sl.swe_degnorm(hsp.cusp[12] + 180.0);
            hsp.cusp[7] = this.sl.swe_degnorm(hsp.cusp[1] + 180.0);
            hsp.cusp[8] = this.sl.swe_degnorm(hsp.cusp[2] + 180.0);
            hsp.cusp[9] = this.sl.swe_degnorm(hsp.cusp[3] + 180.0);
        }
        f = fi >= 0.0 ? 90.0 - fi : -90.0 - fi;
        hsp.vertex = this.Asc1(th - 90.0, f, sine, cose);
        if (Math.abs(fi) <= ekl && (vemc = this.sl.swe_difdeg2n(hsp.vertex, hsp.mc)) > 0.0) {
            hsp.vertex = this.sl.swe_degnorm(hsp.vertex + 180.0);
        }
        if (Math.abs((th2 = this.sl.swe_degnorm(th + 90.0)) - 90.0) > 1.0E-10 && Math.abs(th2 - 270.0) > 1.0E-10) {
            tant = this.tand(th2);
            hsp.equasc = this.atand(tant / cose);
            if (th2 > 90.0 && th2 <= 270.0) {
                hsp.equasc = this.sl.swe_degnorm(hsp.equasc + 180.0);
            }
        } else {
            hsp.equasc = Math.abs(th2 - 90.0) <= 1.0E-10 ? 90.0 : 270.0;
        }
        hsp.equasc = this.sl.swe_degnorm(hsp.equasc);
        hsp.coasc1 = this.sl.swe_degnorm(this.Asc1(th - 90.0, fi, sine, cose) + 180.0);
        hsp.coasc2 = fi >= 0.0 ? this.Asc1(th + 90.0, 90.0 - fi, sine, cose) : this.Asc1(th + 90.0, -90.0 - fi, sine, cose);
        hsp.polasc = this.Asc1(th - 90.0, fi, sine, cose);
        return retc;
    }

    private void makePorphyry(Houses hsp) {
        double acmc = this.sl.swe_difdeg2n(hsp.ac, hsp.mc);
        if (acmc < 0.0) {
            hsp.cusp[1] = hsp.ac = this.sl.swe_degnorm(hsp.ac + 180.0);
            acmc = this.sl.swe_difdeg2n(hsp.ac, hsp.mc);
        }
        hsp.cusp[2] = this.sl.swe_degnorm(hsp.ac + (180.0 - acmc) / 3.0);
        hsp.cusp[3] = this.sl.swe_degnorm(hsp.ac + (180.0 - acmc) / 3.0 * 2.0);
        hsp.cusp[11] = this.sl.swe_degnorm(hsp.mc + acmc / 3.0);
        hsp.cusp[12] = this.sl.swe_degnorm(hsp.mc + acmc / 3.0 * 2.0);
    }

    private double Asc1(double x1, double f, double sine, double cose) {
        int n = (int)((x1 = this.sl.swe_degnorm(x1)) / 90.0 + 1.0);
        double ass = n == 1 ? this.Asc2(x1, f, sine, cose) : (n == 2 ? 180.0 - this.Asc2(180.0 - x1, -f, sine, cose) : (n == 3 ? 180.0 + this.Asc2(x1 - 180.0, -f, sine, cose) : 360.0 - this.Asc2(360.0 - x1, f, sine, cose)));
        if (Math.abs((ass = this.sl.swe_degnorm(ass)) - 90.0) < 1.0E-10) {
            ass = 90.0;
        }
        if (Math.abs(ass - 180.0) < 1.0E-10) {
            ass = 180.0;
        }
        if (Math.abs(ass - 270.0) < 1.0E-10) {
            ass = 270.0;
        }
        if (Math.abs(ass - 360.0) < 1.0E-10) {
            ass = 0.0;
        }
        return ass;
    }

    private double Asc2(double x, double f, double sine, double cose) {
        double sinx;
        double ass = -this.tand(f) * sine + cose * this.cosd(x);
        if (Math.abs(ass) < 1.0E-10) {
            ass = 0.0;
        }
        if (Math.abs(sinx = this.sind(x)) < 1.0E-10) {
            sinx = 0.0;
        }
        ass = sinx == 0.0 ? (ass < 0.0 ? -1.0E-10 : 1.0E-10) : (ass == 0.0 ? (sinx < 0.0 ? -90.0 : 90.0) : this.atand(sinx / ass));
        if (ass < 0.0) {
            ass = 180.0 + ass;
        }
        return ass;
    }

    double swe_house_pos(double armc, double geolat, double eps, int hsys, double[] xpin, StringBuffer serr) {
        double hpos;
        double[] xp = new double[6];
        double[] xeq = new double[6];
        double sine = this.sind(eps);
        double cose = this.cosd(eps);
        boolean is_above_hor = false;
        if (serr != null) {
            serr.setLength(0);
        }
        hsys = Character.toUpperCase((char)hsys);
        xeq[0] = xpin[0];
        xeq[1] = xpin[1];
        xeq[2] = 1.0;
        this.sl.swe_cotrans(xpin, 0, xeq, 0, -eps);
        double ra = xeq[0];
        double de = xeq[1];
        double mdd = this.sl.swe_degnorm(ra - armc);
        double mdn = this.sl.swe_degnorm(mdd + 180.0);
        if (mdd >= 180.0) {
            mdd -= 360.0;
        }
        if (mdn >= 180.0) {
            mdn -= 360.0;
        }
        switch (hsys) {
            case 65: 
            case 69: 
            case 86: {
                double asc = this.Asc1(this.sl.swe_degnorm(armc + 90.0), geolat, sine, cose);
                double demc = this.atand(this.sind(armc) * this.tand(eps));
                if (geolat >= 0.0 && 90.0 - geolat + demc < 0.0) {
                    asc = this.sl.swe_degnorm(asc + 180.0);
                }
                if (geolat < 0.0 && -90.0 - geolat + demc > 0.0) {
                    asc = this.sl.swe_degnorm(asc + 180.0);
                }
                xp[0] = this.sl.swe_degnorm(xpin[0] - asc);
                if (hsys == 86) {
                    xp[0] = this.sl.swe_degnorm(xp[0] + 15.0);
                }
                xp[0] = this.sl.swe_degnorm(xp[0] + 2.7777777777777776E-7);
                hpos = xp[0] / 30.0 + 1.0;
                break;
            }
            case 79: {
                double mc;
                double asc = this.Asc1(this.sl.swe_degnorm(armc + 90.0), geolat, sine, cose);
                double demc = this.atand(this.sind(armc) * this.tand(eps));
                if (Math.abs(armc - 90.0) > 1.0E-10 && Math.abs(armc - 270.0) > 1.0E-10) {
                    double tant = this.tand(armc);
                    mc = this.sl.swe_degnorm(this.atand(tant / cose));
                    if (armc > 90.0 && armc <= 270.0) {
                        mc = this.sl.swe_degnorm(mc + 180.0);
                    }
                } else {
                    mc = Math.abs(armc - 90.0) <= 1.0E-10 ? 90.0 : 270.0;
                }
                if (geolat >= 0.0 && 90.0 - geolat + demc < 0.0) {
                    asc = this.sl.swe_degnorm(asc + 180.0);
                }
                if (geolat < 0.0 && -90.0 - geolat + demc > 0.0) {
                    asc = this.sl.swe_degnorm(asc + 180.0);
                }
                xp[0] = this.sl.swe_degnorm(xpin[0] - asc);
                xp[0] = this.sl.swe_degnorm(xp[0] + 2.7777777777777776E-7);
                if (xp[0] < 180.0) {
                    hpos = 1.0;
                } else {
                    hpos = 7.0;
                    xp[0] = xp[0] - 180.0;
                }
                double acmc = this.sl.swe_difdeg2n(asc, mc);
                if (xp[0] < 180.0 - acmc) {
                    hpos += xp[0] * 3.0 / (180.0 - acmc);
                    break;
                }
                hpos += 3.0 + (xp[0] - 180.0 + acmc) * 3.0 / acmc;
                break;
            }
            case 88: {
                hpos = this.sl.swe_degnorm(mdd - 90.0) / 30.0 + 1.0;
                break;
            }
            case 77: {
                double am = xpin[0];
                if (Math.abs(am - 90.0) > 1.0E-10 && Math.abs(am - 270.0) > 1.0E-10) {
                    double tant = this.tand(am);
                    hpos = this.atand(tant / cose);
                    if (am > 90.0 && am <= 270.0) {
                        hpos = this.sl.swe_degnorm(hpos + 180.0);
                    }
                } else {
                    hpos = Math.abs(am - 90.0) <= 1.0E-10 ? 90.0 : 270.0;
                }
                hpos = this.sl.swe_degnorm(hpos - armc - 90.0);
                hpos = hpos / 30.0 + 1.0;
                break;
            }
            case 75: {
                double demc = this.atand(this.sind(armc) * this.tand(eps));
                if (90.0 - Math.abs(geolat) <= Math.abs(de)) {
                    if (serr != null) {
                        serr.append("no Koch house position, because planet is circumpolar.");
                    }
                    xp[0] = 0.0;
                    hpos = 0.0;
                    break;
                }
                if (90.0 - Math.abs(geolat) <= Math.abs(demc)) {
                    if (serr != null) {
                        serr.append("no Koch house position, because mc is circumpolar.");
                    }
                    xp[0] = 0.0;
                    hpos = 0.0;
                    break;
                }
                double admc = this.asind(this.tand(eps) * this.tand(geolat) * this.sind(armc));
                double adp = this.asind(this.tand(geolat) * this.tand(de));
                double samc = 90.0 + admc;
                xp[0] = mdd >= 0.0 ? this.sl.swe_degnorm(((mdd - adp + admc) / samc - 1.0) * 90.0) : this.sl.swe_degnorm(((mdd + 180.0 + adp + admc) / samc + 1.0) * 90.0);
                xp[0] = this.sl.swe_degnorm(xp[0] + 2.7777777777777776E-7);
                hpos = xp[0] / 30.0 + 1.0;
                break;
            }
            case 67: {
                xeq[0] = this.sl.swe_degnorm(mdd - 90.0);
                this.sl.swe_cotrans(xeq, 0, xp, 0, -geolat);
                xp[0] = this.sl.swe_degnorm(xp[0] + 2.7777777777777776E-7);
                hpos = xp[0] / 30.0 + 1.0;
                break;
            }
            case 72: {
                xeq[0] = this.sl.swe_degnorm(mdd - 90.0);
                this.sl.swe_cotrans(xeq, 0, xp, 0, 90.0 - geolat);
                xp[0] = this.sl.swe_degnorm(xp[0] + 2.7777777777777776E-7);
                hpos = xp[0] / 30.0 + 1.0;
                break;
            }
            case 82: {
                if (Math.abs(mdd) < 1.0E-10) {
                    xp[0] = 270.0;
                } else if (180.0 - Math.abs(mdd) < 1.0E-10) {
                    xp[0] = 90.0;
                } else {
                    if (90.0 - Math.abs(geolat) < 1.0E-10) {
                        geolat = geolat > 0.0 ? 89.9999999999 : -89.9999999999;
                    }
                    if (90.0 - Math.abs(de) < 1.0E-10) {
                        de = de > 0.0 ? 89.9999999999 : -89.9999999999;
                    }
                    double a = this.tand(geolat) * this.tand(de) + this.cosd(mdd);
                    xp[0] = this.sl.swe_degnorm(this.atand(-a / this.sind(mdd)));
                    if (mdd < 0.0) {
                        xp[0] = xp[0] + 180.0;
                    }
                    xp[0] = this.sl.swe_degnorm(xp[0]);
                    xp[0] = this.sl.swe_degnorm(xp[0] + 2.7777777777777776E-7);
                }
                hpos = xp[0] / 30.0 + 1.0;
                break;
            }
            case 84: {
                mdd = this.sl.swe_degnorm(mdd);
                if (de > 89.9999999999) {
                    de = 89.9999999999;
                }
                if (de < -89.9999999999) {
                    de = -89.9999999999;
                }
                double sinad = this.tand(de) * this.tand(geolat);
                double ad = this.asind(sinad);
                double a = sinad + this.cosd(mdd);
                if (a >= 0.0) {
                    is_above_hor = true;
                }
                if (!is_above_hor) {
                    ra = this.sl.swe_degnorm(ra + 180.0);
                    de = -de;
                    mdd = this.sl.swe_degnorm(mdd + 180.0);
                }
                if (mdd > 180.0) {
                    ra = this.sl.swe_degnorm(armc - mdd);
                }
                double tanfi = this.tand(geolat);
                double fh = geolat;
                double ra0 = this.sl.swe_degnorm(armc + 90.0);
                xp[1] = 1.0;
                xeq[1] = de;
                double fac = 2.0;
                while (Math.abs(xp[1]) > 1.0E-6) {
                    if (xp[1] > 0.0) {
                        fh = this.atand(this.tand(fh) - tanfi / fac);
                        ra0 -= 90.0 / fac;
                    } else {
                        fh = this.atand(this.tand(fh) + tanfi / fac);
                        ra0 += 90.0 / fac;
                    }
                    xeq[0] = this.sl.swe_degnorm(ra - ra0);
                    this.sl.swe_cotrans(xeq, 0, xp, 0, 90.0 - fh);
                    fac *= 2.0;
                }
                hpos = this.sl.swe_degnorm(ra0 - armc);
                if (mdd > 180.0) {
                    hpos = this.sl.swe_degnorm(-hpos);
                }
                if (!is_above_hor) {
                    hpos = this.sl.swe_degnorm(hpos + 180.0);
                }
                hpos = this.sl.swe_degnorm(hpos - 90.0) / 30.0 + 1.0;
                break;
            }
            default: {
                if (90.0 - Math.abs(de) <= Math.abs(geolat)) {
                    xp[0] = de * geolat < 0.0 ? this.sl.swe_degnorm(90.0 + mdn / 2.0) : this.sl.swe_degnorm(270.0 + mdd / 2.0);
                    if (serr != null) {
                        serr.append("Otto Ludwig procedure within circumpolar regions.");
                    }
                } else {
                    double sinad = this.tand(de) * this.tand(geolat);
                    double ad = this.asind(sinad);
                    double a = sinad + this.cosd(mdd);
                    if (a >= 0.0) {
                        is_above_hor = true;
                    }
                    double sad = 90.0 + ad;
                    double san = 90.0 - ad;
                    xp[0] = is_above_hor ? (mdd / sad + 3.0) * 90.0 : (mdn / san + 1.0) * 90.0;
                    xp[0] = this.sl.swe_degnorm(xp[0] + 2.7777777777777776E-7);
                }
                if ((char)hsys == 'G') {
                    xp[0] = 360.0 - xp[0];
                    hpos = xp[0] / 10.0 + 1.0;
                    break;
                }
                hpos = xp[0] / 30.0 + 1.0;
            }
        }
        return hpos;
    }
}

