/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import swisseph.FilePtr;
import swisseph.IDate;
import swisseph.SwissEph;
import swisseph.SwissLib;
import swisseph.SwissephException;

public class SweDate {
    private static SwissEph sw = new SwissEph();
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static final boolean SE_JUL_CAL = false;
    public static final boolean SE_GREG_CAL = true;
    public static final boolean SE_KEEP_DATE = true;
    public static final boolean SE_KEEP_JD = false;
    public static final double SE_TIDAL_DE403 = -25.8;
    public static final double SE_TIDAL_DE404 = -25.8;
    public static final double SE_TIDAL_DE405 = -25.7376;
    public static final double SE_TIDAL_DE406 = -25.7376;
    public static final double SE_TIDAL_DE200 = -23.8946;
    public static final double SE_TIDAL_26 = -26.0;
    public static final double SE_TIDAL_DEFAULT = -25.7376;
    public static final double JD0 = 2440587.5;
    private static double tid_acc = -25.7376;
    private static boolean init_dt_done = false;
    private double jd;
    private double jdCO = 2299160.5;
    private boolean calType;
    private int year;
    private int month;
    private int day;
    private double hour;
    private double deltaT;
    private boolean deltatIsValid = false;
    private static final int TABSTART = 1620;
    private static final int TABEND = 2014;
    private static final int TABSIZ = 395;
    private static final int TABSIZ_SPACE = 445;
    private static short[] dt = new short[]{12400, 11900, 11500, 11000, 10600, 10200, 9800, 9500, 9100, 8800, 8500, 8200, 7900, 7700, 7400, 7200, 7000, 6700, 6500, 6300, 6200, 6000, 5800, 5700, 5500, 5400, 5300, 5100, 5000, 4900, 4800, 4700, 4600, 4500, 4400, 4300, 4200, 4100, 4000, 3800, 3700, 3600, 3500, 3400, 3300, 3200, 3100, 3000, 2800, 2700, 2600, 2500, 2400, 2300, 2200, 2100, 2000, 1900, 1800, 1700, 1600, 1500, 1400, 1400, 1300, 1200, 1200, 1100, 1100, 1000, 1000, 1000, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1400, 1400, 1400, 1400, 1400, 1400, 1400, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1600, 1600, 1600, 1600, 1500, 1500, 1400, 1400, 1370, 1340, 1310, 1290, 1270, 1260, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1240, 1230, 1220, 1200, 1170, 1140, 1110, 1060, 1020, 960, 910, 860, 800, 750, 700, 660, 630, 600, 580, 570, 560, 560, 560, 570, 580, 590, 610, 620, 630, 650, 660, 680, 690, 710, 720, 730, 740, 750, 760, 770, 770, 780, 780, 788, 782, 754, 697, 640, 602, 541, 410, 292, 182, 161, 10, -102, -128, -269, -324, -364, -454, -471, -511, -540, -542, -520, -546, -546, -579, -563, -564, -580, -566, -587, -601, -619, -664, -644, -647, -609, -576, -466, -374, -272, -154, -2, 124, 264, 386, 537, 614, 775, 913, 1046, 1153, 1336, 1465, 1601, 1720, 1824, 1906, 2025, 2095, 2116, 2225, 2241, 2303, 2349, 2362, 2386, 2449, 2434, 2408, 2402, 2400, 2387, 2395, 2386, 2393, 2373, 2392, 2396, 2402, 2433, 2483, 2530, 2570, 2624, 2677, 2728, 2778, 2825, 2871, 2915, 2957, 2997, 3036, 3072, 3107, 3135, 3168, 3218, 3268, 3315, 3359, 3400, 3447, 3503, 3573, 3654, 3743, 3829, 3920, 4018, 4117, 4223, 4337, 4449, 4548, 4646, 4752, 4853, 4959, 5054, 5138, 5217, 5296, 5379, 5434, 5487, 5532, 5582, 5630, 5686, 5757, 5831, 5912, 5998, 6078, 6163, 6230, 6297, 6347, 6383, 6409, 6430, 6447, 6457, 6469, 6481, 6500, 6520, 6550, 6600, 6650, 6700, 6750, 6800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int TAB2_SIZ = 43;
    private static final int TAB2_START = -500;
    private static final int TAB2_END = 1600;
    private static short[] dt2 = new short[]{16800, 16000, 15300, 14600, 14000, 13400, 12800, 12200, 11600, 11100, 10600, 10100, 9600, 9100, 8600, 8200, 7700, 7200, 6700, 6200, 5700, 5200, 4700, 4300, 3800, 3400, 3000, 2600, 2200, 1900, 1600, 1350, 1100, 900, 750, 600, 470, 380, 300, 230, 180, 140, 110};

    public SweDate() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        this.setFields(cal.get(1), cal.get(2) + 1, cal.get(5), (double)cal.get(11) + (double)cal.get(12) / 60.0 + (double)cal.get(13) / 3600.0 + (double)cal.get(14) / 3600000.0, true);
    }

    public SweDate(double jd) {
        this.initDateFromJD(jd, this.jdCO <= jd);
    }

    public SweDate(double jd, boolean calType) {
        this.initDateFromJD(jd, calType);
    }

    public SweDate(int year, int month, int day, double hour) {
        this.setFields(year, month, day, hour);
    }

    public SweDate(int year, int month, int day, double hour, boolean calType) {
        this.setFields(year, month, day, hour, calType);
    }

    public double getJulDay() {
        return this.jd;
    }

    public static double getJulDay(int year, int month, int day, double hour) {
        double sjd = SweDate.swe_julday(year, month, day, hour, true);
        return sjd;
    }

    public static double getJulDay(int year, int month, int day, double hour, boolean calType) {
        double sjd = SweDate.swe_julday(year, month, day, hour, calType);
        return sjd;
    }

    public int getDayOfWeekNr() {
        return (int)(this.jd - 5.5) % 7;
    }

    public static synchronized int getDayOfWeekNr(double jd) {
        return (int)(jd - 5.5) % 7;
    }

    public static int getDayOfWeekNr(int year, int month, int day) {
        int sdow = (int)(SweDate.swe_julday(year, month, day, 0.0, true) - 5.5) % 7;
        return sdow;
    }

    public static int getDayOfWeekNr(int year, int month, int day, boolean calType) {
        int sdow = (int)(SweDate.swe_julday(year, month, day, 0.0, calType) - 5.5) % 7;
        return sdow;
    }

    public boolean getCalendarType() {
        return this.calType;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public double getHour() {
        return this.hour;
    }

    public double getDeltaT() {
        if (this.deltatIsValid) {
            return this.deltaT;
        }
        this.deltaT = this.calc_deltaT(this.getJulDay());
        this.deltatIsValid = true;
        return this.deltaT;
    }

    public static double getDeltaT(double tjd) {
        double sdt = SweDate.calc_deltaT(tjd, -25.7376);
        return sdt;
    }

    public Date getDate(long offset) {
        long millis = (long)((this.getJulDay() - 2440587.5) * 24.0 * 3600.0 * 1000.0) + offset;
        return new Date(millis);
    }

    public static Date getDate(double jd) {
        long millis = (long)((jd - 2440587.5) * 24.0 * 3600.0 * 1000.0);
        return new Date(millis);
    }

    public void setJulDay(double newJD) {
        this.jd = newJD;
        this.deltatIsValid = false;
        IDate dt = this.swe_revjul(newJD, this.calType);
        this.year = dt.year;
        this.month = dt.month;
        this.day = dt.day;
        this.hour = dt.hour;
    }

    public void setCalendarType(boolean newCalType, boolean keepDate) {
        if (this.calType != newCalType) {
            this.calType = newCalType;
            this.deltatIsValid = false;
            if (keepDate) {
                this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
            } else {
                IDate dt = this.swe_revjul(this.jd, newCalType);
                this.year = dt.year;
                this.month = dt.month;
                this.day = dt.day;
                this.hour = dt.hour;
            }
        }
    }

    public void updateCalendarType() {
        this.calType = this.jdCO <= this.jd;
    }

    public boolean setDate(int newYear, int newMonth, int newDay, double newHour) {
        this.year = newYear;
        this.month = newMonth;
        this.day = newDay;
        this.hour = newHour;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        return true;
    }

    public boolean setDate(int newYear, int newMonth, int newDay, double newHour, boolean check) {
        this.year = newYear;
        double oldMonth = this.month;
        double oldDay = this.day;
        this.month = newMonth;
        this.day = newDay;
        this.hour = newHour;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        if (check) {
            IDate dt = this.swe_revjul(this.jd, this.calType);
            this.year = dt.year;
            this.month = dt.month;
            this.day = dt.day;
            this.hour = dt.hour;
            return this.year == newYear && (double)this.month == oldMonth && (double)this.day == oldDay;
        }
        return true;
    }

    public boolean setYear(int newYear) {
        this.year = newYear;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        return true;
    }

    public boolean setYear(int newYear, boolean check) {
        this.year = newYear;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        if (check) {
            double oldMonth = this.month;
            double oldDay = this.day;
            IDate dt = this.swe_revjul(this.jd, this.calType);
            this.year = dt.year;
            this.month = dt.month;
            this.day = dt.day;
            this.hour = dt.hour;
            return this.year == newYear && (double)this.month == oldMonth && (double)this.day == oldDay;
        }
        return true;
    }

    public boolean setMonth(int newMonth) {
        this.month = newMonth;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        return true;
    }

    public boolean setMonth(int newMonth, boolean check) {
        this.month = newMonth;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        if (check) {
            double oldYear = this.year;
            double oldDay = this.day;
            IDate dt = this.swe_revjul(this.jd, this.calType);
            this.year = dt.year;
            this.month = dt.month;
            this.day = dt.day;
            this.hour = dt.hour;
            return (double)this.year == oldYear && this.month == newMonth && (double)this.day == oldDay;
        }
        return true;
    }

    public boolean setDay(int newDay) {
        this.day = newDay;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        return true;
    }

    public boolean setDay(int newDay, boolean check) {
        this.day = newDay;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        if (check) {
            double oldYear = this.year;
            double oldMonth = this.month;
            IDate dt = this.swe_revjul(this.jd, this.calType);
            this.year = dt.year;
            this.month = dt.month;
            this.day = dt.day;
            this.hour = dt.hour;
            return (double)this.year == oldYear && (double)this.month == oldMonth && this.day == newDay;
        }
        return true;
    }

    public boolean setHour(double newHour) {
        this.hour = newHour;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        return true;
    }

    public boolean checkDate() {
        boolean cd = this.checkDate(this.year, this.month, this.day, this.hour);
        return cd;
    }

    public boolean checkDate(int year, int month, int day) {
        boolean cd = this.checkDate(year, month, day, 0.0);
        return cd;
    }

    public boolean checkDate(int year, int month, int day, double hour) {
        double jd = SweDate.swe_julday(year, month, day, hour, true);
        IDate dt = this.swe_revjul(jd, true);
        return dt.year == year && dt.month == month && dt.day == day;
    }

    public void makeValidDate() {
        double jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, true);
        IDate dt = this.swe_revjul(jd, true);
        this.year = dt.year;
        this.month = dt.month;
        this.day = dt.day;
        this.hour = dt.hour;
    }

    public double getGregorianChange() {
        return this.jdCO;
    }

    public void setGregorianChange(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.deltatIsValid = false;
        this.calType = true;
        if (this.year < year || this.year == year && this.month < month || this.year == year && this.month == month && this.day < day) {
            this.calType = false;
        }
        this.jdCO = SweDate.swe_julday(year, month, day, 0.0, true);
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
    }

    public void setGregorianChange(double newJDCO) {
        this.jdCO = newJDCO;
        this.calType = this.jd >= this.jdCO;
        IDate dt = this.swe_revjul(this.jd, this.calType);
        this.year = dt.year;
        this.month = dt.month;
        this.day = dt.day;
        this.hour = dt.hour;
    }

    public double getTidalAcc() {
        return tid_acc;
    }

    public void setTidalAcc(double tid_acc) {
        SweDate.tid_acc = tid_acc;
    }

    public String toString() {
        double hour = this.getHour();
        String h = (int)hour + ":";
        hour = 60.0 * (hour - (double)((int)hour));
        h = h + (int)hour + ":";
        hour = 60.0 * (hour - (double)((int)hour));
        h = h + hour;
        return "(YYYY/MM/DD) " + this.getYear() + "/" + (this.getMonth() < 10 ? "0" : "") + this.getMonth() + "/" + (this.getDay() < 10 ? "0" : "") + this.getDay() + ", " + h + "h " + (this.getCalendarType() ? "(greg)" : "(jul)") + "\nJul. Day: " + this.getJulDay() + "; DeltaT: " + this.getDeltaT();
    }

    private static synchronized double swe_julday(int year, int month, int day, double hour, boolean calType) {
        double u = year;
        if (month < 3) {
            u -= 1.0;
        }
        double u0 = u + 4712.0;
        double u1 = (double)month + 1.0;
        if (u1 < 4.0) {
            u1 += 12.0;
        }
        double jd = Math.floor(u0 * 365.25) + Math.floor(30.6 * u1 + 1.0E-6) + (double)day + hour / 24.0 - 63.5;
        if (calType) {
            double u2 = Math.floor(Math.abs(u) / 100.0) - Math.floor(Math.abs(u) / 400.0);
            if (u < 0.0) {
                u2 = -u2;
            }
            jd = jd - u2 + 2.0;
            if (u < 0.0 && u / 100.0 == Math.floor(u / 100.0) && u / 400.0 != Math.floor(u / 400.0)) {
                jd -= 1.0;
            }
        }
        return jd;
    }

    private synchronized IDate swe_revjul(double jd, boolean calType) {
        IDate dt = new IDate();
        double u0 = jd + 32082.5;
        if (calType) {
            double u1 = u0 + Math.floor(u0 / 36525.0) - Math.floor(u0 / 146100.0) - 38.0;
            if (jd >= 1830691.5) {
                u1 += 1.0;
            }
            u0 = u0 + Math.floor(u1 / 36525.0) - Math.floor(u1 / 146100.0) - 38.0;
        }
        double u2 = Math.floor(u0 + 123.0);
        double u3 = Math.floor((u2 - 122.2) / 365.25);
        double u4 = Math.floor((u2 - Math.floor(365.25 * u3)) / 30.6001);
        dt.month = (int)(u4 - 1.0);
        if (dt.month > 12) {
            dt.month -= 12;
        }
        dt.day = (int)(u2 - Math.floor(365.25 * u3) - Math.floor(30.6001 * u4));
        dt.year = (int)(u3 + Math.floor((u4 - 2.0) / 12.0) - 4800.0);
        dt.hour = (jd - Math.floor(jd + 0.5) + 0.5) * 24.0;
        return dt;
    }

    private synchronized double calc_deltaT(double tjd) {
        double sdt = SweDate.calc_deltaT(tjd, tid_acc);
        return sdt;
    }

    private static synchronized double calc_deltaT(double tjd, double tid_acc) {
        int iy;
        double p;
        double dd;
        double ans = 0.0;
        double B = 0.0;
        double Y = 0.0;
        int[] d = new int[6];
        int tabsiz = SweDate.init_dt();
        int tabend = 1620 + tabsiz - 1;
        Y = 2000.0 + (tjd - 2451545.0) / 365.25;
        if (Y < -500.0) {
            B = (Y - 1735.0) * 0.01;
            ans = -20.0 + 35.0 * B * B;
            ans = SweDate.adjust_for_tidacc(tid_acc, ans, Y);
            if (Y >= -600.0) {
                double ans2 = SweDate.adjust_for_tidacc(tid_acc, dt2[0], -500.0);
                B = -22.35;
                double ans3 = -20.0 + 35.0 * B * B;
                ans3 = SweDate.adjust_for_tidacc(tid_acc, ans3, Y);
                dd = ans3 - ans2;
                B = (Y - -600.0) * 0.01;
                ans -= dd * B;
            }
        }
        if (Y >= -500.0 && Y < 1600.0) {
            p = Math.floor(Y);
            iy = (int)((p - -500.0) / 50.0);
            dd = (Y - (double)(-500 + 50 * iy)) / 50.0;
            ans = (double)dt2[iy] + (double)(dt2[iy + 1] - dt2[iy]) * dd;
            ans = SweDate.adjust_for_tidacc(tid_acc, ans, Y);
        }
        if (Y >= 1600.0 && Y < 1620.0) {
            B = 20.0;
            iy = 42;
            dd = (Y - 1600.0) / B;
            ans = (double)dt2[iy] + dd * ((double)dt[0] / 100.0 - (double)dt2[iy]);
            ans = SweDate.adjust_for_tidacc(tid_acc, ans, Y);
        }
        if (Y >= 1620.0 && Y <= (double)tabend) {
            int i;
            p = Math.floor(Y);
            iy = (int)(p - 1620.0);
            ans = dt[iy];
            int k = iy + 1;
            if (k >= tabsiz) {
                return SweDate.deltatIsDone(ans, Y, B, tid_acc, tabsiz, tabend);
            }
            p = Y - p;
            ans += p * (double)(dt[k] - dt[iy]);
            if (iy - 1 < 0 || iy + 2 >= tabsiz) {
                return SweDate.deltatIsDone(ans, Y, B, tid_acc, tabsiz, tabend);
            }
            k = iy - 2;
            for (i = 0; i < 5; ++i) {
                d[i] = k < 0 || k + 1 >= tabsiz ? 0 : dt[k + 1] - dt[k];
                ++k;
            }
            for (i = 0; i < 4; ++i) {
                d[i] = d[i + 1] - d[i];
            }
            B = 0.25 * p * (p - 1.0);
            ans += B * (double)(d[1] + d[2]);
            if (iy + 2 >= tabsiz) {
                return SweDate.deltatIsDone(ans, Y, B, tid_acc, tabsiz, tabend);
            }
            for (i = 0; i < 3; ++i) {
                d[i] = d[i + 1] - d[i];
            }
            B = 2.0 * B / 3.0;
            ans += (p - 0.5) * B * (double)d[1];
            if (iy - 2 < 0 || iy + 3 > tabsiz) {
                return SweDate.deltatIsDone(ans, Y, B, tid_acc, tabsiz, tabend);
            }
            for (i = 0; i < 2; ++i) {
                d[i] = d[i + 1] - d[i];
            }
            B = 0.125 * B * (p + 1.0) * (p - 2.0);
            ans += B * (double)(d[0] + d[1]);
        }
        return SweDate.deltatIsDone(ans, Y, B, tid_acc, tabsiz, tabend);
    }

    private static synchronized double deltatIsDone(double ans, double Y, double B, double tid_acc, int tabsiz, int tabend) {
        if (Y >= 1620.0 && Y <= (double)tabend) {
            ans *= 0.01;
            ans = SweDate.adjust_for_tidacc(tid_acc, ans, Y);
        }
        if (Y > (double)tabend) {
            B = 0.01 * (Y - 1820.0);
            ans = -20.0 + 31.0 * B * B;
            if (Y <= (double)(tabend + 100)) {
                double B2 = 0.01 * (double)(tabend - 1820);
                double ans2 = -20.0 + 31.0 * B2 * B2;
                double ans3 = (double)dt[tabsiz - 1] * 0.01;
                double dd = ans2 - ans3;
                ans += dd * (Y - (double)(tabend + 100)) * 0.01;
            }
        }
        return ans / 86400.0;
    }

    private static int init_dt() {
        FilePtr fp = null;
        if (!init_dt_done) {
            init_dt_done = true;
            try {
                fp = sw.swi_fopen(-1, "sedeltat.txt", SweDate.sw.swed.ephepath, null);
                if (fp == null) {
                    return 395;
                }
            }
            catch (SwissephException se) {
                return 395;
            }
            try {
                String s;
                while ((s = fp.readLine()) != null) {
                    int year;
                    int tab_index;
                    s.trim();
                    if (s.length() == 0 || s.charAt(0) == '#' || (tab_index = (year = SwissLib.atoi(s)) - 1620) >= 445) continue;
                    if (s.length() > 4) {
                        s = s.substring(4).trim();
                    }
                    SweDate.dt[tab_index] = (short)((double)(SwissLib.atoi(s) * 100) + 0.5);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                fp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int tabsiz = 382;
        for (int i = tabsiz - 1; i < 445 && dt[i] != 0; ++i) {
            ++tabsiz;
        }
        return --tabsiz;
    }

    private static double adjust_for_tidacc(double tid_acc_local, double ans, double Y) {
        if (Y < 1955.0) {
            double B = Y - 1955.0;
            ans += -9.1E-5 * (tid_acc_local + 26.0) * B * B;
        }
        return ans;
    }

    private void initDateFromJD(double jd, boolean calType) {
        this.jd = jd;
        this.calType = calType;
        IDate dt = this.swe_revjul(jd, calType);
        this.year = dt.year;
        this.month = dt.month;
        this.day = dt.day;
        this.hour = dt.hour;
    }

    private void setFields(int year, int month, int day, double hour) {
        IDate dt = this.swe_revjul(this.jdCO, true);
        boolean calType = true;
        if (dt.year > year || dt.year == year && dt.month > month || dt.year == year && dt.month == month && dt.day > day) {
            calType = false;
        }
        this.setFields(year, month, day, hour, calType);
    }

    private void setFields(int year, int month, int day, double hour, boolean calType) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.calType = calType;
        this.jd = SweDate.swe_julday(year, month, day, hour, calType);
    }
}

