/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.IOException;
import swisseph.FilePtr;
import swisseph.PlanData;
import swisseph.SwissData;
import swisseph.SwissLib;
import swisseph.SwissephException;

class FileData {
    final byte SEI_FILE_NMAXPLAN = (byte)50;
    String fnam;
    int fversion;
    String astnam;
    int sweph_denum;
    FilePtr fptr;
    double tfstart;
    double tfend;
    int iflg;
    short npl;
    int[] ipl = new int[50];
    static long[] crc32_table = null;
    static final int CRC32_POLY = 79764919;

    FileData() {
    }

    void clearData() {
        this.fnam = "";
        this.fversion = 0;
        this.astnam = "";
        this.sweph_denum = 0;
        try {
            if (this.fptr != null) {
                this.fptr.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fptr = null;
        this.tfstart = 0.0;
        this.tfend = 0.0;
        this.iflg = 0;
        this.npl = 0;
        for (int j = 0; j < 50; ++j) {
            this.ipl[j] = 0;
        }
    }

    int read_const(int ifno, StringBuffer serr, SwissData swed) {
        String s = "";
        String s2 = "";
        String sastnam = "";
        int lastnam = 19;
        FileData fdp = swed.fidat[ifno];
        String serr_file_damage = "Ephemeris file " + this.fnam + " is damaged. ";
        int nbytes_ipl = 2;
        try {
            int freord;
            int j;
            int i;
            char cLast;
            byte b = 0;
            do {
                cLast = (char)b;
                b = this.fptr.readByte();
                s = s + (char)b;
            } while (cLast != '\r' && (char)b != '\n' && s.length() < 256);
            s = s.trim();
            int offs = 0;
            int ver = -1;
            while (!Character.isDigit(s.charAt(offs))) {
                ++offs;
            }
            try {
                ver = Integer.parseInt(s.substring(offs));
            }
            catch (NumberFormatException n) {
                System.out.println(serr_file_damage + " (1)");
                this.fptr.close();
                throw new SwissephException(this.tfstart, 65, -1, serr);
            }
            this.fversion = ver;
            b = 0;
            s = "";
            do {
                cLast = (char)b;
                b = this.fptr.readByte();
                s = s + (char)b;
            } while (cLast != '\r' && (char)b != '\n' && s.length() < 256);
            s2 = this.fnam.substring(this.fnam.lastIndexOf(swed.DIR_GLUE) + 1).toLowerCase();
            if (!(s = s.trim().toLowerCase()).equals(s2) && !s.equals(s2 = this.fnam.substring(this.fnam.lastIndexOf("/") + 1).toLowerCase())) {
                s2 = this.fnam.substring(this.fnam.lastIndexOf(swed.DIR_GLUE) + 1).toLowerCase();
                System.out.println("Ephemeris file name '" + s2 + "' is wrong; rename to '" + s + "'");
                this.fptr.close();
                throw new SwissephException(this.tfstart, 65, -1, serr);
            }
            b = 0;
            s = "";
            do {
                cLast = (char)b;
                b = this.fptr.readByte();
                s = s + (char)b;
            } while (cLast != '\r' && (char)b != '\n' && s.length() < 256);
            if (ifno == 3) {
                b = 0;
                s = "";
                do {
                    cLast = (char)b;
                    b = this.fptr.readByte();
                    s = s + (char)b;
                } while (cLast != '\r' && (char)b != '\n' && s.length() < 512);
                i = 5;
                while (s.charAt(i) != ' ') {
                    ++i;
                }
                j = i - 5;
                sastnam = s.substring(0, lastnam + i);
                swed.astelem = s;
                swed.ast_G = SwissLib.atof(s.substring(40 + j));
                swed.ast_H = SwissLib.atof(s.substring(46 + j));
                s2 = s.substring(56 + j, 63 + j);
                swed.ast_diam = SwissLib.atof(s2);
            }
            int testendian = this.fptr.readInt();
            long lng = 0L;
            if (testendian == 6382179) {
                freord = 0;
            } else {
                freord = 2;
                lng = ((testendian & 0xFF) << 24) + ((testendian & 0xFF00) << 8) + ((testendian & 0xFF0000) >> 8) + ((testendian & 0xFF000000) >> 24);
                if (lng != 6382179L) {
                    throw new SwissephException(this.tfstart, 65, -1, "File is damaged: byte ordering info not correct.");
                }
            }
            int fendian = 0 == (testendian & 0xFF) ? 0 : 1;
            fdp.iflg = freord | fendian;
            lng = this.read4(this.fptr, -1L, false, freord, fendian);
            if (lng < 0L) {
                lng &= 0xFFFFFFFFFFFFFFFFL;
            }
            long fpos = this.fptr.getFilePointer();
            long flen = this.fptr.length();
            if (lng != flen) {
                System.out.println(serr_file_damage + " (2)");
                this.fptr.close();
                throw new SwissephException(this.tfstart, 65, -1, serr);
            }
            this.fptr.seek(flen - 1L);
            this.fptr.seek(fpos);
            fdp.sweph_denum = this.read4(this.fptr, fpos, false, freord, fendian);
            this.tfstart = this.read8(this.fptr, -1L, freord, fendian);
            this.tfend = this.read8(this.fptr, -1L, freord, fendian);
            int nplan = this.read2(this.fptr, -1L, freord, fendian);
            if (nplan > 256) {
                nbytes_ipl = 4;
                nplan = (short)(nplan % 256);
            }
            if (nplan < 1 || nplan > 20) {
                System.out.println(serr_file_damage + " (3)");
                this.fptr.close();
                throw new SwissephException(this.tfstart, 65, -1, serr);
            }
            fdp.npl = nplan;
            if (nbytes_ipl == 2) {
                for (i = 0; i < nplan; ++i) {
                    this.ipl[i] = this.read2(this.fptr, -1L, freord, fendian);
                }
            } else if (nbytes_ipl == 4) {
                for (i = 0; i < nplan; ++i) {
                    this.ipl[i] = this.read4(this.fptr, -1L, false, freord, fendian);
                }
            } else {
                System.out.println(serr_file_damage + " (3b)");
            }
            if (ifno == 3) {
                for (j = 4; sastnam.charAt(j) != ' ' && j < 10; ++j) {
                }
                String sastno = sastnam.substring(0, Math.min(sastnam.length(), j)).trim();
                i = Integer.parseInt(sastno);
                if (i == this.ipl[0] - 10000) {
                    this.astnam = sastnam.substring(Math.min(sastnam.length(), j + 1), Math.min(sastnam.length(), j + 1 + lastnam));
                    s = "";
                    for (i = 0; i < 30; ++i) {
                        s = s + (char)this.fptr.readByte();
                    }
                } else {
                    this.astnam = "";
                    for (i = 0; i < 30; ++i) {
                        this.astnam = this.astnam + (char)this.fptr.readByte();
                    }
                }
                this.astnam = this.astnam.trim();
            }
            fpos = this.fptr.getFilePointer();
            long ulng = this.read4(this.fptr, -1L, false, freord, fendian);
            this.fptr.seek(0L);
            if (fpos - 1L > 512L) {
                System.out.println(serr_file_damage + " (4)");
                this.fptr.close();
                throw new SwissephException(this.tfstart, 65, -1, serr);
            }
            b = 0;
            s = "";
            byte[] ba = new byte[512];
            i = 0;
            while ((long)i < fpos) {
                cLast = (char)b;
                ba[i] = b = this.fptr.readByte();
                s = s + (char)b;
                ++i;
            }
            if ((int)this.swi_crc32(ba, (int)fpos) != (int)ulng) {
                System.err.println(serr_file_damage + " (5)");
                this.fptr.close();
                throw new SwissephException(this.tfstart, 65, -1, serr);
            }
            this.fptr.seek(fpos + 4L);
            swed.gcdat.clight = this.read8(this.fptr, -1L, freord, fendian);
            swed.gcdat.aunit = this.read8(this.fptr, -1L, freord, fendian);
            swed.gcdat.helgravconst = this.read8(this.fptr, -1L, freord, fendian);
            swed.gcdat.ratme = this.read8(this.fptr, -1L, freord, fendian);
            swed.gcdat.sunradius = this.read8(this.fptr, -1L, freord, fendian);
            for (int kpl = 0; kpl < this.npl; ++kpl) {
                int ipli = this.ipl[kpl];
                PlanData pdp = ipli >= 10000 ? swed.pldat[11] : swed.pldat[ipli];
                pdp.ibdy = ipli;
                pdp.lndx0 = (long)this.read4(this.fptr, -1L, false, freord, fendian) & 0xFFFFFFFFL;
                pdp.iflg = this.fptr.readUnsignedByte();
                pdp.ncoe = this.fptr.readUnsignedByte();
                lng = this.read4(this.fptr, -1L, false, freord, fendian);
                pdp.rmax = (double)lng / 1000.0;
                pdp.tfstart = this.read8(this.fptr, -1L, freord, fendian);
                pdp.tfend = this.read8(this.fptr, -1L, freord, fendian);
                pdp.dseg = this.read8(this.fptr, -1L, freord, fendian);
                pdp.nndx = (int)((pdp.tfend - pdp.tfstart + 0.1) / pdp.dseg);
                pdp.telem = this.read8(this.fptr, -1L, freord, fendian);
                pdp.prot = this.read8(this.fptr, -1L, freord, fendian);
                pdp.dprot = this.read8(this.fptr, -1L, freord, fendian);
                pdp.qrot = this.read8(this.fptr, -1L, freord, fendian);
                pdp.dqrot = this.read8(this.fptr, -1L, freord, fendian);
                pdp.peri = this.read8(this.fptr, -1L, freord, fendian);
                pdp.dperi = this.read8(this.fptr, -1L, freord, fendian);
                if ((pdp.iflg & 4) == 0) continue;
                if (pdp.refep != null) {
                    pdp.refep = null;
                    if (pdp.segp != null) {
                        pdp.segp = null;
                    }
                }
                pdp.refep = new double[2 * pdp.ncoe];
                for (i = 0; i < 2 * pdp.ncoe; ++i) {
                    pdp.refep[i] = this.read8(this.fptr, -1L, freord, fendian);
                }
            }
        }
        catch (IOException e) {
            try {
                this.fptr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println(serr_file_damage + " (6)");
            System.out.println(e.getMessage());
            throw new SwissephException(this.tfstart, 65, -1, serr);
        }
        return 0;
    }

    long swi_crc32(byte[] buf, int len) {
        if (crc32_table == null) {
            this.init_crc32();
        }
        long crc = 0xFFFFFFFFL;
        int pn = 0;
        while (len > 0) {
            crc = crc << 8 & 0xFFFFFFFFL ^ crc32_table[(int)(crc >> 24 ^ (long)buf[pn] & 0xFFL)];
            ++pn;
            --len;
        }
        return crc ^ 0xFFFFFFFFFFFFFFFFL;
    }

    void init_crc32() {
        crc32_table = new long[256];
        for (long i = 0L; i < 256L; ++i) {
            long c = i << 24;
            for (long j = 8L; j > 0L; --j) {
                c = (c & 0x80000000L) != 0L ? c << 1 ^ 0x4C11DB7L : c << 1;
            }
            FileData.crc32_table[(int)i] = c &= 0xFFFFFFFFL;
        }
    }

    short read2(FilePtr fp, long fpos, int freord, int fendian) throws IOException {
        if (fpos >= 0L) {
            fp.seek(fpos);
        }
        short val = fp.readShort();
        if (freord != 0) {
            val = (short)((val << 8) + (val >>> 8));
        }
        return val;
    }

    int read3(FilePtr fp, long fpos, int freord, int fendian) throws IOException {
        if (fpos >= 0L) {
            fp.seek(fpos);
        }
        int val = fp.readUnsignedByte();
        int i2 = fp.readShort();
        if (i2 < 0) {
            i2 &= 0xFFFF;
        }
        val = (val << 16) + i2;
        if (freord != 0) {
            val = ((val & 0xFF) << 24) + ((val & 0xFF00) << 8) + ((val & 0xFF0000) >> 8) + ((val & 0xFF000000) >> 24);
            boolean do_shift = fendian == 0 && freord != 0 || fendian == 1 && freord == 0;
            return do_shift ? val >> 8 : val;
        }
        return val;
    }

    int read4(FilePtr fp, long fpos, boolean unsigned, int freord, int fendian) throws IOException {
        if (fpos >= 0L) {
            fp.seek(fpos);
        }
        int val = fp.readInt();
        if (freord != 0) {
            val = unsigned ? ((val & 0xFF) << 24) + ((val & 0xFF00) << 8) + ((val & 0xFF0000) >> 8) + ((val & 0xFF000000) >> 24) : ((val & 0xFF) << 24) + ((val & 0xFF00) << 8) + ((val & 0xFF0000) >> 8) + ((val & 0xFF000000) >>> 24);
        } else if (unsigned && val < 0) {
            val &= Integer.MAX_VALUE;
        }
        return val;
    }

    double read8(FilePtr fp, long fpos, int freord, int fendian) throws IOException {
        if (fpos >= 0L) {
            fp.seek(fpos);
        }
        long val = Double.doubleToLongBits(fp.readDouble());
        if (freord != 0) {
            val = ((val & 0xFFL) << 56) + ((val & 0xFF00L) << 40) + ((val & 0xFF0000L) << 24) + ((val & 0xFF000000L) << 8) + ((val & 0xFF00000000L) >> 8) + ((val & 0xFF0000000000L) >> 24) + ((val & 0xFF000000000000L) >> 40) + ((val & 0xFF00000000000000L) >> 56);
        }
        return Double.longBitsToDouble(val);
    }

    int get_new_segment(SwissData swed, double tjd, int ipli, int ifno, StringBuffer serr) {
        int[] nsize = new int[6];
        short[] c = new short[4];
        PlanData pdp = swed.pldat[ipli];
        FileData fdp = swed.fidat[ifno];
        int freord = fdp.iflg & 2;
        int fendian = fdp.iflg & 1;
        long[] longs = new long[41];
        int iseg = (int)((tjd - pdp.tfstart) / pdp.dseg);
        pdp.tseg0 = pdp.tfstart + (double)iseg * pdp.dseg;
        pdp.tseg1 = pdp.tseg0 + pdp.dseg;
        int fpos = (int)pdp.lndx0 + iseg * 3;
        try {
            int i;
            fpos = this.read3(this.fptr, fpos, freord, fendian);
            this.fptr.seek(fpos);
            if (pdp.segp == null) {
                pdp.segp = new double[pdp.ncoe * 3];
            }
            for (i = 0; i < pdp.segp.length; ++i) {
                pdp.segp[i] = 0.0;
            }
            for (int icoord = 0; icoord < 3; ++icoord) {
                int nco;
                int nsizes;
                int idbl = icoord * pdp.ncoe;
                c[0] = (short)this.fptr.readUnsignedByte();
                c[1] = (short)this.fptr.readUnsignedByte();
                if ((c[0] & 0x80) != 0) {
                    nsizes = 6;
                    c[2] = (short)this.fptr.readUnsignedByte();
                    c[3] = (short)this.fptr.readUnsignedByte();
                    nsize[0] = c[1] / 16;
                    nsize[1] = c[1] % 16;
                    nsize[2] = c[2] / 16;
                    nsize[3] = c[2] % 16;
                    nsize[4] = c[3] / 16;
                    nsize[5] = c[3] % 16;
                    nco = nsize[0] + nsize[1] + nsize[2] + nsize[3] + nsize[4] + nsize[5];
                } else {
                    nsizes = 4;
                    nsize[0] = c[0] / 16;
                    nsize[1] = c[0] % 16;
                    nsize[2] = c[1] / 16;
                    nsize[3] = c[1] % 16;
                    nco = nsize[0] + nsize[1] + nsize[2] + nsize[3];
                }
                if (nco > pdp.ncoe) {
                    if (serr != null) {
                        serr.append("error in ephemeris file " + fdp.fnam + ": " + nco + " coefficients instead of " + pdp.ncoe + ". ");
                    }
                    throw new SwissephException(this.tfstart, 65, -1, serr);
                }
                for (i = 0; i < nsizes; ++i) {
                    int o;
                    int n;
                    int m;
                    int kCnt;
                    int k;
                    int j;
                    if (nsize[i] == 0) continue;
                    if (i < 4) {
                        j = 4 - i;
                        k = nsize[i];
                        block11: for (kCnt = 0; kCnt < k; ++kCnt) {
                            switch (j) {
                                case 1: {
                                    longs[kCnt] = this.fptr.readUnsignedByte();
                                    continue block11;
                                }
                                case 2: {
                                    longs[kCnt] = this.read2(this.fptr, -1L, freord, fendian);
                                    if (longs[kCnt] >= 0L) continue block11;
                                    int n2 = kCnt;
                                    longs[n2] = longs[n2] & 0xFFFFL;
                                    continue block11;
                                }
                                case 3: {
                                    longs[kCnt] = this.read3(this.fptr, -1L, freord, fendian);
                                    if (longs[kCnt] >= 0L) continue block11;
                                    int n3 = kCnt;
                                    longs[n3] = longs[n3] & 0xFFFFFFL;
                                    continue block11;
                                }
                                case 4: {
                                    longs[kCnt] = this.read4(this.fptr, -1L, false, freord, fendian);
                                    if (longs[kCnt] >= 0L) continue block11;
                                    int n4 = kCnt;
                                    longs[n4] = longs[n4] & 0xFFFFFFFFFFFFFFFFL;
                                }
                            }
                        }
                        m = 0;
                        while (m < k) {
                            pdp.segp[idbl] = (longs[m] & 1L) != 0L ? -((double)((longs[m] + 1L) / 2L & Integer.MAX_VALUE) / 1.0E9 * pdp.rmax / 2.0) : (double)(longs[m] / 2L & Integer.MAX_VALUE) / 1.0E9 * pdp.rmax / 2.0;
                            ++m;
                            ++idbl;
                        }
                        continue;
                    }
                    if (i == 4) {
                        j = 1;
                        k = (nsize[i] + 1) / 2;
                        for (kCnt = 0; kCnt < k; ++kCnt) {
                            longs[kCnt] = this.fptr.readUnsignedByte();
                        }
                        j = 0;
                        for (m = 0; m < k && j < nsize[i]; ++m) {
                            n = 0;
                            o = 16;
                            while (n < 2 && j < nsize[i]) {
                                pdp.segp[idbl] = (longs[m] & (long)o) != 0L ? -((double)((longs[m] + (long)o) / (long)o / 2L) * pdp.rmax / 2.0 / 1.0E9) : (double)(longs[m] / (long)o / 2L) * pdp.rmax / 2.0 / 1.0E9;
                                ++n;
                                ++j;
                                ++idbl;
                                int n5 = m;
                                longs[n5] = longs[n5] % (long)o;
                                o /= 16;
                            }
                        }
                        continue;
                    }
                    if (i != 5) continue;
                    j = 1;
                    k = (nsize[i] + 3) / 4;
                    for (kCnt = 0; kCnt < k; ++kCnt) {
                        longs[kCnt] = this.fptr.readUnsignedByte();
                    }
                    j = 0;
                    for (m = 0; m < k && j < nsize[i]; ++m) {
                        n = 0;
                        o = 64;
                        while (n < 4 && j < nsize[i]) {
                            pdp.segp[idbl] = (longs[m] & (long)o) != 0L ? -((double)((longs[m] + (long)o) / (long)o / 2L) * pdp.rmax / 2.0 / 1.0E9) : (double)(longs[m] / (long)o / 2L) * pdp.rmax / 2.0 / 1.0E9;
                            ++n;
                            ++j;
                            ++idbl;
                            int n6 = m;
                            longs[n6] = longs[n6] % (long)o;
                            o /= 4;
                        }
                    }
                }
            }
            return 0;
        }
        catch (IOException e) {
            serr.append("file error in swisseph.FileData: " + e.getMessage());
            throw new SwissephException(this.tfstart, 65, -1, serr);
        }
    }
}

