/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import swisseph.SwissEph;
import swisseph.SwissephException;
import swisseph.TransitCalculator;

class Extensions {
    SwissEph sw;
    protected double[] maxBaryDist = new double[]{0.009570999, 1.028809521, 0.466604085, 0.728698831, 0.728698831, 4.955912195, 8.968685733, 19.893326756, 30.326750627, 41.499626899, 0.002569555, 0.002774851, 1.0, 0.002782378, 0.0, 0.05, 31.901319663, 3.012409508, 3.721614106, 3.326307148, 2.570197288};

    Extensions(SwissEph sw) {
        this.sw = sw;
    }

    double getTransit(TransitCalculator tc, double jdET, boolean back, double jdLimit) throws IllegalArgumentException, SwissephException {
        double max = tc.getMaxSpeed();
        double min = tc.getMinSpeed();
        double lastJD = jdET;
        boolean found = false;
        double offset = tc.getOffset();
        boolean xneg = max < 0.0;
        boolean mneg = min < 0.0;
        double degPrec = tc.getDegreePrecision(jdET) / 2.0;
        double timePrec = tc.getTimePrecision(degPrec);
        double val = tc.calc(jdET);
        if (offset - val == 0.0) {
            return jdET;
        }
        if (max == 0.0 && min == 0.0) {
            throw new SwissephException(jdET, 384, "No transit possible due to lack of variation of speed or position.");
        }
        do {
            double jdMinus;
            double jdPlus;
            if (tc.rollover) {
                while (val >= tc.rolloverVal) {
                    val -= tc.rolloverVal;
                }
                while (val < 0.0) {
                    val += tc.rolloverVal;
                }
            }
            boolean above = val >= offset;
            lastJD = jdET;
            double lastVal = val;
            if (tc.rollover && !above) {
                val += tc.rolloverVal;
            }
            if (tc.rollover) {
                jdPlus = Math.min(val - offset, 360.0 - val + offset) / Math.abs(max);
                jdMinus = Math.min(val - offset, 360.0 - val + offset) / Math.abs(min);
                jdET = back ? (jdET -= Math.min(jdPlus, jdMinus)) : (jdET += Math.min(jdPlus, jdMinus));
            } else {
                jdPlus = (offset - val) / max;
                jdMinus = (offset - val) / min;
                if (back) {
                    if (jdPlus >= 0.0 && jdMinus >= 0.0) {
                        throw new SwissephException(jdET, 384, -1, "No transit in ephemeris time range.");
                    }
                    jdET = jdPlus >= 0.0 ? (jdET += jdMinus) : (jdET += jdPlus);
                } else {
                    if (jdPlus <= 0.0 && jdMinus <= 0.0) {
                        throw new SwissephException(jdET, 384, -1, "No transit in ephemeris time range.");
                    }
                    jdET = jdPlus <= 0.0 ? (jdET += jdMinus) : (jdET += jdPlus);
                }
            }
            if (Math.abs(jdET - lastJD) < timePrec) {
                jdET = lastJD + (back ? -timePrec : timePrec);
            }
            if (jdET == lastJD) {
                return jdET;
            }
            for (val = tc.calc(jdET); tc.rollover && val >= tc.rolloverVal; val -= tc.rolloverVal) {
            }
            while (tc.rollover && val < 0.0) {
                val += tc.rolloverVal;
            }
            if (offset - val == 0.0) {
                return jdET;
            }
            boolean pxway = true;
            if (tc.rollover) {
                double deltadeg2;
                double deltadeg1 = val - lastVal;
                if (deltadeg1 < 0.0) {
                    deltadeg1 += tc.rolloverVal;
                }
                if ((deltadeg2 = lastVal - val) < 0.0) {
                    deltadeg2 += tc.rolloverVal;
                }
                pxway = Math.abs(deltadeg1 / max) < Math.abs(deltadeg2 / min);
            } else {
                pxway = lastVal <= val;
            }
            boolean bl = found = above && val <= offset && !pxway || !above && val >= offset && pxway || tc.rollover && (offset < lastVal && val > 340.0 && lastVal < 20.0 && !pxway || offset > lastVal && val < 20.0 && lastVal > 340.0 && pxway || offset > val && val > 340.0 && lastVal < 20.0 && !pxway || offset < val && val < 20.0 && lastVal > 340.0 && pxway);
            if (!found) continue;
            if (Math.abs(val - lastVal) > 300.0 && tc.rollover) {
                if (val > lastVal) {
                    lastVal += tc.rolloverVal;
                } else {
                    val += tc.rolloverVal;
                }
                if (offset < 10.0) {
                    offset += tc.rolloverVal;
                }
            }
            double jdRet = lastJD + (jdET - lastJD) * (offset - lastVal) / (val - lastVal);
            if (back) {
                return Math.max(jdRet, jdET);
            }
            return Math.min(jdRet, jdET);
        } while (!(back && jdET < jdLimit) && (back || !(jdET > jdLimit)));
        throw new SwissephException(jdET, 6144, -1, "Time limit of " + jdLimit + " has been reached.");
    }
}

