/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.validation;

import de.cni.common.core.Brand;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.TkzGms;
import de.cni.common.validation.ValidatorTemplate;

public class TkzGmsValidator
extends ValidatorTemplate {
    public TkzGmsValidator(Brand brand) {
        super(brand);
    }

    @Override
    protected void checkSaveableConditions(IBusinessObject bo) {
        TkzGms object = (TkzGms)bo;
    }

    @Override
    protected void checkValidationConditions(IBusinessObject bo) {
        try {
            TkzGms obj = (TkzGms)bo;
            if (obj.getGrad() >= 360) {
                this.addErrorToList("Die Gradzahl muss kleiner 360 sein");
            }
            if (obj.getMinuten() >= 60) {
                this.addErrorToList("Die Minutenzahl muss kleiner 60 sein");
            }
            if (obj.getSekunden() >= 60) {
                this.addErrorToList("Die Sekundenzahl muss kleiner 60 sein");
            }
        }
        catch (Exception e) {
            this.addErrorToList(" Fehler: " + e.getClass() + " / " + e.getMessage());
        }
    }
}

