/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.validation;

import de.cni.common.core.Brand;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Settings;
import de.cni.common.validation.ValidatorTemplate;

public class SettingsValidator
extends ValidatorTemplate {
    public SettingsValidator(Brand brand) {
        super(brand);
    }

    @Override
    protected void checkSaveableConditions(IBusinessObject bo) {
    }

    @Override
    protected void checkValidationConditions(IBusinessObject bo) {
        Settings object = (Settings)bo;
        this.pflichtfeld(object.getName(), "Name");
        if (!this.contains(object.getKopfzeile(), object.getName(), 3)) {
            this.addErrorToList("Der Name muss Bestandteil des sichtbaren Bereichs der Kopfzeile sein.");
        }
        if (!this.contains(object.getKopfzeileKurz(), object.getName(), 2)) {
            this.addErrorToList("Der Name muss Bestandteil des sichtbaren Bereichs der Kopfzeile sein.");
        }
    }

    private boolean contains(String s, String value, int upTo) {
        for (int lineNr = 1; lineNr <= upTo; ++lineNr) {
            String lineText = Util.getZeileFromText(s, lineNr);
            if (!lineText.contains(value)) continue;
            return true;
        }
        return false;
    }
}

