/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.validation;

import de.cni.common.core.Brand;
import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.validation.ValidatorTemplate;
import java.util.Date;

public class PersonendatenValidator
extends ValidatorTemplate {
    public PersonendatenValidator(Brand brand) {
        super(brand);
    }

    @Override
    protected void checkSaveableConditions(IBusinessObject bo) {
        Personendaten object = (Personendaten)bo;
    }

    @Override
    protected void checkValidationConditions(IBusinessObject bo) {
        Personendaten object = (Personendaten)bo;
        this.pflichtfeld(object.getGeburtsdatumLocal(), "Geburtsdatum (Ortszeit)");
        this.pflichtfeld(object.getGeburtszeitLocal(), "Geburtszeit (Ortszeit)");
        this.checkLatLong(object.getLatitude(), "Latitude");
        this.checkLatLong(object.getLongitude(), "Longitude");
        this.checkDate(object.getGeburtsdatumLocal(), "Geburtsdatum (Ortszeit)");
        this.checkDate(object.getGeburtsdatumUtc(), "Geburtsdatum (UTC)");
        this.checkUhrzeit(object.getGeburtszeitLocal(), "Geburtszeit (Ortszeit)");
        this.checkUhrzeit(object.getGeburtszeitUtc(), "Geburtszeit (UTC)");
        if (!Util.isEmpty(object.getWohnortLatitude()) || !Util.isEmpty(object.getWohnortLongitude())) {
            this.checkLatLong(object.getWohnortLatitude(), "Wohnort-Latitude");
            this.checkLatLong(object.getWohnortLongitude(), "Wohnort-Longitude");
        }
    }

    private void checkLatLong(String value, String name) {
        if (!value.matches("[+-]{0,1}[0-9]{1,3}") && !value.matches("[+-]{0,1}[0-9]{1,3}\\.[0-9]{1,6}")) {
            this.addErrorToList(name + " '" + value + "' ist nicht richtig formatiert: " + "(-)###.####");
            return;
        }
    }

    private void checkUhrzeit(String value, String name) {
        if (Util.isEmpty(value)) {
            return;
        }
        String error = DateUtil.checkTimeString(value, name);
        if (error != null) {
            this.addErrorToList(error);
        }
    }

    public void checkDate(String value, String name) {
        Date date;
        if (Util.isEmpty(value)) {
            return;
        }
        String error = DateUtil.checkDateString(value, name);
        if (error != null) {
            this.addErrorToList(error);
        }
        if ((date = Converter.stringToDate(value)) != null && (error = DateUtil.checkGeburtsdatum(value)) != null) {
            this.addErrorToList(error);
        }
    }
}

