/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.validation;

import de.cni.common.core.Brand;
import de.cni.common.datamodel.GmsKoordinate;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.validation.ValidatorTemplate;

public class GmsKoordinatenValidator
extends ValidatorTemplate {
    public GmsKoordinatenValidator(Brand brand) {
        super(brand);
    }

    @Override
    protected void checkSaveableConditions(IBusinessObject bo) {
        GmsKoordinate object = (GmsKoordinate)bo;
    }

    @Override
    protected void checkValidationConditions(IBusinessObject bo) {
        try {
            GmsKoordinate obj = (GmsKoordinate)bo;
            if (obj.getLatitudeGrad() >= 90) {
                this.addErrorToList("L\u00e4ngengrad: Die Gradzahl muss kleiner 90 sein");
            }
            if (obj.getLatitudeMinuten() >= 60) {
                this.addErrorToList("L\u00e4ngengrad: Die Minutenzahl muss kleiner 60 sein");
            }
            if (obj.getLatitudeSekunden() >= 60) {
                this.addErrorToList("L\u00e4ngengrad: Die Sekundenzahl muss kleiner 60 sein");
            }
            if (obj.getLongitudeGrad() >= 90) {
                this.addErrorToList("Breitengrad: Die Gradzahl muss kleiner 90 sein");
            }
            if (obj.getLongitudeMinuten() >= 60) {
                this.addErrorToList("Breitengrad: Die Minutenzahl muss kleiner 60 sein");
            }
            if (obj.getLongitudeSekunden() >= 60) {
                this.addErrorToList("Breitengrad: Die Sekundenzahl muss kleiner 60 sein");
            }
        }
        catch (Exception e) {
            this.addErrorToList(" Fehler: " + e.getClass() + " / " + e.getMessage());
        }
    }
}

