/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.validation;

import de.cni.common.core.Brand;
import de.cni.common.core.Constants;
import de.cni.common.core.Converter;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Analyse;
import de.cni.common.validation.ValidatorTemplate;

public class AnalyseValidator
extends ValidatorTemplate {
    public AnalyseValidator(Brand brand) {
        super(brand);
    }

    @Override
    protected void checkSaveableConditions(IBusinessObject bo) {
        Analyse object = (Analyse)bo;
    }

    @Override
    protected void checkValidationConditions(IBusinessObject bo) {
        try {
            Analyse obj = (Analyse)bo;
            if (!Util.isEmpty(obj.getPlanet1()) && !Util.equals(obj.getPlanet1(), Constants.planeten)) {
                this.addErrorToList(" Wert f\u00fcr 'Planet1' ist ung\u00fcltig: " + obj.getPlanet1());
            }
            if (!Util.isEmpty(obj.getPlanet2()) && !Util.equals(obj.getPlanet2(), Constants.planeten)) {
                this.addErrorToList(" Wert f\u00fcr 'Planet2' ist ung\u00fcltig: " + obj.getPlanet2());
            }
            if (!Util.isEmpty(obj.getTkz1()) && !Util.equals(obj.getTkz1(), Constants.tkz)) {
                this.addErrorToList(" Wert f\u00fcr 'Tierkreiszeichen' ist ung\u00fcltig: " + obj.getTkz1());
            }
            if (!Util.isEmpty(obj.getAspekt()) && !Util.equals(obj.getAspekt(), Constants.aspekt)) {
                this.addErrorToList(" Wert f\u00fcr 'Aspekt' ist ung\u00fcltig: " + obj.getAspekt());
            }
            if (!(Util.isEmpty(obj.getHaus()) || Converter.stringToInt(obj.getHaus()) >= 1 && Converter.stringToInt(obj.getHaus()) <= 12)) {
                this.addErrorToList(" Wert f\u00fcr 'Haus' ist ung\u00fcltig: " + obj.getHaus());
            }
        }
        catch (Exception e) {
            this.addErrorToList(" Fehler: " + e.getClass() + " / " + e.getMessage());
        }
    }
}

