/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.io;

import de.cni.client.gui.popup.filter.PopupFileDialog;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.FormattedStringBuffer;
import de.cni.common.core.Formatter;
import de.cni.common.core.GlobalData;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.CoreTexte;
import de.cni.common.datamodel.admin.CustomTexte;
import de.cni.common.datamodel.admin.Texte;
import de.cni.common.exceptions.CalculationException;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.InternalErrorException;
import de.cni.common.exceptions.MappingException;
import de.cni.common.exceptions.ReportException;
import de.cni.common.exceptions.TechnicalException;
import de.cni.common.io.AbstractFileImporter;
import de.cni.common.io.ColumnHandler;
import de.cni.common.io.FileProcessor;
import de.cni.common.validation.TexteValidator;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportTexte
extends AbstractFileImporter {
    private static Log log = LogFactory.getLog(ImportTexte.class);
    private static final int INTERVALL_ZWISCHENSUMME = 100;
    private static boolean COMMIT_ALLOWED = false;
    ColumnHandler columnHandler = new ColumnHandler(Spalte.values());
    private static String importFilename = "texte";
    private static String importExtension = "csv";
    private String resultFileName = importFilename;
    private int batchTimeout = 0;
    private boolean core;
    private boolean simulation;
    private Statistik statistik = new Statistik();
    private Texte element = null;
    SqLiteDatabase db = new SqLiteDatabase();
    TexteValidator validator;

    public String getResultString() throws IOException {
        if (this.statistik == null) {
            return "";
        }
        FormattedStringBuffer sb = new FormattedStringBuffer();
        int num_len = 10;
        sb.print("Datens\u00e4tze in der Datei       : ");
        sb.rprint(Formatter.reportNumber(this.statistik.anzInput), num_len);
        sb.newLine();
        sb.print("Datens\u00e4tze fehlerhaft         : ");
        sb.rprint(Formatter.reportNumber(this.statistik.anzErr), num_len);
        sb.newLine();
        sb.print("Datens\u00e4tze ok                 : ");
        sb.rprint(Formatter.reportNumber(this.statistik.anzOk), num_len);
        sb.newLine();
        sb.print("Datens\u00e4tze importiert         : ");
        sb.rprint(Formatter.reportNumber(this.statistik.anzImp), num_len);
        sb.newLine();
        sb.print("vorhandene Datens\u00e4tze beendet : ");
        sb.rprint(Formatter.reportNumber(this.statistik.anzTerminated), num_len);
        sb.newLine();
        return sb.toString();
    }

    public ImportTexte(FileProcessor fileProcessor, boolean simulation, boolean core) {
        super(fileProcessor);
        this.simulation = simulation;
        this.core = core;
        this.validator = new TexteValidator(GlobalData.getInstance().getBrand());
        this.now = new Date();
    }

    @Override
    public String getLogfileDir() throws InternalErrorException {
        return "./io";
    }

    @Override
    public String getImportDir() throws InternalErrorException {
        return "./io";
    }

    @Override
    public String getResultfileName() throws InternalErrorException {
        return this.resultFileName;
    }

    @Override
    public String getImportFilename() {
        return importFilename;
    }

    @Override
    public String getExtension() {
        return importExtension;
    }

    @Override
    public boolean line2object(String line) throws IOException, DatabaseException, MappingException, TechnicalException {
        log.debug((Object)"Start line2Object");
        boolean saveFlag = true;
        String first = ImportTexte.removeUTF8BOM(this.getCsvToken());
        String sp = Spalte.KEY.toString();
        if (Util.equalsIgnoreCase(first, sp)) {
            line = ImportTexte.removeUTF8BOM(line);
            this.columnHandler.prepareHeaderMap(line);
            return false;
        }
        this.columnHandler.fillValueMap(line + " ");
        this.element = this.core ? new CoreTexte() : new CustomTexte();
        this.element.setKey(this.columnHandler.getValue(Spalte.KEY));
        this.element.setKlasse(this.columnHandler.getValue(Spalte.KLASSE));
        this.element.setStufe(this.columnHandler.getIntValue(Spalte.STUFE));
        this.element.setUrl(this.columnHandler.getValue(Spalte.URL));
        this.element.setText(this.columnHandler.getValue(Spalte.TEXT));
        String t = this.columnHandler.getValue(Spalte.TEXT);
        if (!Util.isEmpty(t)) {
            t = t.replace("\\n", "\n");
        }
        this.element.setText(t);
        ++this.statistik.anzInput;
        if (!this.checkElement(this.element)) {
            ++this.statistik.anzErr;
            return false;
        }
        ++this.statistik.anzOk;
        log.debug((Object)"Ende line2Object");
        return saveFlag;
    }

    @Override
    public void save(boolean fast) throws DatabaseException {
        try {
            if (this.element == null) {
                return;
            }
            if (this.simulation) {
                return;
            }
            this.db.save(this.element);
            ++this.statistik.anzImp;
        }
        catch (Exception e) {
            ++this.statistik.anzErr;
            e.printStackTrace();
            throw new DatabaseException(DatabaseException.ErrorType.customText, e);
        }
    }

    @Override
    public boolean isRemoveFile() {
        return false;
    }

    @Override
    public void preImport() throws DatabaseException {
        if (this.simulation) {
            return;
        }
        try {
            this.statistik.anzTerminated = this.db.truncateTexte(this.core);
        }
        catch (Exception e) {
            throw new DatabaseException(DatabaseException.ErrorType.customText, e);
        }
    }

    @Override
    public void postImport() throws DatabaseException {
    }

    public static void doImport(boolean core) throws DatabaseException, CalculationException, ReportException {
        try {
            String filename = PopupFileDialog.openFileDialog("Texte einlesen", "", "*.csv");
            if (Util.isEmpty(filename)) {
                return;
            }
            boolean simulation = false;
            FileProcessor fp = FileProcessor.newTextFileProcessor("UTF-8");
            ImportTexte worker = new ImportTexte(fp, simulation, core);
            int n = fp.processImport(worker, filename);
            Popup.infoCourier(worker.getResultString());
        }
        catch (Exception e) {
            throw new CalculationException("Fehler beim Import. " + Util.NotNull(e.getMessage()));
        }
    }

    private boolean checkElement(Texte obj) {
        if (!this.validator.isValid(obj)) {
            try {
                for (String s : this.validator.getErrorList()) {
                    this.fileProcessor.getResultFile().println("Zeile " + this.getLineNumber() + ":  " + s);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private class Statistik {
        int anzInput;
        int anzErr;
        int anzOk;
        int anzImp;
        int anzTerminated;

        private Statistik() {
        }
    }

    static enum Spalte {
        KEY,
        KLASSE,
        STUFE,
        URL,
        TEXT;

    }
}

