/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.io;

import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.Formatter;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.exceptions.InternalErrorException;
import de.cni.common.exceptions.TechnicalException;
import de.cni.common.io.AbstractFileExporter;
import de.cni.common.io.AbstractFileImporter;
import de.cni.common.io.FileProcessorText;
import de.cni.common.io.ResultFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FileProcessor {
    private static Log log = LogFactory.getLog(FileProcessor.class);
    protected String filePrefix = "";
    protected int logIntervall = 2000;
    protected int LIMIT = 0;
    protected int bulkSize = 20;
    protected String FileExtension = ".txt";
    protected Writer writer = null;
    protected boolean newFileWasCreated = false;
    protected File exportFile = null;
    protected ResultFile resultFile = null;
    protected AbstractFileImporter importer = null;
    protected AbstractFileExporter exporter = null;
    protected String encoding = "";
    protected boolean multipleFiles;
    protected String currentFile;

    protected FileProcessor() {
    }

    protected FileProcessor(String encoding, boolean multipleFiles) {
        this.encoding = encoding;
        this.multipleFiles = multipleFiles;
    }

    protected abstract void openImportFile(String var1) throws IOException, InternalErrorException;

    protected abstract void closeImportFile() throws IOException;

    protected abstract String getNextLine() throws IOException;

    public static FileProcessor newTextFileProcessor(String encoding) {
        return new FileProcessorText(encoding, false);
    }

    public static FileProcessor newTextFileProcessor() {
        return new FileProcessorText(null, false);
    }

    public static FileProcessor newMultipleTextFileProcessor() {
        return new FileProcessorText(null, true);
    }

    public int processImport(AbstractFileImporter importer) throws TechnicalException {
        return this.processImport(importer, null);
    }

    public int processImport(final AbstractFileImporter importer, String filename) throws TechnicalException {
        try {
            this.importer = importer;
            if (!Util.isEmpty(filename)) {
                this.currentFile = filename;
                String basename = FilenameUtils.getBaseName((String)filename);
                int ret = this.doProcessImportFile(this.currentFile, basename, basename);
                return ret;
            }
            if (!this.multipleFiles) {
                this.currentFile = null;
                String basename = null;
                String importFilename = importer.getImportFilename();
                try {
                    this.currentFile = this.getAbsoluteImportFilename(importer.getImportFilename() + Formatter.dependingOnSecondString(".", importer.getExtension()));
                    basename = FilenameUtils.getBaseName((String)importer.getImportFilename());
                }
                catch (Exception e) {
                    throw new TechnicalException("Der absolute Pfad f\u00fcr die Import Datei " + importer.getImportFilename() + " kann nicht ermittelt werden.");
                }
                int ret = this.doProcessImportFile(this.currentFile, basename, null);
                return ret;
            }
            this.currentFile = null;
            String basename = null;
            String[] allFiles = new String[]{};
            try {
                File dir = new File(importer.getImportDir());
                allFiles = dir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.matches(importer.getImportFilename() + Formatter.dependingOnSecondString(".", importer.getExtension()));
                    }
                });
            }
            catch (Exception e) {
                throw new TechnicalException("Der absolute Pfad f\u00fcr die Import Datei " + importer.getImportFilename() + " kann nicht ermittelt werden.");
            }
            int ret = 0;
            for (String importFilename : allFiles) {
                try {
                    this.currentFile = this.getAbsoluteImportFilename(importFilename);
                    basename = FilenameUtils.getBaseName((String)importFilename);
                }
                catch (Exception e) {
                    throw new TechnicalException("Der absolute Pfad f\u00fcr die Import Datei " + importer.getImportFilename() + " kann nicht ermittelt werden.");
                }
                ret += this.doProcessImportFile(this.currentFile, basename, null);
            }
            return ret;
        }
        catch (TechnicalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TechnicalException("Es ist ein unerwarteter technischer Fehler aufgetreten.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doProcessImportFile(String absoluteImportFilename, String importFilename, String resultFilename) throws TechnicalException {
        int lastLogged = 0;
        long startTime = 0L;
        long endTime = 0L;
        int cnt = 0;
        String line = "";
        try {
            log.info((Object)("Import von " + absoluteImportFilename));
            startTime = System.currentTimeMillis();
            log.debug((Object)("Start: " + Converter.timeToString(new Date())));
            Thread.sleep(1000L);
            String extension = this.importer.getResultfileExtension();
            if (Util.isEmpty(resultFilename)) {
                String resultPath = this.importer.getResultfilePath();
                resultFilename = this.importer.getResultfileName();
                this.resultFile = new ResultFile(resultPath, resultFilename, extension, new Date());
            } else {
                this.resultFile = new ResultFile(FilenameUtils.getFullPath((String)absoluteImportFilename), resultFilename, extension, new Date());
            }
            this.importer.prepareNewFile();
            this.importer.preImport();
            this.openImportFile(absoluteImportFilename);
            while ((line = this.getNextLine()) != null) {
                cnt = this.importer.processLine(line);
                if (this.logIntervall > 0 && cnt % this.logIntervall == 0 && cnt != lastLogged) {
                    log.debug((Object)("  " + cnt + " Datens\u00e4tze migriert"));
                    lastLogged = cnt;
                }
                if (this.LIMIT == 0 || cnt < this.LIMIT) continue;
            }
            this.importer.postImport();
            cnt = this.importer.getNumProcessed();
            endTime = System.currentTimeMillis();
            log.info((Object)(cnt + " Datens\u00e4tze migriert"));
            log.info((Object)("Ende: " + Converter.timeToString(new Date())));
            log.info((Object)("Dauer:" + DateUtil.getTimeDiff(startTime, endTime)));
            this.resultFile.println("Es wurden " + Formatter.pReportNumber(cnt) + " Datens\u00e4tze eingelesen");
        }
        catch (TechnicalException e) {
            throw e;
        }
        catch (Exception e) {
            this.importer.handleError(importFilename, e);
        }
        finally {
            try {
                this.closeImportFile();
                if (this.resultFile != null) {
                    this.resultFile.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        if (this.importer.isRemoveFile()) {
            try {
                File file = new File(absoluteImportFilename);
                if (!file.delete()) {
                    throw new TechnicalException("Die Import-Datei kann nicht gel\u00f6scht werden. Datei:" + absoluteImportFilename);
                }
            }
            catch (TechnicalException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TechnicalException("Technischer Fehler.", e);
            }
        }
        if (this.importer.isMoveFileToHistorie()) {
            try {
                this.moveFileToHistorie(this.importer.getImportDir(), importFilename, this.importer.getExtension());
            }
            catch (Exception e) {
                throw new TechnicalException("Technischer Fehler.", e);
            }
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processExport(AbstractFileExporter exporter) throws TechnicalException {
        this.exporter = exporter;
        boolean lastLogged = false;
        long startTime = 0L;
        long endTime = 0L;
        int cnt = 0;
        String line = "";
        try {
            log.info((Object)("Export von " + exporter.getFilename()));
            startTime = System.currentTimeMillis();
            log.debug((Object)("Start: " + Converter.timeToString(new Date())));
            File exportFile = this.createExportFile(exporter);
            exporter.preExport();
            List<IBusinessObject> objectList = exporter.getObjectList();
            FileOutputStream outputStream = new FileOutputStream(exportFile);
            this.writer = !Util.isEmpty(this.encoding) ? new OutputStreamWriter((OutputStream)outputStream, this.encoding) : new OutputStreamWriter(outputStream);
            exporter.writeHeaderLine();
            if (!Util.isEmpty(exporter.getLine())) {
                this.writer.append(exporter.getLine());
            }
            for (IBusinessObject object : objectList) {
                cnt = exporter.processObject(object);
                this.writer.append(exporter.getLine());
            }
            exporter.postExport();
            endTime = System.currentTimeMillis();
            log.info((Object)("  " + cnt + " Datens\u00e4tze exportiert"));
            log.info((Object)("Ende: " + Converter.timeToString(new Date())));
            log.info((Object)("Dauer:" + DateUtil.getTimeDiff(startTime, endTime)));
        }
        catch (TechnicalException e) {
            this.removeExportFile();
            throw e;
        }
        catch (Exception e) {
            this.removeExportFile();
            exporter.handleError(null, e);
        }
        finally {
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return cnt;
    }

    private File createExportFile(AbstractFileExporter exporter) throws TechnicalException {
        try {
            String baseFilename = exporter.getBaseFilename();
            String baseDir = exporter.getBaseDir();
            this.exportFile = new File(exporter.getFilename());
            if (this.exportFile.exists()) {
                this.moveFileToHistorie(baseDir, baseFilename, exporter.getExtension());
                this.exportFile = new File(exporter.getFilename());
            }
            this.exportFile.createNewFile();
            return this.exportFile;
        }
        catch (Exception e) {
            throw new TechnicalException("Fehler beim Erzeugen der Export Datei. ", e);
        }
    }

    public void removeExportFile() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.newFileWasCreated && this.exportFile != null) {
                this.exportFile.delete();
            }
        }
        catch (Exception e) {
            log.error((Object)("Fehler beim L\u00f6schen der Datei " + this.exportFile.getAbsolutePath() + ". " + e.getMessage()));
        }
    }

    public void moveFileToHistorie(String baseDir, String baseFilename, String extension) throws IOException {
        log.debug((Object)"moveFileToHistorie - Start");
        String filename = baseFilename + "." + extension;
        File baseFile = new File(baseDir + File.separator + filename);
        String historyDir = baseDir + File.separator + "historie";
        String historieFilename = baseFilename + "_" + Converter.timeToExactSortableString(new Date()) + "." + extension;
        File historyFile = new File(historyDir + File.separator + historieFilename);
        if (baseFile.exists()) {
            log.debug((Object)("vorhandene Datei umbenennen in " + historyFile.getAbsolutePath()));
            if (!baseFile.renameTo(historyFile)) {
                throw new IOException("Die Datei kann nicht in das Archiv verschoben werden. Dateinamen:" + historyFile.getAbsolutePath());
            }
            log.debug((Object)("Historien-Datei:" + historyFile.getAbsoluteFile()));
            log.debug((Object)("Historien-Datei isFile=:" + historyFile.isFile()));
            this.newFileWasCreated = true;
        }
        log.debug((Object)"moveFileToHistorie - Ende");
    }

    public ResultFile getResultFile() {
        return this.resultFile;
    }

    public String getAbsoluteImportFilename(String importFilename) throws InternalErrorException {
        return Formatter.append(this.importer.getImportDir(), importFilename, File.separator);
    }

    public String getAbsoluteImportFilename() throws InternalErrorException {
        return this.getAbsoluteImportFilename(this.importer.getImportFilename() + Formatter.dependingOnSecondString(".", this.importer.getExtension()));
    }

    public String getCurrentFile() {
        return this.currentFile;
    }
}

