/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.io;

import de.cni.common.core.Converter;
import de.cni.common.core.Formatter;
import de.cni.common.core.Util;
import de.cni.common.io.AbstractExporter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportFile {
    private static Log log = LogFactory.getLog(ExportFile.class);
    BufferedWriter writer;
    OutputStreamWriter fileWriter;
    String filename;
    String encoding;

    public BufferedWriter getWriter() {
        return this.writer;
    }

    public ExportFile(String name) throws IOException {
        this.filename = name;
        OutputStreamWriter fileWriter = new OutputStreamWriter(new FileOutputStream(this.filename));
        this.writer = new BufferedWriter(fileWriter);
    }

    public ExportFile(String name, Charset encoding) throws IOException {
        this.filename = name;
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.filename), encoding);
        this.writer = new BufferedWriter(fileWriter);
    }

    public ExportFile(String path, String name, String extension, Date now) throws IOException {
        this.filename = now != null ? path + File.separator + name + "_" + Converter.timeToSortableString(now) + "." + extension : path + File.separator + name + "." + extension;
        FileWriter fileWriter = new FileWriter(this.filename);
        this.writer = new BufferedWriter(fileWriter);
    }

    public void close() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Fehler beim Schlie\u00dfen einer Datei." + e.getMessage()));
        }
    }

    public boolean removeMe() {
        boolean succ = true;
        this.close();
        File file = new File(this.filename);
        if (file.exists()) {
            succ = file.delete();
        }
        return succ;
    }

    public void blank() throws IOException {
        this.writer.write(" ");
    }

    public void blank(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writer.write(" ");
        }
    }

    public void repeat(String s, int n) throws IOException {
        if (s == null) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.writer.write(s);
        }
    }

    public void newLine() throws IOException {
        this.writer.write("\r\n");
    }

    public void csvSeparator() throws IOException {
        this.writer.write(";");
    }

    public void print(String text) throws IOException {
        if (text == null) {
            return;
        }
        this.writer.write(text);
    }

    public void print(Date text) throws IOException {
        this.writer.write(Converter.dateToString(text));
    }

    public void printCsvEncased(String text) throws IOException {
        if (text != null) {
            this.print("\"");
            this.print(text.replace(";", ""));
            this.print("\"");
        }
        this.csvSeparator();
    }

    public void printCsv(String text) throws IOException {
        if (text != null) {
            this.print(text.replace(";", ""));
        }
        this.csvSeparator();
    }

    public void printCsv(int text) throws IOException {
        this.print(text);
        this.csvSeparator();
    }

    public void printCsv(double text) throws IOException {
        this.print(text);
        this.csvSeparator();
    }

    public void printCsv(long text) throws IOException {
        this.print(text);
        this.csvSeparator();
    }

    public void printCsv(Date text) throws IOException {
        this.print(text);
        this.csvSeparator();
    }

    public void printCsv(Boolean text) throws IOException {
        this.print(Converter.booleanTo01String(text));
        this.csvSeparator();
    }

    public void printCsv(AbstractExporter.FORMAT format, int len, String text) throws IOException {
        if (format == AbstractExporter.FORMAT.LEADING_ZERO) {
            this.printCsv(Converter.stringToLeading0String(text, len));
        } else if (format == AbstractExporter.FORMAT.TRAILING_BLANK) {
            this.printCsv(Converter.stringToTrailingBlankString(text, len));
        } else {
            this.printCsv(text);
        }
    }

    public void printCsv(AbstractExporter.FORMAT format, int len, int text) throws IOException {
        if (format == AbstractExporter.FORMAT.LEADING_ZERO) {
            this.printCsv(Converter.intToLeading0String(text, len));
        } else {
            this.printCsv(text);
        }
    }

    public void printCsv(AbstractExporter.FORMAT format, int len, double text) throws IOException {
        if (format == AbstractExporter.FORMAT.LEADING_ZERO) {
            this.printCsv(Converter.doubleToLeading0String(text, len));
        } else {
            this.printCsv(Formatter.reportNumber(text));
        }
    }

    public void printCsv(AbstractExporter.FORMAT format, int len, long text) throws IOException {
        if (format == AbstractExporter.FORMAT.LEADING_ZERO) {
            this.printCsv(Converter.longToLeading0String(text, len));
        } else {
            this.printCsv(text);
        }
    }

    public void printCsv(AbstractExporter.FORMAT format, int len, Date text) throws IOException {
        this.print(text);
        this.csvSeparator();
    }

    public void printCsvEnd(String text) throws IOException {
        if (text == null) {
            this.print("");
        } else {
            this.print(text.replace(";", ""));
        }
        this.newLine();
    }

    public void printCsvEnd(int text) throws IOException {
        this.print(text);
        this.newLine();
    }

    public void printCsvEnd(double text) throws IOException {
        this.print(text);
        this.newLine();
    }

    public void printCsvEnd(long text) throws IOException {
        this.print(text);
        this.newLine();
    }

    public void printCsvEnd(Date text) throws IOException {
        this.print(text);
        this.newLine();
    }

    public void printSql(String text) throws IOException {
        this.writer.write(text.replace("\n", "\r\n"));
    }

    public void print(int text) throws IOException {
        this.writer.write(Converter.intToString(text));
    }

    public void print(long text) throws IOException {
        this.writer.write(Converter.longToString(text));
    }

    public void print(double text) throws IOException {
        this.writer.write(Converter.doubleToString(text));
    }

    public void println(String text) throws IOException {
        this.print(text);
        this.newLine();
    }

    public void println(int text) throws IOException {
        this.print(text);
        this.newLine();
    }

    public void println(long text) throws IOException {
        this.print(text);
        this.newLine();
    }

    public void println(double text) throws IOException {
        this.print(text);
        this.newLine();
    }

    public void lprint(String text, int len) throws IOException {
        text = Converter.stringToTrailingBlankString(Util.NotNull(text), len);
        text = Util.cutString(text, len);
        this.writer.write(text);
    }

    public void rprint(String text, int len) throws IOException {
        text = Converter.stringToLeadingBlankString(Util.NotNull(text), len);
        text = Util.cutString(text, len);
        this.writer.write(text);
    }

    public void lprint(int ntext, int len) throws IOException {
        String text = Converter.stringToTrailingBlankString(Converter.intToString(ntext), len);
        text = Util.cutString(text, len);
        this.writer.write(text);
    }

    public void rprint(int ntext, int len) throws IOException {
        String text = Converter.stringToLeadingBlankString(Converter.intToString(ntext), len);
        text = Util.cutString(text, len);
        this.writer.write(text);
    }

    public void lprint(long ntext, int len) throws IOException {
        String text = Converter.stringToTrailingBlankString(Converter.longToString(ntext), len);
        text = Util.cutString(text, len);
        this.writer.write(text);
    }

    public void rprint(long ntext, int len) throws IOException {
        String text = Converter.stringToLeadingBlankString(Converter.longToString(ntext), len);
        text = Util.cutString(text, len);
        this.writer.write(text);
    }

    public void lprint(double ntext, int len) throws IOException {
        String text = Converter.stringToTrailingBlankString(Converter.doubleToString(ntext), len);
        text = Util.cutString(text, len);
        this.writer.write(text);
    }

    public void rprint(double ntext, int len) throws IOException {
        String text = Converter.stringToLeadingBlankString(Converter.doubleToString(ntext), len);
        text = Util.cutString(text, len);
        this.writer.write(text);
    }

    public void printLeading0(String text, int len) throws IOException {
        text = Converter.stringToLeading0String(Util.NotNull(text), len);
        text = Util.cutString(text, len);
        this.writer.write(text);
    }

    public void printLeading0(int ntext, int len) throws IOException {
        String text = Converter.stringToLeading0String(Converter.intToString(ntext), len);
        text = Util.cutString(text, len);
        this.writer.write(text);
    }

    public void printLeading0(long ntext, int len) throws IOException {
        String text = Converter.stringToLeading0String(Converter.longToString(ntext), len);
        text = Util.cutString(text, len);
        this.writer.write(text);
    }

    public String getFilename() {
        return this.filename;
    }
}

